/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.IOException;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleDeclarationImpl;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.dom.DOMExceptionImpl;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.parser.selector.SelectorList;
import org.htmlunit.cssparser.util.ParserUtils;
import org.w3c.dom.DOMException;

public class CSSStyleRuleImpl
extends AbstractCSSRuleImpl {
    private SelectorList selectors_;
    private CSSStyleDeclarationImpl style_;

    public CSSStyleRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule, SelectorList selectors) {
        super(parentStyleSheet, parentRule);
        this.setSelectors(selectors);
    }

    public SelectorList getSelectors() {
        return this.selectors_;
    }

    public void setSelectors(SelectorList selectors) {
        this.selectors_ = selectors;
    }

    @Override
    public String getCssText() {
        CSSStyleDeclarationImpl style = this.getStyle();
        if (null == style) {
            return "";
        }
        String selectorText = this.selectors_.toString();
        String styleText = style.toString();
        if (null == styleText || styleText.length() == 0) {
            return selectorText + " { }";
        }
        return selectorText + " { " + styleText + "; }";
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            AbstractCSSRuleImpl r = parser.parseRule(cssText);
            if (!(r instanceof CSSStyleRuleImpl)) {
                throw new DOMExceptionImpl(13, 3);
            }
            this.selectors_ = ((CSSStyleRuleImpl)r).selectors_;
            this.style_ = ((CSSStyleRuleImpl)r).style_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getSelectorText() {
        return this.selectors_.toString();
    }

    public void setSelectorText(String selectorText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            this.selectors_ = parser.parseSelectors(selectorText);
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclarationImpl getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this.style_ = style;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleRuleImpl)) {
            return false;
        }
        CSSStyleRuleImpl csr = (CSSStyleRuleImpl)obj;
        return super.equals(obj) && ParserUtils.equals(this.getSelectorText(), csr.getSelectorText()) && ParserUtils.equals(this.getStyle(), csr.getStyle());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = ParserUtils.hashCode(hash, this.selectors_);
        hash = ParserUtils.hashCode(hash, this.style_);
        return hash;
    }
}

