/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolDefTool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolParameter;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeParam;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.AssignmentStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.BreakStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ContinueStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ElifStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ExitStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ForStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.IfStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ReturnStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Statement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ToolInvokeStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Variable;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.WhileStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.ExprsChecker;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.eclipse.escet.tooldef.typechecker.StatementsChecker;
import org.eclipse.escet.tooldef.typechecker.TypeHints;
import org.eclipse.escet.tooldef.typechecker.TypesChecker;

public class ToolsChecker {
    private ToolsChecker() {
    }

    public static void tcheck(ToolDefTool tool, CheckerContext ctxt) {
        CheckerContext newCtxt = new CheckerContext(ctxt, (PositionObject)tool);
        for (TypeParam param : tool.getTypeParams()) {
            newCtxt.addDecl((PositionObject)param);
        }
        for (ToolDefType type : tool.getReturnTypes()) {
            TypesChecker.tcheck(type, newCtxt);
        }
        EList params = tool.getParameters();
        for (ToolParameter param : params) {
            TypesChecker.tcheck(param.getType(), newCtxt);
            ToolDefType paramType = param.getType();
            if (param.getValue() == null) continue;
            TypeHints hints = new TypeHints();
            hints.add(paramType);
            ExprsChecker.tcheck(param.getValue(), newCtxt, hints);
            ToolDefType valueType = param.getValue().getType();
            if (param.isVariadic() || ToolDefTypeUtils.isSubType((ToolDefType)valueType, (ToolDefType)paramType)) continue;
            ctxt.addProblem(Message.TOOL_PARAM_VALUE_TYPE, param.getValue().getPosition(), ToolDefTextUtils.getAbsName((PositionObject)param), ToolDefTextUtils.typeToStr((ToolDefType)valueType), ToolDefTextUtils.typeToStr((ToolDefType)paramType));
        }
        int variadicCount = 0;
        for (ToolParameter param : params) {
            if (!param.isVariadic()) continue;
            ++variadicCount;
        }
        if (variadicCount > 1) {
            ctxt.addProblem(Message.TOOL_MULTIPLE_VARIADIC, tool.getPosition(), ToolDefTextUtils.getAbsName((PositionObject)tool));
        }
        for (ToolParameter param : params) {
            if (!param.isVariadic() || param.getValue() == null) continue;
            ctxt.addProblem(Message.TOOL_PARAM_VARIADIC_OPTIONAL, param.getPosition(), ToolDefTextUtils.getAbsName((PositionObject)param));
        }
        boolean mandatory = true;
        for (ToolParameter param : params) {
            boolean paramMandatory;
            boolean bl = paramMandatory = !param.isVariadic() && param.getValue() == null;
            if (mandatory == paramMandatory) continue;
            if (mandatory && !paramMandatory) {
                mandatory = paramMandatory;
                continue;
            }
            ctxt.addProblem(Message.TOOL_PARAM_ORDER, param.getPosition(), ToolDefTextUtils.getAbsName((PositionObject)param));
        }
        for (ToolParameter param : params) {
            if (!param.isVariadic()) continue;
            ListType type = ToolDefConstructors.newListType((ToolDefType)param.getType(), (Boolean)false, null);
            param.setType((ToolDefType)type);
        }
        for (ToolParameter param : params) {
            newCtxt.addDecl((PositionObject)param);
        }
        StatementsChecker.tcheck((List<Statement>)tool.getStatements(), newCtxt);
        if (!tool.getReturnTypes().isEmpty() && !ToolsChecker.mayEncounterReturn((List<Statement>)tool.getStatements())) {
            ctxt.addProblem(Message.TOOL_RETURN_MISSING, tool.getPosition(), ToolDefTextUtils.getAbsName((PositionObject)tool));
        }
        if (!ctxt.tchecker.hasError()) {
            newCtxt.checkUnused();
        }
        ctxt.addDecl((PositionObject)tool);
    }

    private static boolean mayEncounterReturn(List<Statement> stats) {
        for (Statement stat : stats) {
            EList body;
            if (stat instanceof AssignmentStatement) continue;
            if (stat instanceof BreakStatement) {
                return false;
            }
            if (stat instanceof ContinueStatement) {
                return false;
            }
            if (stat instanceof ExitStatement) {
                return true;
            }
            if (stat instanceof ForStatement) {
                body = ((ForStatement)stat).getStatements();
                if (!ToolsChecker.mayEncounterReturn((List<Statement>)body)) continue;
                return true;
            }
            if (stat instanceof IfStatement) {
                EList thens = ((IfStatement)stat).getThens();
                if (ToolsChecker.mayEncounterReturn((List<Statement>)thens)) {
                    return true;
                }
                for (ElifStatement elif : ((IfStatement)stat).getElifs()) {
                    if (!ToolsChecker.mayEncounterReturn((List<Statement>)elif.getThens())) continue;
                    return true;
                }
                EList elses = ((IfStatement)stat).getThens();
                if (!ToolsChecker.mayEncounterReturn((List<Statement>)elses)) continue;
                return true;
            }
            if (stat instanceof ReturnStatement) {
                return true;
            }
            if (stat instanceof ToolInvokeStatement || stat instanceof Variable) continue;
            if (stat instanceof WhileStatement) {
                body = ((WhileStatement)stat).getStatements();
                if (!ToolsChecker.mayEncounterReturn((List<Statement>)body)) continue;
                return true;
            }
            throw new RuntimeException("Unknown statement: " + String.valueOf(stat));
        }
        return false;
    }
}

