/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.migration.edapt;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.ReleaseUtils;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.execution.MigratorRegistry;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrationException;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdaptMigrator
implements EMFStoreMigrator {
    public Set<URI> canHandle(Set<URI> uris) {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        for (URI uri : uris) {
            if (uri.isFile()) continue;
            result.add(uri);
        }
        return result;
    }

    public Set<URI> needsMigration(Set<URI> uris) {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        LinkedHashMap<Set, Boolean> nsURIsToMigrationStateMap = new LinkedHashMap<Set, Boolean>();
        for (URI uri : uris) {
            Set nsURIs = ReleaseUtils.getAllNamespaceURIsFromPrefixes((URI)uri);
            if (nsURIs.isEmpty()) continue;
            if (nsURIsToMigrationStateMap.containsKey(nsURIs)) {
                if (!((Boolean)nsURIsToMigrationStateMap.get(nsURIs)).booleanValue()) continue;
                result.add(uri);
                continue;
            }
            Migrator migrator = EdaptMigrator.getMigrator(nsURIs);
            if (migrator == null) {
                nsURIsToMigrationStateMap.put(nsURIs, false);
                continue;
            }
            Set releases = migrator.getRelease(nsURIs);
            Release newestRelease = EdaptMigrator.getNewestRelease(releases);
            boolean migrationNeeded = !newestRelease.isLatestRelease();
            nsURIsToMigrationStateMap.put(nsURIs, migrationNeeded);
            if (!migrationNeeded) continue;
            result.add(uri);
        }
        return result;
    }

    static Migrator getMigrator(Set<String> nameSpaceURIs) {
        Migrator migrator = null;
        for (String nsURI : nameSpaceURIs) {
            Migrator candidate = MigratorRegistry.getInstance().getMigrator(nsURI);
            if (candidate == null) continue;
            if (migrator == null) {
                migrator = candidate;
                continue;
            }
            if (migrator == candidate) continue;
            ModelUtil.logWarning((String)MessageFormat.format("For the given name-space URIs {0} multiple Edapt Migrators were found.", nameSpaceURIs));
            return null;
        }
        return migrator;
    }

    static Release getNewestRelease(Set<Release> releases) {
        Release sourceRelease = null;
        for (Release release : releases) {
            if (sourceRelease == null) {
                sourceRelease = release;
                continue;
            }
            if (release.getNumber() <= sourceRelease.getNumber()) continue;
            sourceRelease = release;
        }
        return sourceRelease;
    }

    public void migrate(Set<URI> resources, IProgressMonitor monitor) throws EMFStoreMigrationException {
        monitor.beginTask("Migrating resources", resources.size());
        for (URI uri : resources) {
            Set nsURIs = ReleaseUtils.getAllNamespaceURIsFromPrefixes((URI)uri);
            Migrator migrator = EdaptMigrator.getMigrator(nsURIs);
            Set releases = migrator.getRelease(nsURIs);
            Release sourceRelease = EdaptMigrator.getNewestRelease(releases);
            try {
                migrator.migrateAndSave(Collections.singletonList(uri), sourceRelease, null, monitor, EdaptMigrator.getResourceSaveOptions());
                ModelUtil.logInfo((String)MessageFormat.format("Migrating file with URI {0} successfull.", uri));
            }
            catch (MigrationException ex) {
                ModelUtil.logInfo((String)MessageFormat.format("Migrating file with URI {0} failed.", uri));
                throw new EMFStoreMigrationException("Exception during migration", (Throwable)ex);
            }
            monitor.worked(1);
        }
    }

    private static Map<String, Object> getResourceSaveOptions() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map resourceSaveOptions = ModelUtil.getResourceSaveOptions();
        for (Object key : resourceSaveOptions.keySet()) {
            if (!String.class.isInstance(key)) continue;
            result.put((String)key, resourceSaveOptions.get(key));
        }
        return result;
    }
}

