/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.HistoryBrowserView;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESHistoryInfoImpl;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESHistoryInfo;
import org.eclipse.emf.emfstore.server.model.versionspec.ESTagVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIRemoveTagController
extends AbstractEMFStoreUIController<Void> {
    private final ESHistoryInfoImpl historyInfo;

    public UIRemoveTagController(Shell shell, ESHistoryInfo historyInfo) {
        super(shell);
        this.historyInfo = (ESHistoryInfoImpl)historyInfo;
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        Object[] result;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null || !(activePage.getActivePart() instanceof HistoryBrowserView)) {
            return null;
        }
        HistoryBrowserView historyBrowserView = (HistoryBrowserView)activePage.getActivePart();
        LabelProvider tagLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((ESTagVersionSpec)element).getName();
            }
        };
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)tagLabelProvider);
        dlg.setElements(this.historyInfo.getTagSpecs().toArray());
        dlg.setTitle(Messages.UIRemoveTagController_SelectTag);
        dlg.setBlockOnOpen(true);
        dlg.setMultipleSelection(true);
        int ret = dlg.open();
        if (ret != 0) {
            return null;
        }
        ProjectSpace projectSpace = historyBrowserView.getProjectSpace();
        Object[] objectArray = result = dlg.getResult();
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ESTagVersionSpec) {
                ESTagVersionSpec tag = (ESTagVersionSpec)o;
                try {
                    ((ESLocalProjectImpl)projectSpace.toAPI()).removeTag(this.historyInfo.getPrimarySpec(), tag, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ESException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.UIRemoveTagController_RemoveTagFailed_Title, (String)(String.valueOf(Messages.UIRemoveTagController_RemoveTagFailed_Message) + e.getMessage()));
                }
            }
            ++n2;
        }
        historyBrowserView.refresh();
        return null;
    }
}

