/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.Messages;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ProjectSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.VersionSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PathQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.RangeQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.server.ESServerURIUtil;
import org.eclipse.emf.emfstore.server.auth.ESMethod;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistorySubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    public HistorySubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalESException {
        super(parentInterface);
    }

    @Override
    protected void initSubInterface() throws FatalESException {
        super.initSubInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ESMethod(value=ESMethod.MethodId.ADDTAG)
    public void addTag(ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        this.sanityCheckObjects(projectId, versionSpec, tag);
        Object object = this.getMonitor();
        synchronized (object) {
            Version version = this.getSubInterface(VersionSubInterfaceImpl.class).getVersion(projectId, versionSpec);
            tag.setBranch(versionSpec.getBranch());
            version.getTagSpecs().add((Object)tag);
            try {
                this.save((EObject)version);
            }
            catch (FatalESException fatalESException) {
                throw new StorageException("Couldn't save data in database.");
            }
            if (ServerConfiguration.createProjectStateOnTag()) {
                URI projectStateURI = ESServerURIUtil.createProjectStateURI(projectId, version.getPrimarySpec());
                if (ESServerURIUtil.exists(projectStateURI)) {
                    return;
                }
                Project projectState = ProjectSubInterfaceImpl.getProjectFromVersion(version);
                try {
                    this.getResourceHelper().createResourceForProject(projectState, versionSpec, projectId);
                }
                catch (FatalESException fatalESException) {
                    throw new StorageException("Couldn't save data in database.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ESMethod(value=ESMethod.MethodId.REMOVETAG)
    public void removeTag(ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        this.sanityCheckObjects(projectId, versionSpec, tag);
        Object object = this.getMonitor();
        synchronized (object) {
            Version version = this.getSubInterface(VersionSubInterfaceImpl.class).getVersion(projectId, versionSpec);
            Iterator iterator = version.getTagSpecs().iterator();
            while (iterator.hasNext()) {
                if (!((TagVersionSpec)iterator.next()).getName().equals(tag.getName())) continue;
                iterator.remove();
            }
            try {
                this.save((EObject)version);
            }
            catch (FatalESException fatalESException) {
                throw new StorageException("Couldn't save data in database.");
            }
            if (ServerConfiguration.createProjectStateOnTag()) {
                URI projectStateURI = ESServerURIUtil.createProjectStateURI(projectId, version.getPrimarySpec());
                if (!ESServerURIUtil.exists(projectStateURI)) {
                    return;
                }
                if (VersionSubInterfaceImpl.shouldDeleteOldProjectStateAccordingToOptions(projectId, version, this.getResourceHelper())) {
                    this.getResourceHelper().deleteProjectState(version, projectId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ESMethod(value=ESMethod.MethodId.GETHISTORYINFO)
    public List<HistoryInfo> getHistoryInfo(ProjectId projectId, HistoryQuery<?> historyQuery) throws ESException {
        this.sanityCheckObjects(projectId, historyQuery);
        Object object = this.getMonitor();
        synchronized (object) {
            if (historyQuery instanceof RangeQuery) {
                return this.versionToHistoryInfo(projectId, this.handleRangeQuery(projectId, (RangeQuery)historyQuery), historyQuery.isIncludeChangePackages());
            }
            if (historyQuery instanceof PathQuery) {
                return this.versionToHistoryInfo(projectId, this.handlePathQuery(projectId, (PathQuery)historyQuery), historyQuery.isIncludeChangePackages());
            }
            return Collections.emptyList();
        }
    }

    private List<Version> handleRangeQuery(ProjectId projectId, RangeQuery<?> query) throws ESException {
        ProjectHistory project = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
        if (query.isIncludeAllVersions()) {
            return this.getAllVersions(project, this.sourceNumber((HistoryQuery<?>)query) - query.getLowerLimit(), this.sourceNumber((HistoryQuery<?>)query) + query.getUpperLimit(), true);
        }
        Version version = this.getSubInterface(VersionSubInterfaceImpl.class).getVersion(projectId, query.getSource());
        TreeSet<Version> result = new TreeSet<Version>(new VersionComparator(false));
        result.addAll(this.addForwardVersions(project, version, query.getUpperLimit(), query.isIncludeIncoming(), query.isIncludeOutgoing()));
        result.add(version);
        result.addAll(this.addBackwardVersions(project, version, query.getLowerLimit(), query.isIncludeIncoming(), query.isIncludeOutgoing()));
        return new ArrayList<Version>(result);
    }

    private List<Version> handlePathQuery(ProjectId projectId, PathQuery query) throws ESException {
        ProjectHistory project = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
        if (query.isIncludeAllVersions()) {
            List<Version> result = this.getAllVersions(project, this.sourceNumber((HistoryQuery<?>)query), this.targetNumber(query), false);
            if (this.targetNumber(query) > this.sourceNumber((HistoryQuery<?>)query)) {
                Collections.reverse(result);
            }
            return result;
        }
        if (query.getSource() == null || query.getTarget() == null) {
            throw new InvalidInputException();
        }
        List<Version> result = this.getSubInterface(VersionSubInterfaceImpl.class).getVersions(projectId, query.getSource(), query.getTarget());
        if (query.getTarget().compareTo((Object)query.getSource()) < 0) {
            Collections.reverse(result);
        }
        return result;
    }

    private int sourceNumber(HistoryQuery<?> query) throws ESException {
        if (query.getSource() == null) {
            throw new InvalidInputException();
        }
        return query.getSource().getIdentifier();
    }

    private int targetNumber(PathQuery query) throws ESException {
        if (query.getTarget() == null) {
            throw new InvalidInputException();
        }
        return query.getTarget().getIdentifier();
    }

    private List<Version> getAllVersions(ProjectHistory project, int from, int to, boolean tollerant) throws ESException {
        if (to < from) {
            return this.getAllVersions(project, to, from, tollerant);
        }
        EList versions = project.getVersions();
        int globalhead = versions.size() - 1;
        int start = to;
        int end = from;
        if (!(tollerant || from >= 0 && to >= 0 && from <= globalhead && to <= globalhead)) {
            throw new InvalidVersionSpecException(Messages.HistorySubInterfaceImpl_InvalidVersionSpec);
        }
        start = Math.min(globalhead, to);
        end = Math.max(0, from);
        if (start < 0 || start > globalhead || end < 0 || end > globalhead) {
            throw new InvalidVersionSpecException(Messages.HistorySubInterfaceImpl_InvalidVersionSpec);
        }
        if (start == end) {
            return Arrays.asList((Version)versions.get(start));
        }
        if (Math.abs(start - end) > Math.abs(to - from)) {
            throw new InvalidVersionSpecException(Messages.HistorySubInterfaceImpl_InvalidVersionSpec);
        }
        ArrayList<Version> result = new ArrayList<Version>();
        int i = start;
        while (i >= end) {
            result.add((Version)versions.get(i));
            --i;
        }
        return result;
    }

    private Collection<Version> addForwardVersions(ProjectHistory project, Version version, int limit, boolean includeIncoming, boolean includeOutgoing) {
        if (limit == 0) {
            return Collections.emptyList();
        }
        TreeSet<Version> result = new TreeSet<Version>(new VersionComparator(false));
        Version currentVersion = version;
        while (currentVersion != null && result.size() < limit) {
            if (includeOutgoing && currentVersion.getBranchedVersions().size() > 0) {
                result.addAll((Collection<Version>)currentVersion.getBranchedVersions());
            }
            if (includeIncoming && currentVersion.getMergedFromVersion().size() > 0) {
                result.addAll((Collection<Version>)currentVersion.getMergedFromVersion());
            }
            if ((currentVersion = currentVersion.getNextVersion()) == null) continue;
            result.add(currentVersion);
        }
        if (limit > 0 && result.size() > limit) {
            return new ArrayList<Version>(result).subList(0, limit);
        }
        return result;
    }

    private Collection<Version> addBackwardVersions(ProjectHistory project, Version version, int limit, boolean includeIncoming, boolean includeOutgoing) {
        if (limit == 0) {
            return Collections.emptyList();
        }
        TreeSet<Version> result = new TreeSet<Version>(new VersionComparator(false));
        Object currentVersion = version;
        while (currentVersion != null && result.size() < limit) {
            if (includeOutgoing && currentVersion.getBranchedVersions().size() > 0) {
                result.addAll((Collection<Version>)currentVersion.getBranchedVersions());
            }
            if (includeIncoming && currentVersion.getMergedFromVersion().size() > 0) {
                result.addAll((Collection<Version>)currentVersion.getMergedFromVersion());
            }
            if ((currentVersion = currentVersion.getPreviousVersion() != null ? currentVersion.getPreviousVersion() : (currentVersion.getAncestorVersion() != null ? currentVersion.getAncestorVersion() : null)) == null) continue;
            result.add((Version)currentVersion);
        }
        if (limit > 0 && result.size() > limit) {
            return new ArrayList<Version>(result).subList(0, limit);
        }
        return result;
    }

    private List<HistoryInfo> versionToHistoryInfo(ProjectId projectId, Collection<Version> versions, boolean includeCP) throws ESException {
        ArrayList<HistoryInfo> result = new ArrayList<HistoryInfo>();
        for (Version version : versions) {
            result.add(this.createHistoryInfo(projectId, version, includeCP));
        }
        return result;
    }

    private HistoryInfo createHistoryInfo(ProjectId projectId, Version version, boolean includeChangePackage) throws ESException {
        HistoryInfo history = VersioningFactory.eINSTANCE.createHistoryInfo();
        if (includeChangePackage && version.getChanges() != null) {
            history.setChangePackage((AbstractChangePackage)ModelUtil.clone((EObject)version.getChanges()));
        }
        history.setLogMessage((LogMessage)ModelUtil.clone((EObject)version.getLogMessage()));
        history.setPrimarySpec((PrimaryVersionSpec)ModelUtil.clone((EObject)version.getPrimarySpec()));
        if (version.getAncestorVersion() != null) {
            history.setPreviousSpec((PrimaryVersionSpec)ModelUtil.clone((EObject)version.getAncestorVersion().getPrimarySpec()));
        } else if (version.getPreviousVersion() != null) {
            history.setPreviousSpec((PrimaryVersionSpec)ModelUtil.clone((EObject)version.getPreviousVersion().getPrimarySpec()));
        }
        if (version.getNextVersion() != null) {
            history.getNextSpec().add((Object)((PrimaryVersionSpec)ModelUtil.clone((EObject)version.getNextVersion().getPrimarySpec())));
        }
        history.getNextSpec().addAll(this.addSpecs((List<Version>)version.getBranchedVersions()));
        history.getMergedFrom().addAll(this.addSpecs((List<Version>)version.getMergedFromVersion()));
        history.getMergedTo().addAll(this.addSpecs((List<Version>)version.getMergedToVersion()));
        this.setTags(projectId, version, history);
        return history;
    }

    private void setTags(ProjectId projectId, Version version, HistoryInfo history) throws ESException {
        ProjectHistory project = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
        if (version.getPrimarySpec().equals(project.getLastVersion().getPrimarySpec())) {
            history.getTagSpecs().add((Object)Versions.createTAG((String)"HEAD", (String)"___GLOBAL___"));
        }
        for (BranchInfo branch : project.getBranches()) {
            if (!version.getPrimarySpec().equals(branch.getHead())) continue;
            history.getTagSpecs().add((Object)Versions.createTAG((String)("HEAD: " + branch.getName()), (String)branch.getName()));
        }
        history.getTagSpecs().addAll((Collection)ModelUtil.clone((List)version.getTagSpecs()));
    }

    private List<PrimaryVersionSpec> addSpecs(List<Version> versions) {
        ArrayList<PrimaryVersionSpec> result = new ArrayList<PrimaryVersionSpec>();
        for (Version version : versions) {
            result.add((PrimaryVersionSpec)ModelUtil.clone((EObject)version.getPrimarySpec()));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VersionComparator
    implements Comparator<Version> {
        private final boolean asc;

        public VersionComparator(boolean asc) {
            this.asc = asc;
        }

        @Override
        public int compare(Version o1, Version o2) {
            PrimaryVersionSpec v1 = o1.getPrimarySpec();
            PrimaryVersionSpec v2 = o2.getPrimarySpec();
            if (v1 == null || v2 == null) {
                throw new IllegalStateException();
            }
            if (this.asc) {
                return v1.compareTo((Object)v2);
            }
            return v1.compareTo((Object)v2) * -1;
        }
    }
}

