/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutatorConfiguration;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetter;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEBigDecimal;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEBigInteger;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEBoolean;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEByte;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEByteArray;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEChar;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEDate;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEDouble;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEEnum;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEFloat;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEInt;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterELong;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEShort;
import org.eclipse.emf.emfstore.internal.modelmutator.intern.attribute.AttributeSetterEString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelMutatorUtil {
    public static final int DELETE_DELETE_COMMAND = 0;
    public static final int DELETE_CUT_CONTAINMENT = 1;
    public static final int DELETE_ECORE = 2;
    private Map<EClassifier, AttributeSetter<?>> attributeSetters;
    private final Map<EObject, List<EReference>> validContainmentReferences = new LinkedHashMap<EObject, List<EReference>>();
    private final Map<EObject, List<EReference>> validCrossReferences = new LinkedHashMap<EObject, List<EReference>>();
    private final Map<EReference, List<EClass>> allContainments = new LinkedHashMap<EReference, List<EClass>>();
    private final Map<EClass, List<EClass>> allSubClasses = new LinkedHashMap<EClass, List<EClass>>();
    private final Map<EPackage, List<EClass>> allClassesInPackage = new LinkedHashMap<EPackage, List<EClass>>();
    private final ModelMutatorConfiguration config;
    private List<EClass> allEClasses;

    public ModelMutatorUtil(ModelMutatorConfiguration config) {
        this.config = config;
    }

    public static EPackage getEPackage(String nsURI) {
        return EPackage.Registry.INSTANCE.getEPackage(nsURI);
    }

    public List<EReference> getValidContainmentReferences(EObject eObject) {
        List<EReference> list = this.validContainmentReferences.get(eObject);
        if (list == null) {
            list = new ArrayList<EReference>();
            for (EReference reference : eObject.eClass().getEAllReferences()) {
                if (!reference.isContainment() || !this.isValid((EStructuralFeature)reference, eObject)) continue;
                list.add(reference);
            }
            this.validContainmentReferences.put(eObject, list);
        }
        return list;
    }

    public List<EReference> getValidCrossReferences(EObject eObject) {
        List<EReference> list = this.validCrossReferences.get(eObject);
        if (list == null) {
            list = new ArrayList<EReference>();
            for (EReference reference : eObject.eClass().getEAllReferences()) {
                if (reference.isContainer() || reference.isContainment() || !this.isValid((EStructuralFeature)reference, eObject)) continue;
                list.add(reference);
            }
            this.validCrossReferences.put(eObject, list);
        }
        return list;
    }

    public boolean isValid(EStructuralFeature feature, EObject eObject) {
        boolean result;
        block3: {
            result = false;
            if (!feature.isMany()) break block3;
            Collection referencedItems = (Collection)eObject.eGet(feature);
            if (feature.getUpperBound() < 0 || referencedItems.size() < feature.getUpperBound()) break block3;
            return false;
        }
        try {
            result = feature.isChangeable() && !feature.isVolatile() && !feature.isDerived();
        }
        catch (RuntimeException e) {
            ModelMutatorUtil.handle(e, this.config);
        }
        return result;
    }

    private static void handle(RuntimeException exception, ModelMutatorConfiguration config) {
        if (!config.isIgnoreAndLog()) {
            throw exception;
        }
        config.getExceptionLog().add(exception);
    }

    public List<EClass> getAllEContainments(EReference reference) {
        List<EClass> list = this.allContainments.get(reference);
        if (list == null) {
            list = new ArrayList<EClass>();
            EClass referenceType = reference.getEReferenceType();
            if (EcorePackage.eINSTANCE.getEObject().equals(referenceType)) {
                for (EPackage ePackage : this.config.getModelPackages()) {
                    list.addAll(this.getAllEClasses(ePackage));
                }
            }
            if (ModelMutatorUtil.canHaveInstance(referenceType)) {
                list.add(referenceType);
            }
            list.addAll(this.getAllSubEClasses(referenceType));
            this.allContainments.put(reference, list);
        }
        return list;
    }

    public static boolean canHaveInstance(EClass eClass) {
        return !eClass.isInterface() && !eClass.isAbstract();
    }

    public List<EClass> getAllSubEClasses(EClass eClass) {
        List<EClass> list = this.allSubClasses.get(eClass);
        if (list == null) {
            list = new ArrayList<EClass>();
            List<EClass> allEClasses = this.getAllEClasses(this.config.getModelPackages());
            for (EClass possibleSubClass : allEClasses) {
                if (!eClass.isSuperTypeOf(possibleSubClass) || !ModelMutatorUtil.canHaveInstance(possibleSubClass)) continue;
                list.add(possibleSubClass);
            }
            this.allSubClasses.put(eClass, list);
        }
        return list;
    }

    public List<EClass> getAllEClasses() {
        if (this.allEClasses == null) {
            this.allEClasses = new ArrayList<EClass>();
            EPackage.Registry registry = EPackage.Registry.INSTANCE;
            for (Map.Entry entry : new LinkedHashSet(registry.entrySet())) {
                EPackage ePackage = registry.getEPackage((String)entry.getKey());
                for (EClass eClass : this.getAllEClasses(ePackage)) {
                    if (!ModelMutatorUtil.canHaveInstance(eClass)) continue;
                    this.allEClasses.add(eClass);
                }
            }
        }
        return this.allEClasses;
    }

    public List<EClass> getAllEClasses(Collection<EPackage> ePackages) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        for (EPackage ePackage : ePackages) {
            eClasses.addAll(this.getAllEClasses(ePackage));
        }
        return eClasses;
    }

    public List<EClass> getAllEClasses(EPackage ePackage) {
        List<EClass> list = this.allClassesInPackage.get(ePackage);
        if (list == null) {
            list = new ArrayList<EClass>();
            for (EPackage subPackage : ePackage.getESubpackages()) {
                list.addAll(this.getAllEClasses(subPackage));
            }
            for (EClassifier classifier : ePackage.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                list.add((EClass)classifier);
            }
            this.allClassesInPackage.put(ePackage, list);
        }
        return list;
    }

    public static Map<EClass, List<EObject>> getAllClassesAndObjects(EObject rootObject) {
        LinkedHashMap<EClass, List<EObject>> result = new LinkedHashMap<EClass, List<EObject>>();
        TreeIterator allContents = rootObject.eAllContents();
        ArrayList<EObject> newList = new ArrayList<EObject>();
        newList.add(rootObject);
        result.put(rootObject.eClass(), newList);
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (result.containsKey(eObject.eClass())) {
                ((List)result.get(eObject.eClass())).add(eObject);
                continue;
            }
            newList = new ArrayList();
            newList.add(eObject);
            result.put(eObject.eClass(), newList);
        }
        return result;
    }

    public void addPerCommand(EObject eObject, EStructuralFeature feature, Object newValue, Integer index) {
        try {
            if (feature.isUnique() && ((Collection)eObject.eGet(feature)).contains(newValue)) {
                return;
            }
            EditingDomain domain = this.config.getEditingDomain();
            if (index == null) {
                domain.getCommandStack().execute((Command)new AddCommand(domain, eObject, feature, newValue));
            } else {
                domain.getCommandStack().execute((Command)new AddCommand(domain, eObject, feature, newValue, index.intValue()));
            }
        }
        catch (RuntimeException e) {
            ModelMutatorUtil.handle(e, this.config);
        }
    }

    public void addPerCommand(EObject eObject, EStructuralFeature feature, Collection<?> objects) {
        try {
            for (Object object : objects) {
                if (!feature.isUnique() || !((Collection)eObject.eGet(feature)).contains(object)) continue;
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                return;
            }
            EditingDomain domain = this.config.getEditingDomain();
            domain.getCommandStack().execute((Command)new AddCommand(domain, eObject, feature, objects));
        }
        catch (RuntimeException e) {
            ModelMutatorUtil.handle(e, this.config);
        }
    }

    public void movePerCommand(EObject parent, EStructuralFeature feature, Object objectToMove, Integer index) {
        try {
            Collection containments = (Collection)parent.eGet(feature);
            if (!containments.contains(objectToMove)) {
                return;
            }
            EditingDomain domain = this.config.getEditingDomain();
            domain.getCommandStack().execute((Command)new MoveCommand(domain, parent, feature, objectToMove, index.intValue()));
        }
        catch (RuntimeException e) {
            ModelMutatorUtil.handle(e, this.config);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EObject setPerCommand(EObject eObject, EStructuralFeature feature, Object newValue, Integer index) {
        if (newValue == null && this.config.getRandom().nextBoolean()) {
            newValue = SetCommand.UNSET_VALUE;
        }
        try {
            EditingDomain domain = this.config.getEditingDomain();
            if (index != null) {
                if (feature.isUnique() && ((Collection)eObject.eGet(feature)).contains(newValue)) {
                    return null;
                }
                domain.getCommandStack().execute((Command)new SetCommand(domain, eObject, feature, newValue, index.intValue()));
            } else {
                domain.getCommandStack().execute((Command)new SetCommand(domain, eObject, feature, newValue));
            }
            if (newValue instanceof EObject) {
                return (EObject)newValue;
            }
            return null;
        }
        catch (RuntimeException e) {
            ModelMutatorUtil.handle(e, this.config);
            return null;
        }
    }

    public EObject setPerCommand(EObject eObject, EStructuralFeature feature, Object newValue) {
        return this.setPerCommand(eObject, feature, newValue, null);
    }

    public void removePerCommand(EObject eObject, EStructuralFeature feature, Collection<?> objects) {
        try {
            EditingDomain domain = this.config.getEditingDomain();
            domain.getCommandStack().execute((Command)new RemoveCommand(domain, eObject, feature, objects));
        }
        catch (RuntimeException e) {
            ModelMutatorUtil.handle(e, this.config);
        }
    }

    public void removeFullPerCommand(EObject eObject, int howToDelete) {
        block8: {
            try {
                EditingDomain domain = this.config.getEditingDomain();
                if (howToDelete == 0) {
                    domain.getCommandStack().execute((Command)new DeleteCommand(domain, Collections.singleton(eObject)));
                    break block8;
                }
                if (1 == howToDelete) {
                    EStructuralFeature feature = eObject.eContainingFeature();
                    if (feature == null) {
                        EcoreUtil.delete((EObject)eObject, (boolean)true);
                        return;
                    }
                    EObject eContainer = eObject.eContainer();
                    if (feature.isMany()) {
                        ((EList)eContainer.eGet(feature)).remove((Object)eObject);
                    } else {
                        eContainer.eSet(feature, null);
                    }
                    break block8;
                }
                if (2 == howToDelete) {
                    EcoreUtil.delete((EObject)eObject, (boolean)false);
                    break block8;
                }
                throw new IllegalArgumentException("This is not a valid delete mode argument: " + howToDelete);
            }
            catch (RuntimeException e) {
                ModelMutatorUtil.handle(e, this.config);
            }
        }
    }

    public void setEObjectAttributes(EObject eObject) {
        this.setEObjectAttributes(eObject, Integer.MAX_VALUE);
    }

    public void setEObjectAttributes(EObject eObject, int maxNumber) {
        Random random = this.config.getRandom();
        int numAttrLeft = maxNumber;
        for (EAttribute attribute : eObject.eClass().getEAllAttributes()) {
            AttributeSetter<?> attributeSetter;
            EDataType attributeType = attribute.getEAttributeType();
            if (random.nextBoolean() && eObject.eIsSet((EStructuralFeature)attribute) && attribute.isMany()) {
                this.removePerCommand(eObject, (EStructuralFeature)attribute, (Collection)eObject.eGet((EStructuralFeature)attribute));
            }
            if (!this.isValid((EStructuralFeature)attribute, eObject) || (attributeSetter = this.getAttributeSetter((EClassifier)attributeType)) == null) continue;
            if (attribute.isMany()) {
                int numberOfAttributes = ModelMutatorUtil.computeFeatureAmount((EStructuralFeature)attribute, random);
                int size = ((Collection)eObject.eGet((EStructuralFeature)attribute)).size();
                if (size == 0) {
                    this.addPerCommand(eObject, (EStructuralFeature)attribute, attributeSetter.createNewAttributes(numberOfAttributes));
                } else {
                    int i = 0;
                    while (i < size) {
                        if (random.nextBoolean()) {
                            this.setPerCommand(eObject, (EStructuralFeature)attribute, attributeSetter.createNewAttribute(), i);
                        } else {
                            Object attributeToMove = ((Collection)eObject.eGet((EStructuralFeature)attribute)).toArray()[random.nextInt(size)];
                            this.movePerCommand(eObject, (EStructuralFeature)attribute, attributeToMove, random.nextInt(size));
                        }
                        ++i;
                    }
                }
            } else {
                this.setPerCommand(eObject, (EStructuralFeature)attribute, attributeSetter.createNewAttribute());
            }
            if (--numAttrLeft != 0) continue;
            return;
        }
    }

    private static boolean isEnum(EClassifier attributeType) {
        return EcorePackage.eINSTANCE.getEEnum().isInstance((Object)attributeType);
    }

    private static int computeFeatureAmount(EStructuralFeature feature, Random random) {
        if (!feature.isMany()) {
            return 1;
        }
        if (feature.getUpperBound() < feature.getLowerBound()) {
            return random.nextInt(10);
        }
        return feature.getLowerBound() + random.nextInt(feature.getUpperBound() - feature.getLowerBound() + 1);
    }

    public Map<EClassifier, AttributeSetter<?>> getAttributeSetters() {
        if (this.attributeSetters == null) {
            Random random = this.config.getRandom();
            EcorePackage ecoreInstance = EcorePackage.eINSTANCE;
            this.attributeSetters = new LinkedHashMap();
            AttributeSetter oAttributeSetter = new AttributeSetterEBoolean(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEBoolean(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEBooleanObject(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEByteArray(), new AttributeSetterEByteArray(random, 100));
            this.attributeSetters.put((EClassifier)ecoreInstance.getEString(), new AttributeSetterEString(random));
            oAttributeSetter = new AttributeSetterEInt(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEInt(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEIntegerObject(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEDate(), new AttributeSetterEDate(random));
            oAttributeSetter = new AttributeSetterELong(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getELong(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getELongObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEByte(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEByte(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEByteObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEChar(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEChar(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getECharacterObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEDouble(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEDouble(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEDoubleObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEFloat(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEFloat(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEFloatObject(), oAttributeSetter);
            oAttributeSetter = new AttributeSetterEShort(random);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEShort(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEShortObject(), oAttributeSetter);
            this.attributeSetters.put((EClassifier)ecoreInstance.getEBigInteger(), new AttributeSetterEBigInteger(random));
            this.attributeSetters.put((EClassifier)ecoreInstance.getEBigDecimal(), new AttributeSetterEBigDecimal(random));
        }
        return this.attributeSetters;
    }

    private AttributeSetter<?> getAttributeSetter(EClassifier attributeType) {
        this.getAttributeSetters();
        if (this.attributeSetters.containsKey(attributeType)) {
            return this.attributeSetters.get(attributeType);
        }
        if (ModelMutatorUtil.isEnum(attributeType)) {
            return new AttributeSetterEEnum((EEnum)attributeType, this.config.getRandom());
        }
        return null;
    }

    public Set<EClass> getReferenceClasses(EReference reference, Set<EClass> allEClasses) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        EClass referenceType = reference.getEReferenceType();
        if (referenceType.equals(EcorePackage.eINSTANCE.getEObject())) {
            return allEClasses;
        }
        for (EClass eClass : allEClasses) {
            if (!referenceType.equals(eClass) && !referenceType.isSuperTypeOf(eClass)) continue;
            result.add(eClass);
        }
        return result;
    }

    public void setReference(EObject eObject, EClass referenceClass, EReference reference, Map<EClass, List<EObject>> allEObjects) {
        Random random = this.config.getRandom();
        List<EObject> possibleReferenceObjects = allEObjects.get(referenceClass);
        Collections.shuffle(possibleReferenceObjects, random);
        if (possibleReferenceObjects.isEmpty()) {
            return;
        }
        int index = 0;
        if (reference.isMany()) {
            int numberOfReferences = ModelMutatorUtil.computeFeatureAmount((EStructuralFeature)reference, random);
            numberOfReferences -= ((EList)eObject.eGet((EStructuralFeature)reference)).size();
            int i = 0;
            while (i < numberOfReferences) {
                EList ownerList = AbstractOverrideableCommand.getOwnerList((EObject)eObject, (EStructuralFeature)reference);
                int size = ownerList.size();
                if (size > 0 && random.nextBoolean()) {
                    if (random.nextBoolean()) {
                        Integer newIndex = reference.isOrdered() ? null : Integer.valueOf(random.nextInt(size));
                        this.setPerCommand(eObject, (EStructuralFeature)reference, possibleReferenceObjects.get(index), newIndex);
                    } else {
                        Object objectToMove = ownerList.get(random.nextInt(size));
                        this.movePerCommand(eObject, (EStructuralFeature)reference, objectToMove, index);
                    }
                } else {
                    this.addPerCommand(eObject, (EStructuralFeature)reference, possibleReferenceObjects.get(index), random.nextBoolean() && size > 0 ? Integer.valueOf(random.nextInt(size)) : null);
                }
                if (++index != possibleReferenceObjects.size()) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (random.nextBoolean() || reference.isRequired()) {
            this.setPerCommand(eObject, (EStructuralFeature)reference, possibleReferenceObjects.get(index));
        }
    }

    public static int getAllObjectsCount(EObject obj) {
        TreeIterator eAllContents = obj.eAllContents();
        int i = 0;
        while (eAllContents.hasNext()) {
            ++i;
            eAllContents.next();
        }
        return i;
    }
}

