/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.changetracking.ESCommandObserver;
import org.eclipse.emf.emfstore.client.handler.ESNotificationFilter;
import org.eclipse.emf.emfstore.client.observer.ESCommitObserver;
import org.eclipse.emf.emfstore.client.observer.ESUpdateObserver;
import org.eclipse.emf.emfstore.common.model.ESObjectContainer;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.EmptyRemovalsFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.FilterStack;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.TouchFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.TransientFilter;
import org.eclipse.emf.emfstore.internal.client.model.impl.IDEObjectCollectionDirtyStateListener;
import org.eclipse.emf.emfstore.internal.client.model.impl.Messages;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.EMFStoreResource;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.NotificationInfo;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePersister
implements ESCommandObserver,
IdEObjectCollectionChangeObserver,
ESCommitObserver,
ESUpdateObserver,
ESDisposable {
    private final FilterStack filterStack;
    private boolean isDirty;
    private boolean commandIsRunning;
    private Set<Resource> resources;
    private List<IDEObjectCollectionDirtyStateListener> listeners;
    private ESLocalProject localProject;

    public ResourcePersister(ESLocalProject localProject) {
        this.localProject = localProject;
        this.resources = new LinkedHashSet<Resource>();
        this.listeners = new ArrayList<IDEObjectCollectionDirtyStateListener>();
        this.filterStack = new FilterStack(new ESNotificationFilter[]{new TouchFilter(), new TransientFilter(), new EmptyRemovalsFilter()});
    }

    @Override
    public void commandStarted(Command command) {
        this.commandIsRunning = true;
    }

    @Override
    public void commandCompleted(Command command) {
        this.commandIsRunning = false;
        this.saveDirtyResources(false);
    }

    @Override
    public void commandFailed(Command command, Exception exception) {
        this.commandIsRunning = false;
    }

    protected void addResource(Resource resource) {
        if (resource != null) {
            this.resources.add(resource);
        }
    }

    public void saveDirtyResources(boolean force) {
        if (!force && !Configuration.getClientBehavior().isAutoSaveEnabled()) {
            return;
        }
        if (!force && !this.isDirty) {
            return;
        }
        if (this.resources == null) {
            return;
        }
        for (Resource resource : this.resources) {
            if (resource.getURI() == null || resource.getURI().toString().equals("")) continue;
            ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)ESLocalProjectImpl.class.cast(this.localProject)).toInternalAPI();
            if (EMFStoreResource.class.isInstance(resource) && resource == projectSpace.getProject().eResource()) {
                LinkedHashMap eObjectToIdMapping = new LinkedHashMap(projectSpace.getProject().getEObjectToIdMapping());
                LinkedHashMap idToEObjectMapping = new LinkedHashMap(projectSpace.getProject().getIdToEObjectMapping());
                ((EMFStoreResource)EMFStoreResource.class.cast(resource)).setIdToEObjectMap(idToEObjectMapping, eObjectToIdMapping);
            }
            try {
                if (projectSpace.getLocalChangePackage().eResource() == resource) {
                    projectSpace.getLocalChangePackage().save();
                    continue;
                }
                ModelUtil.saveResource((Resource)resource, (IResourceLogger)WorkspaceUtil.getResourceLogger());
            }
            catch (IOException iOException) {
                throw new RuntimeException(MessageFormat.format(Messages.ResourcePersister_SaveFailed, resource.getURI()));
            }
        }
        this.isDirty = false;
        this.fireDirtyStateChangedNotification();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void addDirtyStateChangeLister(IDEObjectCollectionDirtyStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeDirtyStateChangeLister(IDEObjectCollectionDirtyStateListener listener) {
        this.listeners.remove(listener);
    }

    public void notify(Notification notification, IdEObjectCollection collection, EObject modelElement) {
        if (this.filterStack.check(new NotificationInfo(notification).toAPI(), (ESObjectContainer<?>)collection)) {
            return;
        }
        this.isDirty = true;
        if (!this.commandIsRunning) {
            this.saveDirtyResources(false);
        }
    }

    public void modelElementAdded(IdEObjectCollection collection, EObject modelElement) {
        this.isDirty = true;
    }

    public void modelElementRemoved(IdEObjectCollection collection, EObject modelElement) {
        this.cleanResources(modelElement);
        this.isDirty = true;
    }

    public void collectionDeleted(IdEObjectCollection collection) {
    }

    private void cleanResources(EObject deletedElement) {
        Set allDeletedModelElements = ModelUtil.getAllContainedModelElements((EObject)deletedElement, (boolean)false);
        allDeletedModelElements.add(deletedElement);
        for (EObject element : allDeletedModelElements) {
            Resource childResource = element.eResource();
            if (childResource == null) continue;
            childResource.getContents().remove((Object)element);
        }
    }

    private void fireDirtyStateChangedNotification() {
        for (IDEObjectCollectionDirtyStateListener listener : this.listeners) {
            listener.notifyAboutDirtyStateChange();
        }
    }

    @Override
    public boolean inspectChanges(ESLocalProject project, List<ESChangePackage> changePackages, IProgressMonitor monitor) {
        if (this.localProject == project) {
            this.saveDirtyResources(true);
        }
        return true;
    }

    @Override
    public void updateCompleted(ESLocalProject project, IProgressMonitor monitor) {
        if (this.localProject == project) {
            this.saveDirtyResources(true);
        }
    }

    @Override
    public boolean inspectChanges(ESLocalProject project, ESChangePackage changePackage, IProgressMonitor monitor) {
        if (this.localProject == project) {
            this.saveDirtyResources(true);
        }
        return true;
    }

    @Override
    public void commitCompleted(ESLocalProject project, ESPrimaryVersionSpec newRevision, IProgressMonitor monitor) {
        if (this.localProject == project) {
            this.saveDirtyResources(true);
        }
    }

    public void dispose() {
        this.listeners = null;
        this.resources = null;
        this.localProject = null;
    }
}

