/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.rule.RuleRegistry;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.SettingPath;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.EnableRule;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Rule;
import org.eclipse.emf.ecp.view.spi.rule.model.ShowRule;

public class RuleService
implements ViewModelService {
    private static final String DOMAIN_MODEL_NULL_EXCEPTION = "Domain model must not be null.";
    private static final String VIEW_MODEL_NULL_EXCEPTION = "View model must not be null.";
    private ViewModelContext context;
    private ModelChangeAddRemoveListener domainChangeListener;
    private ModelChangeAddRemoveListener viewChangeListener;
    private RuleRegistry<EnableRule> enableRuleRegistry;
    private RuleRegistry<ShowRule> showRuleRegistry;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.enableRuleRegistry = new RuleRegistry(context);
        this.showRuleRegistry = new RuleRegistry(context);
        VElement view = context.getViewModel();
        this.domainChangeListener = new ModelChangeAddRemoveListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getStructuralFeature() == null) {
                    return;
                }
                EStructuralFeature.Setting setting = ((InternalEObject)notification.getNotifier()).eSetting(notification.getStructuralFeature());
                RuleService.this.evalShow(UniqueSetting.createSetting((EStructuralFeature.Setting)setting));
                RuleService.this.evalEnable(UniqueSetting.createSetting((EStructuralFeature.Setting)setting));
            }

            public void notifyAdd(Notifier notifier) {
            }

            public void notifyRemove(Notifier notifier) {
            }
        };
        context.registerDomainChangeListener((ModelChangeListener)this.domainChangeListener);
        this.viewChangeListener = new RuleServiceViewChangeListener(context);
        context.registerViewChangeListener((ModelChangeListener)this.viewChangeListener);
        if (view == null) {
            throw new IllegalStateException(VIEW_MODEL_NULL_EXCEPTION);
        }
        EObject domainModel = context.getDomainModel();
        if (domainModel == null) {
            throw new IllegalStateException(DOMAIN_MODEL_NULL_EXCEPTION);
        }
        Set<UniqueSetting> enableSettings = this.init(this.enableRuleRegistry, EnableRule.class, (EObject)view, domainModel);
        Set<UniqueSetting> showSettings = this.init(this.showRuleRegistry, ShowRule.class, (EObject)view, domainModel);
        for (UniqueSetting setting : enableSettings) {
            this.evalEnable(setting);
        }
        for (UniqueSetting setting : showSettings) {
            this.evalShow(setting);
        }
    }

    private static void resetToVisible(VElement renderable) {
        if (renderable == null) {
            return;
        }
        LinkedHashMap<VElement, Boolean> maps = new LinkedHashMap<VElement, Boolean>();
        RuleService.updateStateMap(maps, renderable, false, true, ShowRule.class);
        for (VElement vElement : maps.keySet()) {
            vElement.setVisible(((Boolean)maps.get(vElement)).booleanValue());
        }
    }

    private static void resetToEnabled(VElement renderable) {
        if (renderable == null) {
            return;
        }
        LinkedHashMap<VElement, Boolean> maps = new LinkedHashMap<VElement, Boolean>();
        RuleService.updateStateMap(maps, renderable, false, true, EnableRule.class);
        for (VElement vElement : maps.keySet()) {
            vElement.setEnabled(((Boolean)maps.get(vElement)).booleanValue());
        }
    }

    private static Rule getRule(VElement renderable) {
        for (VAttachment attachment : renderable.getAttachments()) {
            if (!Rule.class.isInstance(attachment)) continue;
            Rule rule = (Rule)attachment;
            return rule;
        }
        return null;
    }

    private static <T extends Rule> void updateStateMap(Map<VElement, Boolean> stateMap, VElement renderable, boolean isOpposite, boolean evalResult, Class<T> ruleType) {
        if (!stateMap.containsKey(renderable)) {
            Condition condition;
            boolean didUpdate = false;
            Rule rule = RuleService.getRule(renderable);
            if (rule != null && RuleService.ruleApplies(rule, ruleType) && (condition = rule.getCondition()) != null && RuleService.canOverrideParent(evalResult, isOpposite)) {
                boolean evaluate = condition.evaluate();
                stateMap.put(renderable, RuleService.isOpposite(rule) ? !evaluate : evaluate);
                didUpdate = true;
            }
            if (!didUpdate) {
                stateMap.put(renderable, isOpposite ? !evalResult : evalResult);
            }
        } else {
            Boolean currentState = (boolean)stateMap.get(renderable);
            if (currentState.booleanValue()) {
                stateMap.put(renderable, isOpposite ? !evalResult : evalResult);
            }
        }
        for (EObject childContent : renderable.eContents()) {
            if (!(childContent instanceof VElement)) continue;
            RuleService.updateStateMap(stateMap, (VElement)childContent, isOpposite, evalResult, ruleType);
        }
    }

    private static boolean canOverrideParent(boolean evalResult, boolean isOpposite) {
        return evalResult && !isOpposite || !evalResult && isOpposite;
    }

    private static <T extends Rule> boolean ruleApplies(Rule rule, Class<T> ruleType) {
        return Arrays.asList(rule.getClass().getInterfaces()).contains(ruleType);
    }

    private static boolean isOpposite(Rule rule) {
        return RuleService.isHideRule(rule) || RuleService.isDisableRule(rule);
    }

    private static <T extends Rule> boolean hasRule(Class<T> ruleType, EObject eObject) {
        if (!VElement.class.isInstance(eObject)) {
            return false;
        }
        VElement renderable = (VElement)eObject;
        Rule rule = RuleService.getRule(renderable);
        return ruleType.isInstance(rule);
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, UniqueSetting setting, boolean isDryRun, Map<EStructuralFeature.Setting, Object> possibleValues) {
        LinkedHashMap<VElement, Boolean> map = new LinkedHashMap<VElement, Boolean>();
        for (Map.Entry<T, VElement> ruleAndRenderable : registry.getAffectedRenderables(setting).entrySet()) {
            boolean isOposite;
            Rule rule = (Rule)ruleAndRenderable.getKey();
            VElement renderable = ruleAndRenderable.getValue();
            boolean hasChanged = true;
            if (!ruleType.isInstance(rule)) continue;
            if (isDryRun) {
                hasChanged = RuleService.checkDryRun(possibleValues);
            }
            boolean result = false;
            boolean updateMap = true;
            if (rule.getCondition() == null) {
                result = true;
            } else if (isDryRun && hasChanged) {
                result = rule.getCondition().evaluateChangedValues(possibleValues);
            } else if (!isDryRun) {
                result = rule.getCondition().evaluate();
            } else {
                updateMap = false;
            }
            boolean bl = isOposite = RuleService.isDisableRule(rule) || RuleService.isHideRule(rule);
            if (!(updateMap &= RuleService.propagateChanges(result, isOposite, rule, renderable))) continue;
            RuleService.updateStateMap(map, renderable, isOposite, result, ruleType);
        }
        return map;
    }

    private static boolean propagateChanges(boolean result, boolean isOposite, Rule rule, VElement renderable) {
        if (result && !isOposite || isOposite && !result) {
            if (ShowRule.class.isInstance(rule)) {
                if (isOposite && result != renderable.isVisible()) {
                    return false;
                }
                if (!isOposite && result == renderable.isVisible()) {
                    return false;
                }
            } else if (EnableRule.class.isInstance(rule)) {
                if (isOposite && result != renderable.isEnabled()) {
                    return false;
                }
                if (!isOposite && result == renderable.isEnabled()) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkDryRun(Map<EStructuralFeature.Setting, Object> possibleValues) {
        boolean hasChanged = true;
        for (EStructuralFeature.Setting setting : possibleValues.keySet()) {
            EObject parent = setting.getEObject();
            EStructuralFeature feature = setting.getEStructuralFeature();
            EClass attributeClass = feature.getEContainingClass();
            if (!attributeClass.isInstance((Object)parent)) continue;
            Object actualValue = parent.eGet(feature);
            Object newValue = possibleValues.get(setting);
            if (!feature.isMany()) {
                if (newValue == null) {
                    hasChanged &= actualValue == null;
                    continue;
                }
                hasChanged &= !newValue.equals(actualValue);
                continue;
            }
            List objects = (List)actualValue;
            List newValues = (List)newValue;
            if (objects.size() == newValues.size()) {
                boolean sameEntries = true;
                for (Object newValueListEntry : newValues) {
                    if (objects.contains(newValueListEntry)) continue;
                    sameEntries = false;
                }
                hasChanged &= !sameEntries;
                continue;
            }
            hasChanged = true;
        }
        return hasChanged;
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, UniqueSetting setting, Map<EStructuralFeature.Setting, Object> possibleValues) {
        return RuleService.evalAffectedRenderables(registry, ruleType, setting, true, possibleValues);
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, UniqueSetting setting) {
        Map<EStructuralFeature.Setting, Object> changedValues = Collections.emptyMap();
        return RuleService.evalAffectedRenderables(registry, ruleType, setting, false, changedValues);
    }

    private static boolean isDisableRule(Rule rule) {
        if (RuleService.isEnableRule(rule)) {
            EnableRule enableRule = (EnableRule)rule;
            return enableRule.isDisable();
        }
        return false;
    }

    private static boolean isHideRule(Rule rule) {
        if (RuleService.isShowRule(rule)) {
            ShowRule showRule = (ShowRule)rule;
            return showRule.isHide();
        }
        return false;
    }

    private static boolean isShowRule(Rule rule) {
        return rule instanceof ShowRule;
    }

    private <T extends Rule> void evalShow(UniqueSetting setting) {
        Map<VElement, Boolean> visibleMap = RuleService.evalAffectedRenderables(this.showRuleRegistry, ShowRule.class, setting);
        LinkedHashSet<VElement> toBeVisible = new LinkedHashSet<VElement>();
        LinkedHashSet<VElement> toBeInvisible = new LinkedHashSet<VElement>();
        for (Map.Entry<VElement, Boolean> e : visibleMap.entrySet()) {
            Boolean isVisible = e.getValue();
            VElement renderable = e.getKey();
            if (isVisible.booleanValue()) {
                toBeVisible.add(renderable);
                continue;
            }
            toBeInvisible.add(renderable);
        }
        for (VElement vElement : toBeInvisible) {
            vElement.setVisible(false);
        }
        for (VElement vElement : toBeVisible) {
            vElement.setVisible(true);
        }
    }

    private <T extends Rule> void evalEnable(UniqueSetting setting) {
        Map<VElement, Boolean> enabledMap = RuleService.evalAffectedRenderables(this.enableRuleRegistry, EnableRule.class, setting);
        for (Map.Entry<VElement, Boolean> e : enabledMap.entrySet()) {
            e.getKey().setEnabled(e.getValue().booleanValue());
        }
    }

    private <T extends Rule> Set<UniqueSetting> init(RuleRegistry<T> registry, Class<T> ruleType, EObject viewModel, EObject domainObject) {
        TreeIterator iterator = viewModel.eAllContents();
        LinkedHashSet<UniqueSetting> relevantSettings = new LinkedHashSet<UniqueSetting>();
        relevantSettings.addAll(this.register(registry, ruleType, domainObject, viewModel));
        while (iterator.hasNext()) {
            EObject content = (EObject)iterator.next();
            relevantSettings.addAll(this.register(registry, ruleType, domainObject, content));
        }
        return relevantSettings;
    }

    private <T extends Rule> Set<UniqueSetting> register(RuleRegistry<T> registry, Class<T> ruleType, EObject domainObject, EObject viewModel) {
        if (RuleService.hasRule(ruleType, viewModel)) {
            VElement renderable = (VElement)viewModel;
            Rule rule = RuleService.getRule(renderable);
            return registry.register(renderable, rule, rule.getCondition(), domainObject);
        }
        return Collections.emptySet();
    }

    public Map<VElement, Boolean> getDisabledRenderables(Map<EStructuralFeature.Setting, Object> possibleValues, UniqueSetting setting) {
        return RuleService.evalAffectedRenderables(this.enableRuleRegistry, EnableRule.class, setting, possibleValues);
    }

    public Map<VElement, Boolean> getHiddenRenderables(Map<EStructuralFeature.Setting, Object> possibleValues, UniqueSetting setting) {
        return RuleService.evalAffectedRenderables(this.showRuleRegistry, ShowRule.class, setting, possibleValues);
    }

    public void dispose() {
        this.context.unregisterDomainChangeListener((ModelChangeListener)this.domainChangeListener);
        this.context.unregisterViewChangeListener((ModelChangeListener)this.viewChangeListener);
    }

    private static boolean isEnableRule(Rule rule) {
        return EnableRule.class.isInstance(rule);
    }

    public int getPriority() {
        return 1;
    }

    private final class RuleServiceViewChangeListener
    implements ModelChangeAddRemoveListener {
        private final ViewModelContext context;

        private RuleServiceViewChangeListener(ViewModelContext context) {
            this.context = context;
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (VFeaturePathDomainModelReference.class.isInstance(notification.getNotifier())) {
                VElement renderable;
                if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getDomainModelReference_ChangeListener()) {
                    return;
                }
                VDomainModelReference domainModelReference = (VDomainModelReference)VDomainModelReference.class.cast(notification.getNotifier());
                EObject eContainer = domainModelReference.eContainer();
                if (!LeafCondition.class.isInstance(eContainer)) {
                    return;
                }
                Condition condition = (Condition)Condition.class.cast(eContainer);
                RuleService.this.enableRuleRegistry.removeCondition(condition);
                RuleService.this.showRuleRegistry.removeCondition(condition);
                EObject parent = condition.eContainer();
                while (parent != null && !Rule.class.isInstance(parent)) {
                    parent = parent.eContainer();
                }
                if (parent == null) {
                    return;
                }
                if (!Rule.class.isInstance(parent)) {
                    return;
                }
                Rule rule = (Rule)Rule.class.cast(parent);
                VElement vElement = renderable = VElement.class.isInstance(rule.eContainer()) ? (VElement)VElement.class.cast(rule.eContainer()) : null;
                if (renderable == null) {
                    return;
                }
                this.reevaluateRule(condition, rule, renderable);
            }
        }

        private void reevaluateRule(Condition condition, Rule rule, VElement renderable) {
            if (RuleService.isEnableRule(rule)) {
                if (RuleService.this.enableRuleRegistry.register(renderable, (EnableRule)rule, condition, this.context.getDomainModel()).isEmpty()) {
                    renderable.setEnabled(true);
                } else {
                    RuleService.resetToEnabled(renderable);
                }
            }
            if (RuleService.isShowRule(rule)) {
                if (RuleService.this.showRuleRegistry.register(renderable, (ShowRule)rule, condition, this.context.getDomainModel()).isEmpty()) {
                    renderable.setVisible(true);
                } else {
                    RuleService.resetToVisible(renderable);
                }
            }
        }

        public void notifyAdd(Notifier notifier) {
            block7: {
                block8: {
                    block6: {
                        if (!VElement.class.isInstance(notifier)) break block6;
                        RuleService.this.register(RuleService.this.enableRuleRegistry, EnableRule.class, this.context.getDomainModel(), (EObject)VElement.class.cast(notifier));
                        RuleService.this.register(RuleService.this.showRuleRegistry, ShowRule.class, this.context.getDomainModel(), (EObject)VElement.class.cast(notifier));
                        Rule rule = RuleService.getRule((VElement)VElement.class.cast(notifier));
                        if (rule == null) {
                            return;
                        }
                        if (LeafCondition.class.isInstance(rule.getCondition())) {
                            this.evalNewRules((LeafCondition)LeafCondition.class.cast(rule.getCondition()));
                        } else {
                            TreeIterator eAllContents = rule.getCondition().eAllContents();
                            while (eAllContents.hasNext()) {
                                EObject eObject = (EObject)eAllContents.next();
                                if (!LeafCondition.class.isInstance(eObject)) continue;
                                this.evalNewRules((LeafCondition)LeafCondition.class.cast(eObject));
                            }
                        }
                        break block7;
                    }
                    if (!EnableRule.class.isInstance(notifier)) break block8;
                    Set register = RuleService.this.register(RuleService.this.enableRuleRegistry, EnableRule.class, this.context.getDomainModel(), ((EnableRule)EnableRule.class.cast(notifier)).eContainer());
                    for (UniqueSetting setting : register) {
                        RuleService.this.evalEnable(setting);
                    }
                    break block7;
                }
                if (!ShowRule.class.isInstance(notifier)) break block7;
                Set register = RuleService.this.register(RuleService.this.showRuleRegistry, ShowRule.class, this.context.getDomainModel(), ((ShowRule)ShowRule.class.cast(notifier)).eContainer());
                for (UniqueSetting setting : register) {
                    RuleService.this.evalShow(setting);
                }
            }
        }

        private void evalNewRules(LeafCondition leafCondition) {
            Iterator fullPathIterator = leafCondition.getDomainModelReference().getFullPathIterator();
            while (fullPathIterator.hasNext()) {
                SettingPath settingPath = (SettingPath)fullPathIterator.next();
                Iterator settings = settingPath.getPath();
                while (settings.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settings.next();
                    RuleService.this.evalEnable(UniqueSetting.createSetting((EStructuralFeature.Setting)setting));
                    RuleService.this.evalShow(UniqueSetting.createSetting((EStructuralFeature.Setting)setting));
                }
            }
        }

        public void notifyRemove(Notifier notifier) {
            if (VElement.class.isInstance(notifier)) {
                VElement renderable = (VElement)VElement.class.cast(notifier);
                RuleService.this.showRuleRegistry.removeRenderable(renderable);
                RuleService.this.enableRuleRegistry.removeRenderable(renderable);
            } else if (Condition.class.isInstance(notifier)) {
                Condition condition = (Condition)Condition.class.cast(notifier);
                RuleService.resetToVisible(RuleService.this.showRuleRegistry.removeCondition(condition));
                RuleService.resetToEnabled(RuleService.this.enableRuleRegistry.removeCondition(condition));
            } else if (ShowRule.class.isInstance(notifier)) {
                ShowRule showRule = (ShowRule)ShowRule.class.cast(notifier);
                RuleService.resetToVisible(RuleService.this.showRuleRegistry.removeRule(showRule));
            } else if (EnableRule.class.isInstance(notifier)) {
                EnableRule enableRule = (EnableRule)EnableRule.class.cast(notifier);
                VElement removeRule = RuleService.this.enableRuleRegistry.removeRule(enableRule);
                RuleService.resetToEnabled(removeRule);
            }
        }
    }
}

