/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.ui;

import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.ui.Messages;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TabSvd
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "SVD Path";
    private static final String TAB_ID = "ilg.gnumcueclipse.debug.gdbjtag.ui.svdtab";
    private Text fSvdPath;
    private Button fBrowseButton;
    private Button fVariablesButton;

    public void createControl(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabSvd.createControl() ");
        }
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        Group group = new Group(comp, 0);
        GridLayout layout2 = new GridLayout();
        group.setLayout((Layout)layout2);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("TabSvd_group_text"));
        Composite groupComp = new Composite((Composite)group, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 5;
        layout3.marginHeight = 0;
        groupComp.setLayout((Layout)layout3);
        GridData gd2 = new GridData(768);
        groupComp.setLayoutData((Object)gd2);
        Label label = new Label(groupComp, 0);
        label.setText(Messages.getString("TabSvd_label_text"));
        label.setToolTipText(Messages.getString("TabSvd_label_tooltip"));
        Composite local = new Composite(groupComp, 0);
        GridLayout layout4 = new GridLayout();
        layout4.numColumns = 3;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        local.setLayout((Layout)layout4);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)groupComp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fSvdPath = new Text(local, 2052);
        gd3 = new GridData(768);
        this.fSvdPath.setLayoutData((Object)gd3);
        this.fSvdPath.setToolTipText(Messages.getString("TabSvd_label_tooltip"));
        this.fBrowseButton = new Button(local, 0);
        this.fBrowseButton.setText(Messages.getString("TabSvd_button_Browse_text"));
        this.fVariablesButton = new Button(local, 0);
        this.fVariablesButton.setText(Messages.getString("TabSvd_button_Variables_text"));
        this.fSvdPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabSvd.this.scheduleUpdateJob();
            }
        });
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabSvd.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbServerExecutableBrowse_Title"), TabSvd.this.fSvdPath);
            }
        });
        this.fVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabSvd.this.variablesButtonSelected(TabSvd.this.fSvdPath);
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabSvd.setDefaults() " + configuration.getName());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabSvd.initializeFrom() " + configuration.getName());
        }
        try {
            this.fSvdPath.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.svdPath", ""));
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabSvd.performApply() " + configuration.getName() + ", dirty=" + this.isDirty());
        }
        String svdPath = this.fSvdPath.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.svdPath", svdPath);
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return Activator.getInstance().getImage("peripheral");
    }

    public String getId() {
        return TAB_ID;
    }
}

