/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.dsf;

import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.DebugUtils;
import ilg.gnumcueclipse.debug.gdbjtag.dsf.GnuMcuCommandFactory;
import ilg.gnumcueclipse.debug.gdbjtag.dsf.GnuMcuControl_7_4;
import ilg.gnumcueclipse.debug.gdbjtag.dsf.GnuMcuDebuggerCommandsService;
import ilg.gnumcueclipse.debug.gdbjtag.dsf.GnuMcuGdbServerBackend;
import ilg.gnumcueclipse.debug.gdbjtag.dsf.GnuMcuProcesses_7_2_1;
import ilg.gnumcueclipse.debug.gdbjtag.services.IGdbServerBackendService;
import ilg.gnumcueclipse.debug.gdbjtag.services.IGnuMcuDebuggerCommandsService;
import ilg.gnumcueclipse.debug.gdbjtag.services.IPeripheralMemoryService;
import ilg.gnumcueclipse.debug.gdbjtag.services.IPeripheralsService;
import ilg.gnumcueclipse.debug.gdbjtag.services.PeripheralMemoryService;
import ilg.gnumcueclipse.debug.gdbjtag.services.PeripheralsService;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_0;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_2;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_4;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

public abstract class GnuMcuServicesFactory
extends GdbDebugServicesFactory {
    private final String fVersion;
    private String fMode;

    public GnuMcuServicesFactory(String version, String mode) {
        super(version, null);
        this.fVersion = version;
        this.fMode = mode;
    }

    public <V> V createService(Class<V> clazz, DsfSession session, Object ... optionalArguments) {
        block8: {
            block9: {
                block7: {
                    if (IPeripheralsService.class.isAssignableFrom(clazz)) {
                        return (V)this.createPeripheralsService(session);
                    }
                    if (!IPeripheralMemoryService.class.isAssignableFrom(clazz)) break block7;
                    Object[] objectArray = optionalArguments;
                    int n = optionalArguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object arg = objectArray[n2];
                        if (arg instanceof ILaunchConfiguration) {
                            return (V)this.createPeripheralMemoryService(session, (ILaunchConfiguration)arg);
                        }
                        ++n2;
                    }
                    break block8;
                }
                if (!IGnuMcuDebuggerCommandsService.class.isAssignableFrom(clazz)) break block9;
                Object[] objectArray = optionalArguments;
                int n = optionalArguments.length;
                int n3 = 0;
                while (n3 < n) {
                    Object arg = objectArray[n3];
                    if (arg instanceof ILaunchConfiguration) {
                        return (V)this.createDebuggerCommandsService(session, (ILaunchConfiguration)arg, this.fMode);
                    }
                    ++n3;
                }
                break block8;
            }
            if (!IGdbServerBackendService.class.isAssignableFrom(clazz)) break block8;
            Object[] objectArray = optionalArguments;
            int n = optionalArguments.length;
            int n4 = 0;
            while (n4 < n) {
                Object arg = objectArray[n4];
                if (arg instanceof ILaunchConfiguration) {
                    return (V)this.createGdbServerBackendService(session, (ILaunchConfiguration)arg);
                }
                ++n4;
            }
        }
        return (V)super.createService(clazz, session, optionalArguments);
    }

    protected abstract GnuMcuDebuggerCommandsService createDebuggerCommandsService(DsfSession var1, ILaunchConfiguration var2, String var3);

    protected abstract GnuMcuGdbServerBackend createGdbServerBackendService(DsfSession var1, ILaunchConfiguration var2);

    private PeripheralsService createPeripheralsService(DsfSession session) {
        return new PeripheralsService(session);
    }

    private PeripheralMemoryService createPeripheralMemoryService(DsfSession session, ILaunchConfiguration launchConfiguration) {
        return new PeripheralMemoryService(session, launchConfiguration);
    }

    protected ICommandControl createCommandControl(DsfSession session, ILaunchConfiguration config) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuServicesFactory.createCommandControl(" + session + "," + config.getName() + ") " + (Object)((Object)this));
        }
        if (DebugUtils.compareVersions("7.4", this.fVersion) <= 0) {
            return new GnuMcuControl_7_4(session, config, (CommandFactory)new GnuMcuCommandFactory(), this.fMode);
        }
        return super.createCommandControl(session, config);
    }

    protected IProcesses createProcessesService(DsfSession session) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuServicesFactory.createProcessesService(" + session + ") " + (Object)((Object)this));
        }
        if (DebugUtils.compareVersions("7.2.1", this.fVersion) <= 0) {
            return new GnuMcuProcesses_7_2_1(session);
        }
        return super.createProcessesService(session);
    }

    protected ICommandControl _createCommandControl(DsfSession session, ILaunchConfiguration config) {
        if (DebugUtils.compareVersions("7.4", this.fVersion) <= 0) {
            return new GDBControl_7_4(session, config, (CommandFactory)new GnuMcuCommandFactory());
        }
        if (DebugUtils.compareVersions("7.2", this.fVersion) <= 0) {
            return new GDBControl_7_2(session, config, (CommandFactory)new GnuMcuCommandFactory());
        }
        if (DebugUtils.compareVersions("7.0", this.fVersion) <= 0) {
            return new GDBControl_7_0(session, config, (CommandFactory)new GnuMcuCommandFactory());
        }
        return super.createCommandControl(session, config);
    }
}

