/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.riscv.core;

import java.io.File;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.Option;

public class EnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static boolean DEBUG_PATH = true;

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (PathEnvironmentVariable.isVar(variableName)) {
            return PathEnvironmentVariable.create(configuration);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.EnvironmentVariableSupplier.getVariable(" + variableName + "," + configuration.getName() + ") returns null");
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        PathEnvironmentVariable path = PathEnvironmentVariable.create(configuration);
        if (path != null) {
            return new IBuildEnvironmentVariable[]{path};
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.EnvironmentVariableSupplier.getVariables(" + configuration.getName() + ") returns empty array");
        }
        return new IBuildEnvironmentVariable[0];
    }

    private static class PathEnvironmentVariable
    implements IBuildEnvironmentVariable {
        public static String name = "PATH";
        private String path;

        private PathEnvironmentVariable(String path) {
            this.path = path;
        }

        public static PathEnvironmentVariable create(IConfiguration configuration) {
            PersistentPreferences commonPersistentPreferences;
            String buildToolsPath;
            IToolChain toolchain = configuration.getToolChain();
            IProject project = (IProject)configuration.getManagedProject().getOwner();
            Boolean preferXpacksBin = Option.getOptionBooleanValue(configuration, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.preferxpacksbin");
            ArrayList<String> path = new ArrayList<String>();
            if (preferXpacksBin.booleanValue()) {
                String xpackBinPath = project.getFolder("xpacks").getFolder(".bin").getLocation().toOSString();
                path.add(xpackBinPath);
            }
            if (!(buildToolsPath = (commonPersistentPreferences = org.eclipse.embedcdt.internal.managedbuild.cross.core.Activator.getInstance().getPersistentPreferences()).getBuildToolsPath(project)).isEmpty()) {
                path.add(buildToolsPath);
            }
            if (!preferXpacksBin.booleanValue()) {
                IOption optionId = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.id");
                String toolchainId = (String)optionId.getValue();
                IOption optionName = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name");
                String toolchainName = (String)optionName.getValue();
                String toolchainPath = "";
                PersistentPreferences persistentPreferences = Activator.getInstance().getPersistentPreferences();
                toolchainPath = persistentPreferences.getToolchainPath(toolchainId, toolchainName, project);
                if (!toolchainPath.isEmpty()) {
                    path.add(toolchainPath);
                }
            }
            if (!path.isEmpty()) {
                Stream<String> macrosResolved = path.stream().map(p -> {
                    if (p.indexOf("${") >= 0) {
                        p = PathEnvironmentVariable.resolveMacros(p, configuration);
                    }
                    return p;
                });
                String pathVar = macrosResolved.filter(Predicate.not(String::isBlank)).map(File::new).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
                if (DEBUG_PATH && Activator.getInstance().isDebugging()) {
                    System.out.println("riscv.PathEnvironmentVariable.create() PATH=\"" + pathVar + "\" cfg=" + configuration + " prj=" + configuration.getManagedProject().getOwner().getName());
                }
                return new PathEnvironmentVariable(pathVar);
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.println("riscv.PathEnvironmentVariable.create(" + configuration.getName() + ") returns null");
            }
            return null;
        }

        private static String resolveMacros(String str, IConfiguration configuration) {
            String result = str;
            try {
                result = ManagedBuildManager.getBuildMacroProvider().resolveValue(str, "", " ", 3, (Object)configuration);
            }
            catch (CdtVariableException e) {
                Activator.log((String)("riscv.PathEnvironmentVariable.resolveMacros " + e.getMessage()));
            }
            if (Activator.getInstance().isDebugging()) {
                Activator.log((String)("riscv.PathEnvironmentVariable.resolveMacros(\"" + str + "\", \"" + configuration.getName() + "\") = \"" + "\""));
            }
            return result;
        }

        public static boolean isVar(String name) {
            return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(PathEnvironmentVariable.name) : name.equals(PathEnvironmentVariable.name);
        }

        public String getDelimiter() {
            return Platform.getOS().equals("win32") ? ";" : ":";
        }

        public String getName() {
            return name;
        }

        public int getOperation() {
            return 3;
        }

        public String getValue() {
            return this.path;
        }
    }
}

