/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal.algorithm;

import com.google.common.math.DoubleMath;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.alg.common.nodespacing.internal.PortContext;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.PortPlacementCalculator;
import org.eclipse.elk.core.options.PortAlignment;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;

public final class HorizontalPortPlacementSizeCalculator {
    private static final double EQUALITY_TOLERANCE = 0.01;

    private HorizontalPortPlacementSizeCalculator() {
    }

    public static void calculateHorizontalPortPlacementSize(NodeContext nodeContext) {
        switch (nodeContext.portConstraints) {
            case FIXED_POS: {
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFixedPosPorts(nodeContext, PortSide.NORTH);
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFixedPosPorts(nodeContext, PortSide.SOUTH);
                break;
            }
            case FIXED_RATIO: {
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFixedRatioPorts(nodeContext, PortSide.NORTH);
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFixedRatioPorts(nodeContext, PortSide.SOUTH);
                break;
            }
            default: {
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFreePorts(nodeContext, PortSide.NORTH);
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFreePorts(nodeContext, PortSide.SOUTH);
            }
        }
    }

    private static void calculateHorizontalNodeSizeRequiredByFixedPosPorts(NodeContext nodeContext, PortSide portSide) {
        double rightmostPortBorder = 0.0;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            rightmostPortBorder = Math.max(rightmostPortBorder, portContext.portPosition.x + portContext.port.getSize().x);
        }
        AtomicCell cell = nodeContext.insidePortLabelCells.get(portSide);
        cell.getPadding().left = 0.0;
        cell.getMinimumContentAreaSize().x = rightmostPortBorder;
    }

    private static void calculateHorizontalNodeSizeRequiredByFixedRatioPorts(NodeContext nodeContext, PortSide portSide) {
        AtomicCell cell = nodeContext.insidePortLabelCells.get(portSide);
        Collection portContexts = nodeContext.portContexts.get((Object)portSide);
        if (portContexts.isEmpty()) {
            cell.getPadding().left = 0.0;
            cell.getPadding().right = 0.0;
            return;
        }
        boolean portLabelsInside = nodeContext.portLabelsPlacement.contains(PortLabelPlacement.INSIDE);
        double minWidth = 0.0;
        Iterator portContextIterator = portContexts.iterator();
        PortContext previousPortContext = null;
        double previousPortRatio = 0.0;
        double previousPortWidth = 0.0;
        while (portContextIterator.hasNext()) {
            PortContext currentPortContext = (PortContext)portContextIterator.next();
            double currentPortRatio = (Double)currentPortContext.port.getProperty(PortPlacementCalculator.PORT_RATIO_OR_POSITION);
            double currentPortWidth = currentPortContext.port.getSize().x;
            if (nodeContext.sizeConstraints.contains(SizeConstraint.PORT_LABELS)) {
                HorizontalPortPlacementSizeCalculator.setupPortMargins(nodeContext, portSide);
            }
            if (previousPortContext == null) {
                if (nodeContext.surroundingPortMargins != null && nodeContext.surroundingPortMargins.left > 0.0) {
                    minWidth = Math.max(minWidth, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(nodeContext.surroundingPortMargins.left + currentPortContext.portMargin.left, 0.0, currentPortRatio));
                }
            } else {
                double requiredSpace = previousPortWidth + previousPortContext.portMargin.right + nodeContext.portPortSpacing + currentPortContext.portMargin.left;
                minWidth = Math.max(minWidth, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(requiredSpace, previousPortRatio, currentPortRatio));
            }
            previousPortContext = currentPortContext;
            previousPortRatio = currentPortRatio;
            previousPortWidth = currentPortWidth;
        }
        if (nodeContext.surroundingPortMargins != null && nodeContext.surroundingPortMargins.right > 0.0) {
            double requiredSpace = previousPortWidth + nodeContext.surroundingPortMargins.right;
            if (portLabelsInside) {
                requiredSpace += previousPortContext.portMargin.right;
            }
            minWidth = Math.max(minWidth, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(requiredSpace, previousPortRatio, 1.0));
        }
        cell.getPadding().left = 0.0;
        cell.getMinimumContentAreaSize().x = minWidth;
    }

    static double minSizeRequiredToRespectSpacing(double spacing, double firstRatio, double secondRatio) {
        assert (secondRatio >= firstRatio);
        if (DoubleMath.fuzzyEquals((double)firstRatio, (double)secondRatio, (double)0.01)) {
            return 0.0;
        }
        return spacing / (secondRatio - firstRatio);
    }

    private static void calculateHorizontalNodeSizeRequiredByFreePorts(NodeContext nodeContext, PortSide portSide) {
        AtomicCell cell = nodeContext.insidePortLabelCells.get(portSide);
        if (nodeContext.portContexts.get((Object)portSide).isEmpty()) {
            cell.getPadding().left = 0.0;
            cell.getPadding().right = 0.0;
            return;
        }
        cell.getPadding().left = nodeContext.surroundingPortMargins.left;
        cell.getPadding().right = nodeContext.surroundingPortMargins.right;
        if (nodeContext.sizeConstraints.contains(SizeConstraint.PORT_LABELS)) {
            HorizontalPortPlacementSizeCalculator.setupPortMargins(nodeContext, portSide);
        }
        double width = HorizontalPortPlacementSizeCalculator.portWidthPlusPortPortSpacing(nodeContext, portSide);
        if (nodeContext.getPortAlignment(portSide) == PortAlignment.DISTRIBUTED) {
            width += 2.0 * nodeContext.portPortSpacing;
        }
        cell.getMinimumContentAreaSize().x = width;
    }

    private static void setupPortMargins(NodeContext nodeContext, PortSide portSide) {
        Collection portContexts = nodeContext.portContexts.get((Object)portSide);
        boolean portLabelsOutside = nodeContext.portLabelsPlacement.contains(PortLabelPlacement.OUTSIDE);
        boolean alwaysSameSide = nodeContext.portLabelsPlacement.contains(PortLabelPlacement.ALWAYS_SAME_SIDE);
        boolean spaceEfficient = nodeContext.portLabelsPlacement.contains(PortLabelPlacement.SPACE_EFFICIENT);
        boolean uniformPortSpacing = nodeContext.sizeOptions.contains(SizeOptions.UNIFORM_PORT_SPACING);
        boolean spaceEfficientPortLabels = !alwaysSameSide && (spaceEfficient || portContexts.size() == 2);
        HorizontalPortPlacementSizeCalculator.computeHorizontalPortMargins(nodeContext, portSide, portLabelsOutside);
        PortContext leftmostPortContext = null;
        PortContext rightmostPortContext = null;
        if (portLabelsOutside) {
            Iterator portContextIterator = portContexts.iterator();
            rightmostPortContext = leftmostPortContext = (PortContext)portContextIterator.next();
            while (portContextIterator.hasNext()) {
                rightmostPortContext = (PortContext)portContextIterator.next();
            }
            leftmostPortContext.portMargin.left = 0.0;
            rightmostPortContext.portMargin.right = 0.0;
            if (spaceEfficientPortLabels && !leftmostPortContext.labelsNextToPort) {
                leftmostPortContext.portMargin.right = 0.0;
            }
        }
        if (uniformPortSpacing) {
            HorizontalPortPlacementSizeCalculator.unifyPortMargins(portContexts);
            if (portLabelsOutside) {
                leftmostPortContext.portMargin.left = 0.0;
                rightmostPortContext.portMargin.right = 0.0;
            }
        }
    }

    private static void computeHorizontalPortMargins(NodeContext nodeContext, PortSide portSide, boolean portLabelsOutside) {
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            double labelWidth;
            double d = labelWidth = portContext.portLabelCell != null ? portContext.portLabelCell.getMinimumWidth() : 0.0;
            if (!(labelWidth > 0.0)) continue;
            if (portContext.labelsNextToPort) {
                double overhang;
                double portWidth = portContext.port.getSize().x;
                if (!(labelWidth > portWidth)) continue;
                portContext.portMargin.left = overhang = (labelWidth - portWidth) / 2.0;
                portContext.portMargin.right = overhang;
                continue;
            }
            portContext.portMargin.right = nodeContext.portLabelSpacing + labelWidth;
        }
    }

    private static void unifyPortMargins(Collection<PortContext> portContexts) {
        double maxLeft = 0.0;
        double maxRight = 0.0;
        for (PortContext portContext : portContexts) {
            maxLeft = Math.max(maxLeft, portContext.portMargin.left);
            maxRight = Math.max(maxRight, portContext.portMargin.right);
        }
        for (PortContext portContext : portContexts) {
            portContext.portMargin.left = maxLeft;
            portContext.portMargin.right = maxRight;
        }
    }

    private static double portWidthPlusPortPortSpacing(NodeContext nodeContext, PortSide portSide) {
        double result = 0.0;
        Iterator portContextIterator = nodeContext.portContexts.get((Object)portSide).iterator();
        while (portContextIterator.hasNext()) {
            PortContext portContext = (PortContext)portContextIterator.next();
            result += portContext.portMargin.left + portContext.port.getSize().x + portContext.portMargin.right;
            if (!portContextIterator.hasNext()) continue;
            result += nodeContext.portPortSpacing;
        }
        return result;
    }
}

