/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.dot.transform;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.elk.alg.graphviz.dot.dot.Attribute;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeType;
import org.eclipse.elk.alg.graphviz.dot.dot.DotFactory;
import org.eclipse.elk.alg.graphviz.dot.dot.EdgeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.EdgeTarget;
import org.eclipse.elk.alg.graphviz.dot.dot.Graph;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphType;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphvizModel;
import org.eclipse.elk.alg.graphviz.dot.dot.Node;
import org.eclipse.elk.alg.graphviz.dot.dot.NodeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.Statement;
import org.eclipse.elk.alg.graphviz.dot.dot.Subgraph;
import org.eclipse.elk.alg.graphviz.dot.transform.Command;
import org.eclipse.elk.alg.graphviz.dot.transform.IDotTransformationData;
import org.eclipse.elk.core.UnsupportedGraphException;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;

public class DotExporter {
    public static final double DEF_SPACING_SMALL = 20.0;
    public static final double DEF_SPACING_LARGE = 40.0;
    public static final double DEF_SPACING_XLARGE = 60.0;
    public static final float DPI = 72.0f;
    public static final IProperty<Command> COMMAND = new Property("dotExporter.command", (Object)Command.DOT);
    public static final IProperty<Boolean> USE_EDGE_IDS = new Property("dotExporter.useEdgeIds", (Object)false);
    public static final IProperty<Boolean> HIERARCHY = new Property("dotExporter.hierarchy", (Object)false);
    public static final IProperty<Boolean> TRANSFORM_NODE_LAYOUT = new Property("dotExporter.transformNodeLayout", (Object)true);
    public static final IProperty<Boolean> TRANSFORM_EDGE_LAYOUT = new Property("dotExporter.transformEdgeLayout", (Object)true);
    public static final IProperty<Boolean> TRANSFORM_NODE_LABELS = new Property("dotExporter.transformNodeLabels", (Object)true);
    public static final IProperty<Boolean> ADAPT_PORT_POSITIONS = new Property("dotExporter.adaptPortPositions", (Object)false);
    private static final double FONT_SIZE_MULT = 1.4;
    private static final String ATTRIBUTE_DELIM = "\", \t\n\r";
    private static final IProperty<BiMap<String, ElkGraphElement>> GRAPH_ELEMS = new Property("dotExporter.graphElemMap");
    protected static final IProperty<Boolean> USE_SPLINES = new Property("dotExporter.useSplines", (Object)false);
    private static final IProperty<Integer> NEXT_NODE_ID = new Property("dotExporter.nextNodeId", (Object)1);
    private static final IProperty<Integer> NEXT_EDGE_ID = new Property("dotExporter.nextEdgeId", (Object)1);
    private static final IProperty<String> CLUSTER_DUMMY = new Property("dotExporter.clusterDummy");
    private static final char MIN_OUT_CHAR = ' ';
    private static final char MAX_OUT_CHAR = '~';

    public void transform(IDotTransformationData<ElkNode, GraphvizModel> transData) {
        HashBiMap graphElems = HashBiMap.create();
        transData.setProperty(GRAPH_ELEMS, graphElems);
        ElkNode elkgraph = transData.getSourceGraph();
        GraphvizModel graphvizModel = DotFactory.eINSTANCE.createGraphvizModel();
        Graph graph = DotFactory.eINSTANCE.createGraph();
        graph.setType(GraphType.DIGRAPH);
        graphvizModel.getGraphs().add((Object)graph);
        this.transformNodes(elkgraph, (List<Statement>)graph.getStatements(), new KVector(), transData);
        this.transformEdges(elkgraph, (List<Statement>)graph.getStatements(), transData);
        transData.getTargetGraphs().add(graphvizModel);
    }

    public void transferLayout(IDotTransformationData<ElkNode, GraphvizModel> transData) {
        ElkPadding padding = (ElkPadding)transData.getSourceGraph().getProperty(CoreOptions.PADDING);
        Graph graph = (Graph)transData.getTargetGraphs().get(0).getGraphs().get(0);
        KVector baseOffset = new KVector();
        this.applyLayout(transData.getSourceGraph(), (List<Statement>)graph.getStatements(), baseOffset, padding, transData);
        LinkedList<Statement> statements = new LinkedList<Statement>((Collection<Statement>)graph.getStatements());
        KVector edgeOffset = baseOffset.add(padding.getLeft(), padding.getTop());
        while (!statements.isEmpty()) {
            Statement statement = statements.removeFirst();
            if (statement instanceof EdgeStatement) {
                this.applyEdgeLayout((EdgeStatement)statement, edgeOffset, transData);
                continue;
            }
            if (!(statement instanceof Subgraph)) continue;
            statements.addAll((Collection<Statement>)((Subgraph)statement).getStatements());
        }
    }

    private void transformNodes(ElkNode parent, List<Statement> statements, KVector offset, IDotTransformationData<ElkNode, GraphvizModel> transData) {
        this.setGraphAttributes(statements, parent, transData);
        boolean hierarchy = (Boolean)transData.getProperty(HIERARCHY);
        boolean transformNodeLayout = (Boolean)transData.getProperty(TRANSFORM_NODE_LAYOUT);
        boolean transformNodeLabels = (Boolean)transData.getProperty(TRANSFORM_NODE_LABELS);
        for (ElkNode childNode : parent.getChildren()) {
            String nodeID;
            NodeStatement nodeStatement = DotFactory.eINSTANCE.createNodeStatement();
            EList<Attribute> attributes = nodeStatement.getAttributes();
            if (hierarchy && !childNode.getChildren().isEmpty()) {
                String clusterNodeID = this.getNodeID(childNode, NodeType.CLUSTER, transData);
                Subgraph subgraph = DotFactory.eINSTANCE.createSubgraph();
                subgraph.setName(clusterNodeID);
                statements.add(subgraph);
                ElkPadding padding = (ElkPadding)childNode.getProperty(CoreOptions.PADDING);
                double subgraphx = childNode.getX() + padding.getLeft();
                double subgraphy = childNode.getY() + padding.getTop();
                this.transformNodes(childNode, (List<Statement>)subgraph.getStatements(), new KVector(offset).add(subgraphx, subgraphy), transData);
                nodeID = this.getNodeID(childNode, NodeType.DUMMY, transData);
                attributes.add(DotExporter.createAttribute("style", "invis"));
                attributes.add(DotExporter.createAttribute("width", 0));
                attributes.add(DotExporter.createAttribute("height", 0));
                subgraph.getStatements().add((Object)nodeStatement);
            } else {
                nodeID = this.getNodeID(childNode, NodeType.NODE, transData);
                ElkUtil.resizeNode((ElkNode)childNode);
                if (childNode.getWidth() > 0.0) {
                    attributes.add(DotExporter.createAttribute("width", childNode.getWidth() / 72.0));
                }
                if (childNode.getHeight() > 0.0) {
                    attributes.add(DotExporter.createAttribute("height", childNode.getHeight() / 72.0));
                }
                if (transformNodeLabels && !childNode.getLabels().isEmpty() && ((ElkLabel)childNode.getLabels().get(0)).getText().length() > 0) {
                    attributes.add(DotExporter.createAttribute("label", DotExporter.createString(((ElkLabel)childNode.getLabels().get(0)).getText())));
                }
                if (transformNodeLayout && (childNode.getX() != 0.0 || childNode.getY() != 0.0)) {
                    double xpos = childNode.getX() + childNode.getWidth() / 2.0 + offset.x;
                    double ypos = childNode.getY() + childNode.getHeight() / 2.0 + offset.y;
                    String posString = "\"" + Double.toString(xpos) + "," + Double.toString(ypos) + "\"";
                    attributes.add(DotExporter.createAttribute("pos", posString));
                }
                statements.add(nodeStatement);
            }
            Node node = DotFactory.eINSTANCE.createNode();
            node.setName(nodeID);
            nodeStatement.setNode(node);
        }
    }

    private void transformEdges(ElkNode parent, List<Statement> statements, IDotTransformationData<ElkNode, GraphvizModel> transData) {
        boolean hierarchy = (Boolean)transData.getProperty(HIERARCHY);
        boolean transformEdgeLayout = (Boolean)transData.getProperty(TRANSFORM_EDGE_LAYOUT);
        Direction direction = (Direction)parent.getProperty(CoreOptions.DIRECTION);
        boolean vertical = direction == Direction.DOWN || direction == Direction.UP || direction == Direction.UNDEFINED;
        LinkedList nodes = new LinkedList(parent.getChildren());
        BiMap nodeIds = ((BiMap)transData.getProperty(GRAPH_ELEMS)).inverse();
        while (!nodes.isEmpty()) {
            ElkNode source = (ElkNode)nodes.removeFirst();
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)source)) {
                if (edge.isHyperedge()) {
                    throw new UnsupportedGraphException("Hyperedges are not supported.");
                }
                ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0)));
                if (source.getParent() != target.getParent() && (!hierarchy || !this.isInsideGraph(target, transData.getSourceGraph()))) continue;
                EdgeStatement edgeStatement = DotFactory.eINSTANCE.createEdgeStatement();
                EList<Attribute> attributes = edgeStatement.getAttributes();
                Node sourceNode = DotFactory.eINSTANCE.createNode();
                if (hierarchy && !source.getChildren().isEmpty()) {
                    sourceNode.setName((String)source.getProperty(CLUSTER_DUMMY));
                    attributes.add(DotExporter.createAttribute("ltail", (String)nodeIds.get((Object)source)));
                } else {
                    sourceNode.setName((String)nodeIds.get((Object)source));
                }
                edgeStatement.setSourceNode(sourceNode);
                EdgeTarget edgeTarget = DotFactory.eINSTANCE.createEdgeTarget();
                Node targetNode = DotFactory.eINSTANCE.createNode();
                if (hierarchy && !target.getChildren().isEmpty()) {
                    targetNode.setName((String)target.getProperty(CLUSTER_DUMMY));
                    attributes.add(DotExporter.createAttribute("lhead", (String)nodeIds.get((Object)target)));
                } else {
                    targetNode.setName((String)nodeIds.get((Object)target));
                }
                edgeTarget.setTargetnode(targetNode);
                edgeStatement.getEdgeTargets().add((Object)edgeTarget);
                this.setEdgeLabels(edge, (List<Attribute>)attributes, vertical);
                if (((Boolean)transData.getProperty(USE_EDGE_IDS)).booleanValue()) {
                    String edgeID = this.getEdgeID(edge, transData);
                    attributes.add(DotExporter.createAttribute("comment", "\"" + edgeID + "\""));
                }
                if (!edge.getSections().isEmpty()) {
                    ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
                    if (transformEdgeLayout && (edgeSection.getBendPoints().size() > 0 || edgeSection.getStartX() != 0.0 || edgeSection.getStartY() != 0.0 || edgeSection.getEndX() != 0.0 || edgeSection.getEndY() != 0.0)) {
                        StringBuilder pos = new StringBuilder();
                        Iterator pointIter = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection).iterator();
                        while (pointIter.hasNext()) {
                            KVector point = (KVector)pointIter.next();
                            ElkUtil.toAbsolute((KVector)point, (ElkNode)edge.getContainingNode());
                            pos.append(point.x);
                            pos.append(",");
                            pos.append(point.y);
                            if (!pointIter.hasNext()) continue;
                            pos.append(" ");
                        }
                        attributes.add(DotExporter.createAttribute("pos", "\"" + pos + "\""));
                    }
                }
                statements.add(edgeStatement);
            }
            if (!hierarchy) continue;
            nodes.addAll(source.getChildren());
        }
    }

    private boolean isInsideGraph(ElkNode node, ElkNode root) {
        ElkNode n = node;
        do {
            if (n != root) continue;
            return true;
        } while ((n = n.getParent()) != null);
        return false;
    }

    protected void setGraphAttributes(List<Statement> statements, ElkNode parentNode, IDotTransformationData<ElkNode, GraphvizModel> transData) {
    }

    protected List<Attribute> setGeneralNodeAttributes(List<Statement> statements) {
        AttributeStatement nodeAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        nodeAttrStatement.setType(AttributeType.NODE);
        EList<Attribute> nodeAttrs = nodeAttrStatement.getAttributes();
        statements.add(nodeAttrStatement);
        nodeAttrs.add(DotExporter.createAttribute("shape", "box"));
        nodeAttrs.add(DotExporter.createAttribute("fixedsize", "true"));
        return nodeAttrs;
    }

    protected List<Attribute> setGeneralEdgeAttributes(List<Statement> statements) {
        AttributeStatement edgeAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        edgeAttrStatement.setType(AttributeType.EDGE);
        EList<Attribute> edgeAttrs = edgeAttrStatement.getAttributes();
        statements.add(edgeAttrStatement);
        edgeAttrs.add(DotExporter.createAttribute("dir", "none"));
        return edgeAttrs;
    }

    public static Attribute createAttribute(String name, String value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue(value);
        return attribute;
    }

    public static Attribute createAttribute(String name, int value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue("\"" + value + "\"");
        return attribute;
    }

    public static Attribute createAttribute(String name, float value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue("\"" + value + "\"");
        return attribute;
    }

    public static Attribute createAttribute(String name, double value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue("\"" + value + "\"");
        return attribute;
    }

    protected void setEdgeLabels(ElkEdge elkedge, List<Attribute> attributes, boolean isVertical) {
        if (elkedge.getLabels().isEmpty()) {
            return;
        }
        StringBuilder midLabel = new StringBuilder();
        StringBuilder headLabel = new StringBuilder();
        StringBuilder tailLabel = new StringBuilder();
        String fontName = null;
        int fontSize = 0;
        boolean isCenterFontName = false;
        boolean isCenterFontSize = false;
        for (ElkLabel label : elkedge.getLabels()) {
            StringBuilder buffer = midLabel;
            EdgeLabelPlacement placement = (EdgeLabelPlacement)label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
            boolean takeFontName = false;
            boolean takeFontSize = false;
            switch (placement) {
                case HEAD: {
                    takeFontName = fontName == null;
                    takeFontSize = fontSize <= 0;
                    buffer = headLabel;
                    break;
                }
                case TAIL: {
                    takeFontName = fontName == null;
                    takeFontSize = fontSize <= 0;
                    buffer = tailLabel;
                    break;
                }
                default: {
                    takeFontName = fontName == null || !isCenterFontName;
                    isCenterFontName = true;
                    takeFontSize = fontSize <= 0 || !isCenterFontSize;
                    isCenterFontSize = true;
                }
            }
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append(label.getText());
            if (takeFontName) {
                fontName = (String)label.getProperty(CoreOptions.FONT_NAME);
            }
            if (!takeFontSize || (fontSize = ((Integer)label.getProperty(CoreOptions.FONT_SIZE)).intValue()) <= 0) continue;
            fontSize = (int)((double)fontSize * 1.4);
        }
        if (midLabel.length() > 0) {
            double labelSpacing = (Double)elkedge.getProperty(CoreOptions.SPACING_EDGE_LABEL);
            if (labelSpacing < 1.0) {
                labelSpacing = 0.0;
            }
            int charsToAdd = (int)labelSpacing - 1;
            int i = 0;
            while (i < charsToAdd) {
                midLabel.append(isVertical ? "O" : "\nO");
                ++i;
            }
            attributes.add(DotExporter.createAttribute("label", DotExporter.createString(midLabel.toString())));
        }
        if (headLabel.length() > 0) {
            attributes.add(DotExporter.createAttribute("headlabel", DotExporter.createString(headLabel.toString())));
        }
        if (tailLabel.length() > 0) {
            attributes.add(DotExporter.createAttribute("taillabel", DotExporter.createString(tailLabel.toString())));
        }
        if (fontName != null && fontName.length() > 0) {
            attributes.add(DotExporter.createAttribute("fontname", "\"" + fontName + "\""));
        }
        if (fontSize > 0) {
            attributes.add(DotExporter.createAttribute("fontsize", fontSize));
        }
    }

    private static String createString(String label) {
        StringBuilder escapeBuffer = new StringBuilder(label.length() + 2);
        escapeBuffer.append("\"");
        int i = 0;
        while (i < label.length()) {
            char c = label.charAt(i);
            if (c == '\"' || c == '\\' || c > '~') {
                escapeBuffer.append('_');
            } else if (c == '\n') {
                escapeBuffer.append("\\n");
            } else if (c >= ' ') {
                escapeBuffer.append(c);
            }
            ++i;
        }
        escapeBuffer.append('\"');
        return escapeBuffer.toString();
    }

    private String getNodeID(ElkNode node, NodeType type, IDotTransformationData<ElkNode, GraphvizModel> transData) {
        int id = (Integer)transData.getProperty(NEXT_NODE_ID);
        transData.setProperty(NEXT_NODE_ID, id + 1);
        String idstring = null;
        switch (type) {
            case NODE: {
                idstring = "node" + id;
                ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)node);
                break;
            }
            case CLUSTER: {
                idstring = "cluster" + id;
                ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)node);
                break;
            }
            case DUMMY: {
                idstring = "dummy" + id;
                node.setProperty(CLUSTER_DUMMY, (Object)idstring);
            }
        }
        return idstring;
    }

    private String getEdgeID(ElkEdge edge, IDotTransformationData<ElkNode, GraphvizModel> transData) {
        int id = (Integer)transData.getProperty(NEXT_EDGE_ID);
        transData.setProperty(NEXT_EDGE_ID, id + 1);
        String idstring = "edge" + id;
        ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)edge);
        return idstring;
    }

    private void applyLayout(ElkNode parentNode, List<Statement> statements, KVector baseOffset, ElkPadding outerPadding, IDotTransformationData<ElkNode, GraphvizModel> transData) {
        ElkPadding padding = outerPadding;
        KVector nodeOffset = new KVector();
        block3: for (Statement statement : statements) {
            AttributeStatement attributeStatement;
            if (!(statement instanceof AttributeStatement) || (attributeStatement = (AttributeStatement)statement).getType() != AttributeType.GRAPH) continue;
            for (Attribute attribute : attributeStatement.getAttributes()) {
                if (!attribute.getName().equals("bb")) continue;
                try {
                    StringTokenizer tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                    double leftx = Double.parseDouble(tokenizer.nextToken());
                    double bottomy = Double.parseDouble(tokenizer.nextToken());
                    double rightx = Double.parseDouble(tokenizer.nextToken());
                    double topy = Double.parseDouble(tokenizer.nextToken());
                    double width = rightx - leftx;
                    double height = bottomy - topy;
                    if (parentNode == transData.getSourceGraph()) {
                        width += padding.getHorizontal();
                        height += padding.getVertical();
                        baseOffset.add(-leftx, -topy);
                        nodeOffset.add(-leftx, -topy);
                    } else {
                        parentNode.setX(baseOffset.x + leftx + padding.getLeft());
                        parentNode.setY(baseOffset.y + topy + padding.getTop());
                        padding = new ElkPadding();
                        nodeOffset.x = -(baseOffset.x + leftx);
                        nodeOffset.y = -(baseOffset.y + topy);
                    }
                    ElkUtil.resizeNode((ElkNode)parentNode, (double)width, (double)height, (boolean)false, (boolean)true);
                    parentNode.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, (Object)SizeConstraint.fixed());
                    break block3;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        for (Statement statement : statements) {
            if (statement instanceof NodeStatement) {
                this.applyNodeLayout((NodeStatement)statement, nodeOffset, padding, transData);
                continue;
            }
            if (!(statement instanceof Subgraph)) continue;
            Subgraph subgraph = (Subgraph)statement;
            ElkNode elknode = (ElkNode)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)subgraph.getName());
            this.applyLayout(elknode, (List<Statement>)subgraph.getStatements(), baseOffset, padding, transData);
            elknode.setX(elknode.getX() + nodeOffset.x);
            elknode.setY(elknode.getY() + nodeOffset.y);
        }
    }

    private void applyNodeLayout(NodeStatement nodeStatement, KVector offset, ElkPadding padding, IDotTransformationData<ElkNode, GraphvizModel> transData) {
        ElkNode elknode = (ElkNode)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)nodeStatement.getNode().getName());
        if (elknode == null) {
            return;
        }
        double xpos = 0.0;
        double ypos = 0.0;
        double width = 0.0;
        double height = 0.0;
        for (Attribute attribute : nodeStatement.getAttributes()) {
            try {
                StringTokenizer tokenizer;
                if (attribute.getName().equals("pos")) {
                    KVector pos = new KVector();
                    pos.parse(attribute.getValue());
                    xpos = pos.x + offset.x + padding.getLeft();
                    ypos = pos.y + offset.y + padding.getTop();
                    continue;
                }
                if (attribute.getName().equals("width")) {
                    tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                    width = Double.parseDouble(tokenizer.nextToken()) * 72.0;
                    continue;
                }
                if (!attribute.getName().equals("height")) continue;
                tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                height = Double.parseDouble(tokenizer.nextToken()) * 72.0;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        elknode.setX(xpos - width / 2.0);
        elknode.setY(ypos - height / 2.0);
    }

    private void applyEdgeLayout(EdgeStatement edgeStatement, KVector edgeOffset, IDotTransformationData<ElkNode, GraphvizModel> transData) {
        String string;
        String string2;
        String string3;
        Map<String, String> attributeMap = DotExporter.createAttributeMap(edgeStatement.getAttributes());
        ElkEdge elkedge = (ElkEdge)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)attributeMap.get("comment"));
        if (elkedge == null) {
            return;
        }
        ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)elkedge, (boolean)true, (boolean)true);
        String posString = attributeMap.get("pos");
        if (posString == null) {
            posString = "";
        }
        ElkNode referenceNode = elkedge.getContainingNode();
        KVector reference = new KVector();
        while (referenceNode != null && referenceNode != transData.getSourceGraph()) {
            reference.x += referenceNode.getX();
            reference.y += referenceNode.getY();
            referenceNode = referenceNode.getParent();
        }
        KVector offset = edgeOffset.clone().sub(reference);
        LinkedList<KVectorChain> splines = new LinkedList<KVectorChain>();
        Pair<KVector, KVector> endpoints = DotExporter.parseSplinePoints(posString, splines, offset);
        KVector sourcePoint = (KVector)endpoints.getFirst();
        KVector targetPoint = (KVector)endpoints.getSecond();
        if (!splines.isEmpty()) {
            if (sourcePoint == null) {
                List list = (List)splines.get(0);
                if (!list.isEmpty()) {
                    sourcePoint = (KVector)list.remove(0);
                } else {
                    ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getSources().get(0)));
                    sourcePoint = new KVector();
                    sourcePoint.x = sourceNode.getX() + sourceNode.getWidth() / 2.0;
                    sourcePoint.y = sourceNode.getY() + sourceNode.getHeight() / 2.0;
                }
            }
            if (targetPoint == null) {
                List list = (List)splines.get(splines.size() - 1);
                if (!list.isEmpty()) {
                    targetPoint = (KVector)list.remove(list.size() - 1);
                } else {
                    ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getTargets().get(0)));
                    targetPoint = new KVector();
                    targetPoint.x = targetNode.getX() + targetNode.getWidth() / 2.0;
                    targetPoint.y = targetNode.getY() + targetNode.getHeight() / 2.0;
                }
            }
            for (KVectorChain kVectorChain : splines) {
                for (KVector point : kVectorChain) {
                    ElkGraphUtil.createBendPoint((ElkEdgeSection)edgeSection, (double)point.x, (double)point.y);
                }
            }
            edgeSection.setStartLocation(sourcePoint.x, sourcePoint.y);
            edgeSection.setEndLocation(targetPoint.x, targetPoint.y);
            boolean bl = (Boolean)transData.getProperty(ADAPT_PORT_POSITIONS);
            if (bl && (elkedge.getSources().get(0) instanceof ElkPort || elkedge.getTargets().get(0) instanceof ElkPort)) {
                referenceNode = elkedge.getContainingNode();
                if (elkedge.getSources().get(0) instanceof ElkPort) {
                    ElkPort sourcePort = (ElkPort)elkedge.getSources().get(0);
                    ElkNode sourceNode = sourcePort.getParent();
                    ElkUtil.toAbsolute((KVector)sourcePoint, (ElkNode)referenceNode);
                    ElkUtil.toRelative((KVector)sourcePoint, (ElkNode)sourceNode);
                    sourcePort.setX((double)((float)sourcePoint.x) - sourcePort.getWidth() / 2.0);
                    sourcePort.setY((double)((float)sourcePoint.y) - sourcePort.getHeight() / 2.0);
                }
                if (elkedge.getTargets().get(0) instanceof ElkPort) {
                    ElkPort targetPort = (ElkPort)elkedge.getTargets().get(0);
                    ElkNode targetNode = targetPort.getParent();
                    ElkUtil.toAbsolute((KVector)targetPoint, (ElkNode)referenceNode);
                    ElkUtil.toRelative((KVector)targetPoint, (ElkNode)targetNode);
                    targetPort.setX(targetPoint.x - targetPort.getWidth() / 2.0);
                    targetPort.setY(targetPoint.y - targetPort.getHeight() / 2.0);
                }
            }
        }
        if (((Boolean)transData.getProperty(USE_SPLINES)).booleanValue()) {
            elkedge.setProperty(CoreOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        }
        if ((string3 = attributeMap.get("lp")) != null) {
            this.applyEdgeLabelPos(elkedge, string3, EdgeLabelPlacement.CENTER, offset);
        }
        if ((string2 = attributeMap.get("head_lp")) != null) {
            this.applyEdgeLabelPos(elkedge, string2, EdgeLabelPlacement.HEAD, offset);
        }
        if ((string = attributeMap.get("tail_lp")) != null) {
            this.applyEdgeLabelPos(elkedge, string, EdgeLabelPlacement.TAIL, offset);
        }
    }

    private void applyEdgeLabelPos(ElkEdge elkedge, String posString, EdgeLabelPlacement placement, KVector offset) {
        double combinedWidth = 0.0;
        double combinedHeight = 0.0;
        for (ElkLabel label : elkedge.getLabels()) {
            EdgeLabelPlacement elp = (EdgeLabelPlacement)label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
            if (elp != placement && (elp != EdgeLabelPlacement.UNDEFINED || placement != EdgeLabelPlacement.CENTER)) continue;
            combinedWidth = Math.max(combinedWidth, label.getWidth());
            combinedHeight += label.getHeight();
        }
        try {
            KVector pos = new KVector();
            pos.parse(posString);
            double xpos = pos.x - combinedWidth / 2.0 + offset.x;
            double ypos = pos.y - combinedHeight / 2.0 + offset.y;
            for (ElkLabel label : elkedge.getLabels()) {
                EdgeLabelPlacement elp = (EdgeLabelPlacement)label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
                if (elp != placement && (elp != EdgeLabelPlacement.UNDEFINED || placement != EdgeLabelPlacement.CENTER)) continue;
                double xoffset = (combinedWidth - label.getWidth()) / 2.0;
                label.setX(xpos + xoffset);
                label.setY(ypos);
                ypos += label.getHeight();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private static Map<String, String> createAttributeMap(List<Attribute> attributes) {
        HashMap<String, String> attributeMap = new HashMap<String, String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeMap.put(attribute.getName(), attribute.getValue());
        }
        return attributeMap;
    }

    private static Pair<KVector, KVector> parseSplinePoints(String posString, List<KVectorChain> splines, KVector offset) {
        KVector sourcePoint = null;
        KVector targetPoint = null;
        StringTokenizer splinesTokenizer = new StringTokenizer(posString, "\";");
        while (splinesTokenizer.hasMoreTokens()) {
            KVectorChain pointList = new KVectorChain();
            StringTokenizer posTokenizer = new StringTokenizer(splinesTokenizer.nextToken(), " \t");
            while (posTokenizer.hasMoreTokens()) {
                String token = posTokenizer.nextToken();
                try {
                    if (token.startsWith("s")) {
                        if (sourcePoint != null) continue;
                        sourcePoint = new KVector();
                        int commaIndex = token.indexOf(44);
                        sourcePoint.parse(token.substring(commaIndex + 1));
                        sourcePoint.add(offset);
                        continue;
                    }
                    if (token.startsWith("e")) {
                        if (targetPoint != null) continue;
                        targetPoint = new KVector();
                        int commaIndex = token.indexOf(44);
                        targetPoint.parse(token.substring(commaIndex + 1));
                        targetPoint.add(offset);
                        continue;
                    }
                    KVector point = new KVector();
                    point.parse(token);
                    pointList.add((Object)point.add(offset));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            splines.add(pointList);
        }
        return new Pair(sourcePoint, targetPoint);
    }

    private static enum NodeType {
        NODE,
        CLUSTER,
        DUMMY;

    }
}

