/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.json.text.ide.contentassist;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutDataContentAssist;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.json.text.services.ElkGraphJsonGrammarAccess;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ElkGraphJsonProposalProvider
extends IdeContentProposalProvider {
    private static final Set<String> DISABLED_KEYWORDS = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"}", "]"}));
    private ElkGraphJsonGrammarAccess grammar;
    private IDValueConverter idValueConverter;
    public static final String DISCO_LAYOUT_ALG_ID = "org.eclipse.elk.disco.componentCompaction.componentLayoutAlgorithm";

    @Inject
    public void initialize(Provider<IDValueConverter> idValueConverterProvider, ElkGraphJsonGrammarAccess grammarAccess) {
        IDValueConverter _doubleArrow;
        IDValueConverter _get = (IDValueConverter)idValueConverterProvider.get();
        Procedures.Procedure1 _function = it -> it.setRule((AbstractRule)grammarAccess.getIDRule());
        this.idValueConverter = _doubleArrow = (IDValueConverter)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        this.grammar = grammarAccess;
    }

    protected boolean filterKeyword(Keyword keyword, ContentAssistContext context) {
        return !DISABLED_KEYWORDS.contains(keyword.getValue()) && !Objects.equals(keyword.getValue(), context.getPrefix());
    }

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ContentAssistEntry entry;
        boolean _filterKeyword = this.filterKeyword(keyword, context);
        if (_filterKeyword && (entry = this.getProposalCreator().createProposal(keyword.getValue(), context, "KEYWORD", null)) != null) {
            entry.setKind("KEYWORD");
            entry.setSource((Object)keyword);
            acceptor.accept(entry, this.getProposalPriorities().getKeywordPriority(keyword.getValue(), entry));
        }
    }

    protected void _createProposals(RuleCall ruleCall, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _startsWith = ruleCall.getRule().getName().startsWith("Key");
        if (_startsWith) {
            AbstractElement _alternatives;
            AbstractElement alternatives = _alternatives = ruleCall.getRule().getAlternatives();
            boolean _matched = false;
            if (alternatives instanceof Alternatives) {
                _matched = true;
                Functions.Function1 _function = it -> !it.getValue().startsWith("\"") && !it.getValue().startsWith("'");
                Consumer<Keyword> _function_1 = it -> this.createProposals((AbstractElement)it, context, acceptor);
                IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Alternatives)alternatives).getElements(), Keyword.class), (Functions.Function1)_function).forEach(_function_1);
            }
        }
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _matched = false;
        Assignment _keyAssignment_0 = this.grammar.getPropertyAccess().getKeyAssignment_0();
        if (Objects.equals(assignment, _keyAssignment_0)) {
            _matched = true;
            this.completePropertyKey(context, acceptor);
        }
        if (!_matched) {
            Assignment _valueAssignment_2_2;
            Assignment _valueAssignment_2_1;
            Assignment _valueAssignment_2_0 = this.grammar.getPropertyAccess().getValueAssignment_2_0();
            if (Objects.equals(assignment, _valueAssignment_2_0)) {
                _matched = true;
            }
            if (!_matched && Objects.equals(assignment, _valueAssignment_2_1 = this.grammar.getPropertyAccess().getValueAssignment_2_1())) {
                _matched = true;
            }
            if (!_matched && Objects.equals(assignment, _valueAssignment_2_2 = this.grammar.getPropertyAccess().getValueAssignment_2_2())) {
                _matched = true;
            }
            if (_matched) {
                this.completePropertyValue(context, acceptor);
            }
        }
        if (!_matched) {
            super._createProposals(assignment, context, acceptor);
        }
    }

    protected void completePropertyKey(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EObject model = context.getCurrentModel();
        if (model instanceof ElkGraphElement) {
            Consumer<LayoutDataContentAssist.Proposal> _function = p -> {
                ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
                Procedures.Procedure1 _function_1 = it -> {
                    it.setProposal(this.convertPropertyId(proposal.proposal));
                    it.setPrefix(context.getPrefix());
                    it.setKind("PROPERTY");
                    String _elvis = null;
                    _elvis = proposal.label != null ? proposal.label : proposal.proposal;
                    it.setLabel(_elvis);
                    it.setDescription(this.getDescription((ILayoutMetaData)proposal.data));
                    it.setDocumentation(((LayoutOptionData)proposal.data).getDescription());
                    it.setSource(proposal.data);
                };
                ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function_1);
                acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
            };
            LayoutDataContentAssist.getLayoutOptionProposals((ElkGraphElement)((ElkGraphElement)model), (String)this.unquoteIfNecessary(context.getPrefix())).forEach(_function);
        }
    }

    protected void completePropertyValue(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        IProperty option;
        EObject model = context.getCurrentModel();
        if (model instanceof ElkPropertyToValueMapEntryImpl && (option = ((ElkPropertyToValueMapEntryImpl)model).getKey()) instanceof LayoutOptionData) {
            if (Objects.equals(CoreOptions.ALGORITHM, option) || Objects.equals(((LayoutOptionData)option).getId(), DISCO_LAYOUT_ALG_ID)) {
                this.proposeAlgorithms(context, acceptor);
            } else {
                this.typeAwarePropertyValueProposal((LayoutOptionData)option, context, acceptor);
            }
        }
    }

    protected void proposeAlgorithms(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        Consumer<LayoutDataContentAssist.Proposal> _function = p -> {
            ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
            Procedures.Procedure1 _function_1 = it -> {
                it.setProposal(this.convertPropertyId(proposal.proposal));
                it.setPrefix(context.getPrefix());
                it.setKind("VALUE");
                String _elvis = null;
                _elvis = proposal.label != null ? proposal.label : proposal.proposal;
                it.setLabel(_elvis);
                it.setDescription(this.getDescription((ILayoutMetaData)proposal.data));
                it.setDocumentation(((LayoutAlgorithmData)proposal.data).getDescription());
                it.setSource(proposal.data);
            };
            ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function_1);
            acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
        };
        LayoutDataContentAssist.getLayoutAlgorithmProposals((String)this.unquoteIfNecessary(context.getPrefix())).forEach(_function);
    }

    private void typeAwarePropertyValueProposal(LayoutOptionData option, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        Consumer<LayoutDataContentAssist.Proposal> _function = p -> {
            Object _xifexpression = null;
            boolean _contains = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new LayoutOptionData.Type[]{LayoutOptionData.Type.ENUM, LayoutOptionData.Type.ENUMSET, LayoutOptionData.Type.STRING})).contains(option.getType());
            _xifexpression = _contains ? "\"" + p.proposal + "\"" : p.proposal;
            Object proposal = _xifexpression;
            Procedures.Procedure1 _function_1 = it -> {
                it.setLabel(proposal.label);
                it.setSource((Object)option);
            };
            ContentAssistEntry entry = this.getProposalCreator().createProposal((String)proposal, context, "VALUE", _function_1);
            acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
        };
        LayoutDataContentAssist.getLayoutOptionValueProposal((LayoutOptionData)option, (String)this.unquoteIfNecessary(context.getPrefix())).forEach(_function);
    }

    private String convertPropertyId(String proposal) {
        Functions.Function1 _function = it -> this.idValueConverter.toString(it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)Strings.split((String)proposal, (String)"."), (Functions.Function1)_function), (CharSequence)".");
        String _plus = "\"" + _join;
        return _plus + "\"";
    }

    private String getDescription(ILayoutMetaData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = data.getName();
        _builder.append(_name);
        _builder.append(" (");
        String _id = data.getId();
        _builder.append(_id);
        _builder.append(")");
        return _builder.toString();
    }

    private String unquoteIfNecessary(String s) {
        String unquoted = s;
        while (unquoted.startsWith("\"") || unquoted.startsWith("'")) {
            unquoted = unquoted.substring(1, unquoted.length());
        }
        return unquoted;
    }
}

