/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutCategoryData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.ui.AlgorithmContentProvider;
import org.eclipse.elk.core.ui.Messages;
import org.eclipse.elk.core.util.Maybe;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AlgorithmSelectionDialog
extends Dialog {
    private String layouterHint;
    private Label displayNameLabel;
    private Label descriptionLabel;
    private Label imageLabel;
    private ISelectionProvider selectionProvider;
    private final Map<ILayoutMetaData, Image> imageCache = new HashMap<ILayoutMetaData, Image>();
    private List<ISelectionChangedListener> selectionListeners = new LinkedList<ISelectionChangedListener>();
    private static final RGB PREVIEW_IMG_FRAME_COLOR = new RGB(180, 180, 180);
    private static final int SELECTION_WIDTH = 220;
    private static final int DESCRIPTION_WIDTH = 300;
    private static final int DESCR_SPACING = 12;
    private static final int IMAGE_MAX_HEIGHT = 200;

    public AlgorithmSelectionDialog(Shell parentShell, String currentHint) {
        super(parentShell);
        this.layouterHint = currentHint;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("elk.ui.58"));
    }

    public void addAlgorithmSelectionListener(ISelectionChangedListener listener) {
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(listener);
        } else {
            this.selectionListeners.add(listener);
        }
    }

    public void removeAlgorithmSelectionListener(ISelectionChangedListener listener) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(listener);
        } else {
            this.selectionListeners.remove(listener);
        }
    }

    public boolean close() {
        this.imageLabel.setImage(null);
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        this.imageCache.clear();
        return super.close();
    }

    private void updateValue(ILayoutMetaData layoutData) {
        this.layouterHint = layoutData.getId();
        String name = layoutData.getName();
        if (name == null || name.length() == 0) {
            name = layoutData instanceof LayoutAlgorithmData ? Messages.getString("elk.ui.61") : Messages.getString("elk.ui.8");
        }
        this.displayNameLabel.setText(name);
        String description = layoutData.getDescription();
        if (description == null || description.length() == 0) {
            description = Messages.getString("elk.ui.60");
        }
        this.descriptionLabel.setText(description);
        Image image = this.imageCache.get(layoutData);
        if (image == null && layoutData instanceof LayoutAlgorithmData) {
            ImageDescriptor imageDescriptor;
            LayoutAlgorithmData algorithmData = (LayoutAlgorithmData)layoutData;
            String path = algorithmData.getPreviewImagePath();
            String bundleId = algorithmData.getDefiningBundleId();
            if (!Strings.isNullOrEmpty((String)path) && !Strings.isNullOrEmpty((String)bundleId) && (imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundleId, (String)path)) != null && (image = this.createAndScaleImage(imageDescriptor)) != null) {
                this.imageCache.put(layoutData, image);
            }
        }
        this.imageLabel.setImage(image);
        this.imageLabel.getParent().layout();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(layoutData instanceof LayoutAlgorithmData);
        }
    }

    private Image createAndScaleImage(ImageDescriptor imageDescriptor) {
        Image image = imageDescriptor.createImage(false);
        if (image == null) {
            return null;
        }
        double scale = 1.0;
        Rectangle bounds = image.getBounds();
        if (bounds.width > 300 || bounds.height > 200) {
            double widthScale = Math.min(1.0, 200.0 / (double)bounds.height);
            double heightScale = Math.min(1.0, 300.0 / (double)bounds.width);
            scale = Math.min(widthScale, heightScale);
        }
        int newWidth = (int)(scale * (double)bounds.width);
        int newHeight = (int)(scale * (double)bounds.height);
        int imgXPadding = (300 - newWidth) / 2;
        Image scaled = new Image((Device)Display.getDefault(), 300, newHeight);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, bounds.width, bounds.height, imgXPadding, 0, 300 - 2 * imgXPadding, newHeight - 1);
        Color frameColor = new Color((Device)Display.getCurrent(), PREVIEW_IMG_FRAME_COLOR);
        gc.setForeground(frameColor);
        gc.setAntialias(0);
        int[] nArray = new int[2];
        nArray[1] = 299;
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray2[n2];
            int y = 0;
            while (y < newHeight) {
                gc.drawPoint(x, y);
                ++y;
            }
            ++n2;
        }
        int[] nArray3 = new int[2];
        nArray3[1] = newHeight - 1;
        nArray2 = nArray3;
        n = nArray3.length;
        n2 = 0;
        while (n2 < n) {
            int y = nArray2[n2];
            int x = 0;
            while (x < 300) {
                gc.drawPoint(x, y);
                ++x;
            }
            ++n2;
        }
        gc.dispose();
        image.dispose();
        return scaled;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        this.createSelectionTree(composite);
        this.createDescriptionArea(composite);
        if (this.layouterHint != null) {
            LayoutMetaDataService layoutServices = LayoutMetaDataService.getInstance();
            LayoutAlgorithmData layoutData = layoutServices.getAlgorithmData(this.layouterHint);
            if (layoutData == null) {
                layoutData = layoutServices.getCategoryData(this.layouterHint);
            }
            if (layoutData != null) {
                this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)layoutData));
            }
        }
        return composite;
    }

    private Control createSelectionTree(Composite parent) {
        Composite composite = new Composite(parent, 0);
        final Text filterText = new Text(composite, 2048);
        filterText.setText(Messages.getString("elk.ui.59"));
        filterText.setLayoutData((Object)new GridData(4, 128, true, false));
        filterText.setForeground(parent.getDisplay().getSystemColor(15));
        final TreeViewer treeViewer = new TreeViewer(composite, 2564);
        final AlgorithmContentProvider contentProvider = new AlgorithmContentProvider();
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LayoutAlgorithmData) {
                    LayoutAlgorithmData algoData = (LayoutAlgorithmData)element;
                    String bundleName = algoData.getBundleName();
                    if (bundleName == null) {
                        return algoData.getName();
                    }
                    return algoData.getName() + " (" + bundleName + ")";
                }
                if (element instanceof LayoutCategoryData) {
                    LayoutCategoryData typeData = (LayoutCategoryData)element;
                    if (typeData.getName() == null) {
                        return "Other";
                    }
                    return typeData.getName();
                }
                return super.getText(element);
            }
        });
        treeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof LayoutCategoryData) {
                    LayoutCategoryData typeData = (LayoutCategoryData)element;
                    return typeData.getId().length() == 0 ? 1 : 0;
                }
                return super.category(element);
            }
        });
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setInput((Object)LayoutMetaDataService.getInstance());
        treeViewer.expandAll();
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AlgorithmSelectionDialog.this.okPressed();
            }
        });
        final Maybe filterChanged = new Maybe((Object)Boolean.FALSE);
        final Maybe filterLeft = new Maybe((Object)Boolean.FALSE);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!((Boolean)filterChanged.get()).booleanValue()) {
                    filterChanged.set((Object)Boolean.TRUE);
                    filterText.setForeground(null);
                    int pos = filterText.getCaretPosition();
                    String newText = filterText.getText(pos - 1, pos - 1);
                    filterText.setText(newText);
                    filterText.setSelection(pos);
                } else {
                    contentProvider.updateFilter(filterText.getText());
                    treeViewer.refresh();
                    treeViewer.expandAll();
                    ILayoutMetaData selected = contentProvider.getBestFilterMatch();
                    if (selected != null) {
                        treeViewer.setSelection((ISelection)new StructuredSelection((Object)selected));
                    }
                }
            }
        });
        filterText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (((Boolean)filterLeft.get()).booleanValue() && !((Boolean)filterChanged.get()).booleanValue()) {
                    filterChanged.set((Object)Boolean.TRUE);
                    filterText.setForeground(null);
                    filterText.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                filterLeft.set((Object)Boolean.TRUE);
            }
        });
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return contentProvider.applyFilter(element);
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof ILayoutMetaData) {
                    AlgorithmSelectionDialog.this.updateValue((ILayoutMetaData)element);
                }
            }
        });
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 220;
        composite.setLayoutData((Object)gridData);
        this.selectionProvider = treeViewer;
        for (ISelectionChangedListener listener : this.selectionListeners) {
            this.selectionProvider.addSelectionChangedListener(listener);
        }
        return composite;
    }

    private Control createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.displayNameLabel = new Label(composite, 0);
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)parent.getFont());
        fontDescriptor = fontDescriptor.increaseHeight(2).setStyle(1);
        this.displayNameLabel.setFont(fontDescriptor.createFont((Device)parent.getDisplay()));
        this.displayNameLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.descriptionLabel = new Label(composite, 64);
        GridData descriptionLayoutData = new GridData(4, 4, true, true);
        descriptionLayoutData.widthHint = 300;
        this.descriptionLabel.setLayoutData((Object)descriptionLayoutData);
        this.imageLabel = new Label(composite, 0);
        GridData imageLayoutData = new GridData(0x1000000, 1024, true, false);
        this.imageLabel.setLayoutData((Object)imageLayoutData);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.verticalSpacing = 12;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    public String getSelectedHint() {
        return this.layouterHint;
    }
}

