/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.vertiflex.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.vertiflex.EdgeRoutingStrategy;
import org.eclipse.elk.alg.vertiflex.VertiFlexLayoutProvider;
import org.eclipse.elk.alg.vertiflex.options.VertiFlexMetaDataProvider;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class VertiFlexOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.vertiflex";
    private static final double SPACING_NODE_NODE_DEFAULT = 20.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)20.0);
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(5.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<PortConstraints> PORT_CONSTRAINTS = CoreOptions.PORT_CONSTRAINTS;
    private static final boolean EDGE_LABELS_INLINE_DEFAULT = false;
    public static final IProperty<Boolean> EDGE_LABELS_INLINE = new Property(CoreOptions.EDGE_LABELS_INLINE, (Object)false);
    public static final IProperty<Boolean> OMIT_NODE_MICRO_LAYOUT = CoreOptions.OMIT_NODE_MICRO_LAYOUT;
    public static final IProperty<ElkMargin> MARGINS = CoreOptions.MARGINS;
    public static final IProperty<Double> VERTICAL_CONSTRAINT = VertiFlexMetaDataProvider.VERTICAL_CONSTRAINT;
    public static final IProperty<EdgeRoutingStrategy> LAYOUT_STRATEGY = VertiFlexMetaDataProvider.LAYOUT_STRATEGY;
    public static final IProperty<Double> LAYER_DISTANCE = VertiFlexMetaDataProvider.LAYER_DISTANCE;
    public static final IProperty<Boolean> CONSIDER_NODE_MODEL_ORDER = VertiFlexMetaDataProvider.CONSIDER_NODE_MODEL_ORDER;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK VertiFlex").description("Tree layout algorithm that allows defining set vertical positions for nodes rather than automatically placing nodes on levels according to their topology.").providerFactory((IFactory)new VertiflexFactory()).category("org.eclipse.elk.tree").melkBundleName(null).definingBundleId("org.eclipse.elk.alg.vertiflex").supportedFeatures(EnumSet.of(GraphFeature.MULTI_EDGES, GraphFeature.EDGE_LABELS)).create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)20.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.portConstraints", PORT_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.edgeLabels.inline", (Object)false);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.omitNodeMicroLayout", OMIT_NODE_MICRO_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.margins", MARGINS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.vertiflex.verticalConstraint", VERTICAL_CONSTRAINT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.vertiflex.layoutStrategy", LAYOUT_STRATEGY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.vertiflex.layerDistance", LAYER_DISTANCE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.vertiflex.considerNodeModelOrder", CONSIDER_NODE_MODEL_ORDER.getDefault());
    }

    public static class VertiflexFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            VertiFlexLayoutProvider provider = new VertiFlexLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

