/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GroupOrderStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.alg.layered.p1cycles.GroupModelOrderCalculator;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class ModelOrderCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Model order cycle breaking", 1.0f);
        ArrayList revEdges = Lists.newArrayList();
        int offset = Math.max(layeredGraph.getLayerlessNodes().size(), (Integer)layeredGraph.getProperty(InternalProperties.MAX_MODEL_ORDER_NODES));
        int bigOffset = offset * (Integer)layeredGraph.getProperty(InternalProperties.CB_NUM_MODEL_ORDER_GROUPS);
        boolean enforceGroupModelOrder = layeredGraph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CB_GROUP_ORDER_STRATEGY) == GroupOrderStrategy.ENFORCED;
        for (LNode source : layeredGraph.getLayerlessNodes()) {
            GroupModelOrderCalculator calculator = new GroupModelOrderCalculator();
            int modelOrderSource = enforceGroupModelOrder ? calculator.computeConstraintGroupModelOrder(source, bigOffset, offset) : calculator.computeConstraintModelOrder(source, offset);
            for (LPort port : source.getPorts(PortType.OUTPUT)) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    int modelOrderTarget;
                    LNode target = edge.getTarget().getNode();
                    int n = modelOrderTarget = enforceGroupModelOrder ? calculator.computeConstraintGroupModelOrder(target, bigOffset, offset) : calculator.computeConstraintModelOrder(target, offset);
                    if (modelOrderTarget >= modelOrderSource) continue;
                    revEdges.add(edge);
                }
            }
        }
        for (LEdge edge : revEdges) {
            edge.reverse(layeredGraph, true);
            layeredGraph.setProperty(InternalProperties.CYCLIC, true);
        }
        revEdges.clear();
        monitor.done();
    }
}

