/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco;

import org.eclipse.elk.alg.disco.DisCoPolyominoCompactor;
import org.eclipse.elk.alg.disco.graph.DCGraph;
import org.eclipse.elk.alg.disco.options.CompactionStrategy;
import org.eclipse.elk.alg.disco.options.DisCoMetaDataProvider;
import org.eclipse.elk.alg.disco.options.DisCoOptions;
import org.eclipse.elk.alg.disco.transform.ElkGraphTransformer;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class DisCoLayoutProvider
extends AbstractLayoutProvider {
    private DCGraph result;
    private double componentSpacing;

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Connected Components Compaction", 1.0f);
        this.componentSpacing = (Double)layoutGraph.getProperty(DisCoOptions.SPACING_COMPONENT_COMPONENT);
        if (layoutGraph.hasProperty(DisCoOptions.COMPONENT_COMPACTION_COMPONENT_LAYOUT_ALGORITHM)) {
            String requestedAlgorithm = (String)layoutGraph.getProperty(DisCoOptions.COMPONENT_COMPACTION_COMPONENT_LAYOUT_ALGORITHM);
            LayoutAlgorithmData lad = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffix(requestedAlgorithm);
            if (lad != null) {
                AbstractLayoutProvider layoutProvider = (AbstractLayoutProvider)lad.getInstancePool().fetch();
                layoutProvider.layout(layoutGraph, progressMonitor.subTask(1.0f));
            }
        }
        ElkGraphTransformer transformer = new ElkGraphTransformer(this.componentSpacing);
        this.result = transformer.importGraph(layoutGraph);
        switch ((CompactionStrategy)((Object)layoutGraph.getProperty(DisCoMetaDataProvider.COMPONENT_COMPACTION_STRATEGY))) {
            case POLYOMINO: {
                new DisCoPolyominoCompactor().compact(this.result);
                layoutGraph.setProperty(DisCoOptions.DEBUG_DISCO_POLYS, this.result.getProperty(DisCoOptions.DEBUG_DISCO_POLYS));
                break;
            }
            default: {
                System.out.println("DisCo: no compaction strategy used for connected components.");
            }
        }
        transformer.applyLayout();
        layoutGraph.setProperty(DisCoOptions.DEBUG_DISCO_GRAPH, (Object)this.result);
        progressMonitor.done();
    }
}

