/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.console.internal;

import java.util.StringTokenizer;
import org.eclipse.egf.common.ui.helper.EditorHelper;
import org.eclipse.egf.console.EGFConsolePlugin;
import org.eclipse.egf.console.internal.Console;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class ConsoleLineNotifier
implements IPatternMatchListener {
    private Console _console = null;

    public void connect(TextConsole console) {
        if (console instanceof Console) {
            this._console = (Console)console;
        }
    }

    public synchronized void disconnect() {
        this._console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset();
            int length = event.getLength();
            String text = this._console.getDocument().get(offset, length);
            int index = text.indexOf("platform:/");
            if (index != -1) {
                this.buildLink(text, offset, length, "platform:/");
                return;
            }
            index = text.indexOf("plugin:/");
            if (index != -1) {
                this.buildLink(text, offset, length, "plugin:/");
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void buildLink(String text, int offset, int length, String type) {
        try {
            int index = text.indexOf(type);
            StringTokenizer tokenizer = new StringTokenizer(text, " ");
            while (tokenizer.hasMoreElements()) {
                String elementName = tokenizer.nextToken();
                if (!elementName.startsWith(type)) continue;
                URIHyperlink link = new URIHyperlink(URI.createURI((String)elementName));
                this._console.addHyperlink(link, offset + index, elementName.length());
                return;
            }
        }
        catch (Exception exception) {}
    }

    public String getPattern() {
        return ".*\\r(\\n?)|.*\\n";
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return "\\n|\\r";
    }

    private static class URIHyperlink
    implements IHyperlink {
        private URI _uri;

        public URIHyperlink(URI uri) {
            this._uri = uri;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            try {
                IEditorPart part;
                if (this._uri != null && (part = EditorHelper.openEditor((URI)this._uri)) != null && part instanceof IEditingDomainProvider) {
                    EditorHelper.setSelectionToViewer((IEditorPart)part, (URI)this._uri);
                }
            }
            catch (PartInitException pie) {
                EGFConsolePlugin.getDefault().logError(pie);
            }
        }
    }
}

