/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.model.pattern.AbstractPatternCall;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationHelper {
    private TranslationHelper() {
    }

    public static void translate(IProgressMonitor monitor, Set<Pattern> patterns) throws PatternException {
        if (patterns.isEmpty()) {
            return;
        }
        TranslationHelper.translate(monitor, TranslationHelper.getOrderedList(patterns));
    }

    public static void translate(IProgressMonitor monitor, List<Pattern> patterns) throws PatternException {
        if (patterns.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)patterns.size());
        try {
            for (Pattern p : patterns) {
                subMonitor.setTaskName(NLS.bind((String)EGFPatternMessages.pattern_translation_label, (Object)p.getName()));
                PatternExtension extension = ExtensionHelper.getExtension(p.getNature());
                String reason = extension.canTranslate(p);
                if (reason == null) {
                    extension.createEngine(p).translate();
                } else {
                    EGFPatternPlugin.getDefault().logWarning(NLS.bind((String)EGFPatternMessages.assembly_error3, (Object)p.getName(), (Object)reason));
                }
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                subMonitor.worked(1);
            }
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new PatternException((Throwable)e);
        }
    }

    public static List<Pattern> getOrderedList(Set<Pattern> patterns) {
        ArrayList<Pattern> result = new ArrayList<Pattern>(patterns.size());
        HashSet<Pattern> visited = new HashSet<Pattern>(100);
        for (Pattern p : patterns) {
            TranslationHelper.addRequirements(p, result, patterns, visited);
        }
        visited.clear();
        return result;
    }

    private static void addRequirements(Pattern pattern, List<Pattern> result, Set<Pattern> allPatterns, Set<Pattern> visited) {
        if (visited.contains(pattern)) {
            return;
        }
        visited.add(pattern);
        Pattern superPattern = pattern.getSuperPattern();
        if (superPattern != null) {
            TranslationHelper.addRequirements(superPattern, result, allPatterns, visited);
        }
        for (Call call : pattern.getOrchestration()) {
            if (!(call instanceof AbstractPatternCall)) continue;
            TranslationHelper.addRequirements(((AbstractPatternCall)call).getCalled(), result, allPatterns, visited);
        }
        if (allPatterns.contains(pattern)) {
            result.add(pattern);
        }
    }
}

