/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.process;

import java.util.concurrent.CompletableFuture;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.ChangeOption;
import org.eclipse.egerrit.internal.core.command.GetChangeCommand;
import org.eclipse.egerrit.internal.core.command.RebaseRevisionCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.RebaseInput;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.process.AutoRebaseProcess;
import org.eclipse.egerrit.internal.ui.editors.FindLocalRepository;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.editors.RefreshRelatedEditors;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RebaseProcess
extends Action {
    private Boolean rebaseLocally = false;
    private Shell shell;
    private ChangeInfo changeInfo;
    private RevisionInfo toRebase;
    private GerritClient gerritClient;

    public RebaseProcess(Boolean rebaseLocally, Shell shell, ChangeInfo changeInfo, RevisionInfo toRebase, GerritClient gerritClient) {
        this.rebaseLocally = rebaseLocally;
        this.shell = shell;
        this.changeInfo = changeInfo;
        this.toRebase = toRebase;
        this.gerritClient = gerritClient;
        if (rebaseLocally.booleanValue()) {
            this.setText(Messages.RebaseProcess_RebaseLocally);
        } else {
            this.setText(Messages.RebaseProcess_RebaseRemotely);
        }
    }

    public void run() {
        if (this.rebaseLocally.booleanValue()) {
            Repository repo = new FindLocalRepository(this.gerritClient, this.toRebase.getChangeInfo().getProject()).getRepository();
            if (repo != null) {
                AutoRebaseProcess process = new AutoRebaseProcess(this.gerritClient, repo, this.toRebase, null);
                process.schedule();
            } else {
                this.showNoRepoDialog(true);
            }
        } else {
            RebaseInputDialog inputDialog = new RebaseInputDialog(this.shell, Messages.RebaseProcess_title, Messages.RebaseProcess_changeParent, "", null, this.toRebase);
            if (inputDialog.open() != 0) {
                return;
            }
            RebaseRevisionCommand rebaseCmd = this.gerritClient.rebase(this.changeInfo.getId(), this.toRebase.getId());
            RebaseInput rebaseInput = new RebaseInput();
            String base = inputDialog.getValue().trim().length() == 0 ? null : inputDialog.getValue().trim();
            rebaseInput.setBase(base);
            rebaseCmd.setCommandInput((Object)rebaseInput);
            CompletableFuture.runAsync(() -> {
                this.changeInfo.eAdapters().add((Object)new EContentAdapter(){

                    public void notifyChanged(Notification msg) {
                        if (msg.getFeature() == null) {
                            return;
                        }
                        if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__RELATED_CHANGES) && msg.getEventType() == 1) {
                            new RefreshRelatedEditors(RebaseProcess.this.changeInfo, RebaseProcess.this.gerritClient).schedule();
                            RebaseProcess.this.changeInfo.eAdapters().remove((Object)this);
                        }
                    }
                });
                try {
                    rebaseCmd.call();
                }
                catch (EGerritException e) {
                    if (e.getCode() == 1) {
                        ChangeInfo baseChange = null;
                        if (base != null && base.length() > 0) {
                            try {
                                GetChangeCommand command = this.gerritClient.getChange(base);
                                command.addOption(ChangeOption.CURRENT_REVISION);
                                baseChange = (ChangeInfo)command.call();
                            }
                            catch (EGerritException e1) {
                                e1.getCode();
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.open((int)2, null, (String)Messages.RebaseProcess_FailedInvalidChangeNumber, (String)Messages.RebaseProcess_FailedInvalidChangeNumberPleaseEnterValid, (int)0);
                                    }
                                });
                                return;
                            }
                        }
                        this.suggestLocalRebase(this.toRebase, this.gerritClient, baseChange);
                    }
                    EGerritCorePlugin.logError((String)(String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
                }
            }).thenRun(() -> {
                QueryHelpers.loadBasicInformation(this.gerritClient, this.changeInfo, true);
                this.changeInfo.setUserSelectedRevision(this.changeInfo.getRevision());
            });
        }
    }

    private void showNoRepoDialog(final Boolean isLocal) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (isLocal.booleanValue()) {
                    MessageDialog.open((int)2, null, (String)Messages.RebaseProcess_TitleRebaseFailedNoRepo, (String)Messages.RebaseProcess_LocalNoRepo, (int)0);
                } else {
                    MessageDialog.open((int)2, null, (String)Messages.RebaseProcess_TitleRebaseFailedNoRepo, (String)Messages.RebaseProcess_CouldNotPerformRemoteRebaseNoRepo, (int)0);
                }
            }
        });
    }

    private void suggestLocalRebase(RevisionInfo toRebase, GerritClient gerritClient, ChangeInfo baseChange) {
        Repository repo = new FindLocalRepository(gerritClient, toRebase.getChangeInfo().getProject()).getRepository();
        if (repo != null) {
            IndexDiffCacheEntry entry = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repo);
            RebaseRequestRunnable rebaseRequest = new RebaseRequestRunnable(entry.getIndexDiff().getModified().size());
            Display.getDefault().syncExec((Runnable)rebaseRequest);
            if (rebaseRequest.getChoice() == 0) {
                AutoRebaseProcess process = new AutoRebaseProcess(gerritClient, repo, toRebase, baseChange);
                process.schedule();
            }
        } else {
            this.showNoRepoDialog(false);
        }
    }

    private class RebaseInputDialog
    extends InputDialog {
        private RevisionInfo toRebase;

        public RebaseInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, RevisionInfo toRebase) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
            this.toRebase = toRebase;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!RebaseInputDialog.this.toRebase.isRebaseable()) {
                        if (!RebaseInputDialog.this.getText().getText().isEmpty()) {
                            RebaseInputDialog.this.getOkButton().setEnabled(true);
                        } else {
                            RebaseInputDialog.this.getOkButton().setEnabled(false);
                            RebaseInputDialog.this.getOkButton().getParent().setToolTipText(RebaseInputDialog.this.toRebase.isRebaseable() ? "" : Messages.RebaseProcess_changeIsAlreadyUpToDate);
                        }
                    }
                }
            });
            this.getOkButton().setEnabled(this.toRebase.isRebaseable());
            this.getOkButton().getParent().setToolTipText(this.toRebase.isRebaseable() ? "" : Messages.RebaseProcess_changeIsAlreadyUpToDate);
        }
    }

    private class RebaseRequestRunnable
    implements Runnable {
        private int choice;
        private int numberOfChanges;

        public int getChoice() {
            return this.choice;
        }

        public RebaseRequestRunnable(int numberOfChanges) {
            this.numberOfChanges = numberOfChanges;
        }

        @Override
        public void run() {
            String stashString = "";
            if (this.numberOfChanges > 0) {
                stashString = " (" + Integer.toString(this.numberOfChanges) + Messages.RebaseProcess_Changes + Messages.RebaseProcess_ToStash;
            }
            MessageDialog result = new MessageDialog(null, Messages.RebaseProcess_AutomaticLocalRebase, null, String.valueOf(Messages.RebaseProcess_notPerform) + "\r\r" + Messages.RebaseProcess_WouldYouLikeAutomaticRebase + " : \r\r-" + Messages.RebaseProcess_FetchAppropriateBranches + "\r-" + Messages.RebaseProcess_StashLocalChanges + stashString + "\r-" + Messages.RebaseProcess_CreateAndCheckout + "\r-" + Messages.RebaseProcess_RebaseCheckedOut, 3, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            this.choice = result.open();
        }
    }
}

