/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IShadowedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public abstract class AbstractProjectAwareResourceDescriptionsProvider
extends ResourceDescriptionsProvider {
    @Inject
    CompilerPhases compilerPhases;

    public IResourceDescriptions getResourceDescriptions(ResourceSet resourceSet) {
        String projectName;
        IResourceDescriptions result = super.getResourceDescriptions(resourceSet);
        if (this.compilerPhases.isIndexing((Notifier)resourceSet) && (projectName = this.getProjectName(resourceSet)) != null) {
            final String encodedProjectName = URI.encodeSegment((String)projectName, (boolean)true);
            Predicate<URI> predicate = new Predicate<URI>(){

                public boolean apply(URI uri) {
                    if (uri == null || uri.segmentCount() < 2 || !uri.isPlatformResource()) {
                        return false;
                    }
                    return !uri.segment(1).equals(encodedProjectName);
                }
            };
            if (result instanceof IShadowedResourceDescriptions) {
                return new ShadowedFilteringResourceDescriptions(result, predicate);
            }
            return new FilteringResourceDescriptions(result, predicate);
        }
        return result;
    }

    protected abstract String getProjectName(ResourceSet var1);

    protected static class FilteringResourceDescriptions
    implements IResourceDescriptions {
        private IResourceDescriptions delegate;
        private Predicate<URI> filter;

        public FilteringResourceDescriptions(IResourceDescriptions delegate, Predicate<URI> filter) {
            this.delegate = delegate;
            this.filter = filter;
        }

        protected IResourceDescriptions getDelegate() {
            return this.delegate;
        }

        protected Predicate<URI> getFilter() {
            return this.filter;
        }

        public Iterable<IResourceDescription> getAllResourceDescriptions() {
            return Iterables.filter((Iterable)this.delegate.getAllResourceDescriptions(), (Predicate)new Predicate<IResourceDescription>(){

                public boolean apply(IResourceDescription input) {
                    return FilteringResourceDescriptions.this.filter.apply((Object)input.getURI());
                }
            });
        }

        public IResourceDescription getResourceDescription(URI normalizedURI) {
            if (this.filter.apply((Object)normalizedURI)) {
                return this.delegate.getResourceDescription(normalizedURI);
            }
            return null;
        }

        private Iterable<IEObjectDescription> filtered(Iterable<IEObjectDescription> eObjectDescriptions) {
            return Iterables.filter(eObjectDescriptions, (Predicate)new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription input) {
                    return FilteringResourceDescriptions.this.filter.apply((Object)input.getEObjectURI());
                }
            });
        }

        public Iterable<IEObjectDescription> getExportedObjects() {
            return this.filtered(this.delegate.getExportedObjects());
        }

        public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
            return this.filtered(this.delegate.getExportedObjects(type, name, ignoreCase));
        }

        public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
            return this.filtered(this.delegate.getExportedObjectsByObject(object));
        }

        public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
            return this.filtered(this.delegate.getExportedObjectsByType(type));
        }

        public boolean isEmpty() {
            return Iterables.isEmpty(this.getAllResourceDescriptions());
        }
    }

    protected static class ShadowedFilteringResourceDescriptions
    extends FilteringResourceDescriptions
    implements IShadowedResourceDescriptions {
        public ShadowedFilteringResourceDescriptions(IResourceDescriptions delegate, Predicate<URI> filter) {
            super(delegate, filter);
        }

        public boolean isShadowed(EClass type, QualifiedName name, boolean ignoreCase) {
            boolean result = ((IShadowedResourceDescriptions)this.getDelegate()).isShadowed(type, name, ignoreCase);
            return result;
        }
    }
}

