/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.internal;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.ListCell;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.fx.core.databinding.AdapterFactory;
import org.eclipse.fx.core.databinding.ObservableWritableValue;
import org.eclipse.fx.ui.databinding.internal.TemplateComputedValue;
import org.eclipse.jdt.annotation.NonNull;

public final class TemplateTextOnlyPropertyListCell<O>
extends ListCell<O> {
    private IObservableValue currentObservable;
    private @NonNull IValueProperty[] properties;
    private @NonNull String template;

    public TemplateTextOnlyPropertyListCell(@NonNull String template, IValueProperty ... properties) {
        this.template = template;
        this.properties = properties;
    }

    protected void updateItem(O item, boolean empty) {
        super.updateItem(item, empty);
        IObservableValue oldObservable = this.currentObservable;
        this.textProperty().unbind();
        if (item != null && !empty) {
            this.currentObservable = new TemplateComputedValue(item, this.template, this.properties);
            ObservableWritableValue adapt = AdapterFactory.adapt((IObservableValue)this.currentObservable);
            this.textProperty().bind((ObservableValue)adapt);
        } else {
            this.setText(null);
        }
        if (oldObservable != null) {
            oldObservable.dispose();
        }
    }
}

