/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.fx.core.Subscription;

public interface ThreadSynchronize {
    public <V> V syncExec(Callable<V> var1, V var2);

    public void syncExec(Runnable var1);

    public <V> Future<V> asyncExec(Callable<V> var1);

    public void asyncExec(Runnable var1);

    public Subscription scheduleExecution(long var1, Runnable var3);

    public <T> CompletableFuture<T> scheduleExecution(long var1, Callable<T> var3);

    default public Runnable wrap(Runnable r) {
        return () -> this.asyncExec(r);
    }

    default public <T> Consumer<T> wrap(Consumer<T> c) {
        return t -> this.asyncExec(() -> c.accept(t));
    }

    default public <T, U> BiConsumer<T, U> wrap(BiConsumer<T, U> c) {
        return (t, u) -> this.asyncExec(() -> c.accept(t, u));
    }

    default public <T> Supplier<T> wrap(Supplier<T> s) {
        return () -> this.syncExec(() -> s.get(), null);
    }
}

