/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class SystemLogService
implements LogService {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("Z yyyy.MM.dd HH:mm:ss:S");
    private final String pluginName;

    public SystemLogService(String pluginName) {
        this.pluginName = pluginName;
    }

    private static final String getLogCode(int level) {
        switch (level) {
            case 3: {
                return "INFO";
            }
            case 1: {
                return "ERROR";
            }
            case 4: {
                return "DEBUG";
            }
            case 2: {
                return "WARNING";
            }
        }
        return "UNKNOWN";
    }

    private final void doLog(ServiceReference sr, int level, String message, Throwable t) {
        StringBuffer buf = new StringBuffer("[log;");
        buf.append(dateFormat.format(new Date())).append(";");
        buf.append(SystemLogService.getLogCode(level)).append(";");
        if (sr != null) {
            buf.append(sr.getBundle().getSymbolicName()).append(";");
        } else {
            buf.append(this.pluginName).append(";");
        }
        buf.append(message).append("]");
        if (t != null) {
            System.err.println(buf.toString());
            t.printStackTrace(System.err);
        } else {
            System.out.println(buf.toString());
        }
    }

    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.doLog(null, level, message, exception);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(sr, level, message, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.doLog(sr, level, message, exception);
    }
}

