/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

import java.util.function.Consumer;

public class JNINativeSurface {
    private Consumer<FrameData> presentFrame;

    public JNINativeSurface(Consumer<FrameData> presentFrame) {
        this.presentFrame = presentFrame;
    }

    public void present(long handle, long ioSurfaceHandle, int textureName, int width, int height) {
        FrameData dat = new FrameData();
        dat.d3dShareHandle = handle;
        dat.ioSurfaceHandle = ioSurfaceHandle;
        dat.textureName = textureName;
        dat.width = width;
        dat.height = height;
        this.presentFrame.accept(dat);
    }

    public void present(FrameData frame) {
        this.presentFrame.accept(frame);
    }

    public static class FrameData {
        public long d3dShareHandle;
        public long ioSurfaceHandle;
        public int width;
        public int height;
        public int textureName;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.d3dShareHandle ^ this.d3dShareHandle >>> 32);
            result = 31 * result + this.height;
            result = 31 * result + (int)(this.ioSurfaceHandle ^ this.ioSurfaceHandle >>> 32);
            result = 31 * result + this.textureName;
            result = 31 * result + this.width;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FrameData other = (FrameData)obj;
            if (this.d3dShareHandle != other.d3dShareHandle) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            if (this.ioSurfaceHandle != other.ioSurfaceHandle) {
                return false;
            }
            if (this.textureName != other.textureName) {
                return false;
            }
            return this.width == other.width;
        }
    }
}

