/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.ContentHandler;

class ContentHandlerRegistryReader
extends RegistryReader {
    static final String TAG_HANDLER = "contentHandler";
    static final String ATT_CLASS = "class";
    static final String ATT_PRIORITY = "priority";
    private static final Map<String, List<ContentHandler>> CONTRIBUTION_MAP = new HashMap<String, List<ContentHandler>>();

    public ContentHandlerRegistryReader() {
        super(RegistryFactory.getRegistry(), EcorePlugin.INSTANCE.getSymbolicName(), "content_handler");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean readElement(IConfigurationElement element, boolean add) {
        String contributorClassName;
        if (!element.getName().equals(TAG_HANDLER)) {
            if (!element.getName().equals("parameter")) return false;
            return true;
        }
        int priority = 0;
        if (element.getAttribute(ATT_PRIORITY) != null) {
            priority = Integer.parseInt(element.getAttribute(ATT_PRIORITY));
        }
        if ((contributorClassName = element.getAttribute(ATT_CLASS)) == null) {
            this.logMissingAttribute(element, ATT_CLASS);
            return false;
        }
        String contributorName = element.getContributor().getName();
        if (add) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Delegate
            implements ContentHandler {
                private volatile ContentHandler delegate;
                private final /* synthetic */ IConfigurationElement val$element;
                private final /* synthetic */ String val$contributorClassName;

                Delegate(IConfigurationElement iConfigurationElement, String string) {
                    this.val$element = iConfigurationElement;
                    this.val$contributorClassName = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private ContentHandler getDelegate() {
                    if (this.delegate == null) {
                        Delegate delegate = this;
                        synchronized (delegate) {
                            if (this.delegate == null) {
                                try {
                                    Class contributorHandlerClass = CommonPlugin.loadClass((String)this.val$element.getNamespaceIdentifier(), (String)this.val$contributorClassName);
                                    HashMap<String, String> parameters = new HashMap<String, String>();
                                    IConfigurationElement[] iConfigurationElementArray = this.val$element.getChildren("parameter");
                                    int n = iConfigurationElementArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IConfigurationElement parameter = iConfigurationElementArray[n2];
                                        parameters.put(parameter.getAttribute("name"), parameter.getAttribute("value"));
                                        ++n2;
                                    }
                                    this.delegate = parameters.isEmpty() ? (ContentHandler)contributorHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (ContentHandler)contributorHandlerClass.getConstructor(Map.class).newInstance(parameters);
                                }
                                catch (Exception exception) {
                                    this.delegate = this;
                                    EcorePlugin.INSTANCE.log(exception);
                                }
                            }
                        }
                    }
                    return this.delegate;
                }

                @Override
                public boolean canHandle(URI uri) {
                    ContentHandler delegate = this.getDelegate();
                    return delegate != this && delegate.canHandle(uri);
                }

                @Override
                public Map<String, ?> contentDescription(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
                    ContentHandler delegate = this.getDelegate();
                    if (delegate != this) {
                        return delegate.contentDescription(uri, inputStream, options, context);
                    }
                    return Collections.emptyMap();
                }
            }
            Delegate contentHandler = new Delegate(element, contributorClassName);
            ContentHandler.Registry.INSTANCE.put(priority, contentHandler);
            List<ContentHandler> contributions = CONTRIBUTION_MAP.get(contributorName);
            if (contributions == null) {
                contributions = new ArrayList<ContentHandler>();
                CONTRIBUTION_MAP.put(contributorName, contributions);
            }
            contributions.add(contentHandler);
            return true;
        }
        List<ContentHandler> contributions = CONTRIBUTION_MAP.get(contributorName);
        if (contributions != null) {
            for (List values : ContentHandler.Registry.INSTANCE.values()) {
                values.removeAll(contributions);
            }
        }
        CONTRIBUTION_MAP.remove(contributorName);
        return true;
    }
}

