/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.BasicSessionControl;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ET_RunTestControl;
import com.sun.javatest.exec.ElapsedTimeMonitor;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.MessageStrip;
import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.exec.ProgressMonitor;
import com.sun.javatest.exec.RunProgressMonitor;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.TestTreePanel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;

class RunTestsHandler
implements ET_RunTestControl,
Session.Observer {
    private JComponent parent;
    private ExecModel model;
    private Session config;
    private UIFactory uif;
    private TreePanelModel tpm;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private Parameters localParams;
    private Action showProgressAction;
    private Action startAction;
    private Action stopAction;
    private Harness harness;
    private HarnessObserver observer;
    private MonitorState mState;
    private MessageStrip messageStrip;
    private ProgressMonitor progMonitor;
    private boolean waitForConfig;
    private String[] whatToRun;
    private final ArrayList<ET_RunTestControl.Observer> observers = new ArrayList();

    RunTestsHandler(JComponent parent, ExecModel model, UIFactory uif) {
        this.parent = parent;
        this.model = model;
        this.uif = uif;
        this.initActions();
        this.initHarness();
    }

    @Override
    public void runTests() {
        this.start();
    }

    @Override
    public void setConfig(Session config) {
        this.config = config;
    }

    @Override
    public void setTreePanelModel(TreePanelModel tpm) {
        this.tpm = tpm;
        if (this.progMonitor != null) {
            this.progMonitor.setTreePanelModel(tpm);
        }
    }

    @Override
    public JMenu getMenu() {
        int i;
        JMenuItem[] items;
        JMenu menu = this.uif.createMenu("rh");
        menu.add(this.uif.createMenuItem(this.startAction));
        menu.add(this.uif.createMenuItem(this.stopAction));
        ContextManager cm = this.model.getContextManager();
        JavaTestMenuManager mm = null;
        if (cm != null && (mm = cm.getMenuManager()) != null && (items = mm.getMenuItems(7)) != null) {
            for (i = 0; i < items.length; ++i) {
                menu.add(items[i]);
            }
        }
        menu.addSeparator();
        menu.add(this.uif.createMenuItem(this.showProgressAction));
        if (mm != null && (items = mm.getMenuItems(8)) != null) {
            menu.addSeparator();
            for (i = 0; i < items.length; ++i) {
                menu.add(items[i]);
            }
        }
        return menu;
    }

    Action[] getToolBarActions() {
        return new Action[]{this.startAction, this.stopAction};
    }

    @Override
    public Harness getHarness() {
        return this.harness;
    }

    MessageStrip getMessageStrip() {
        if (this.messageStrip == null) {
            Monitor[] monitors = new Monitor[]{new ElapsedTimeMonitor(this.mState, this.uif), new RunProgressMonitor(this.mState, this.uif)};
            ActionListener zoom = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunTestsHandler.this.setProgressMonitorVisible(!RunTestsHandler.this.isProgressMonitorVisible());
                }
            };
            this.messageStrip = new MessageStrip(this.uif, monitors, this.mState, zoom);
            this.messageStrip.setRunningMonitor(monitors[1]);
            this.messageStrip.setIdleMonitor(monitors[0]);
            this.harness.addObserver(this.messageStrip);
        }
        return this.messageStrip;
    }

    @Override
    public JComponent getViewComponent() {
        return this.getMessageStrip();
    }

    @Override
    public List<Action> getToolBarActionList() {
        return Arrays.asList(this.getToolBarActions());
    }

    @Override
    public void save(Map m) {
    }

    @Override
    public void restore(Map m) {
    }

    @Override
    public synchronized void dispose() {
        if (this.harness != null) {
            this.harness.stop();
            this.harness = null;
        }
        this.parent = null;
        this.model = null;
        this.config = null;
        this.tpm = null;
        if (this.progMonitor != null) {
            this.progMonitor.dispose();
        }
    }

    @Override
    public void updateGUI() {
        this.testSuite = this.model.getTestSuite();
        this.workDir = this.model.getWorkDirectory();
        if (this.testSuite != null && !this.model.isConfiguring()) {
            if (!this.startAction.isEnabled() && !this.stopAction.isEnabled()) {
                this.startAction.setEnabled(true);
            }
        } else {
            this.startAction.setEnabled(false);
        }
        this.waitForConfig = this.waitForConfig && this.model.isConfiguring();
    }

    void start() {
        if (!this.interviewReady()) {
            this.model.configure();
            this.waitForConfig = true;
            this.whatToRun = null;
        }
        this.startIfReady();
    }

    private void startIfReady() {
        this.startAction.setEnabled(false);
        if (this.interviewReady()) {
            this.waitForConfig = false;
            this.startHarness(this.config.getParameters());
        } else {
            this.startAction.setEnabled(!this.model.isConfiguring());
        }
    }

    @Override
    public void executeImmediate(String[] paths) {
        if (!this.interviewReady()) {
            this.model.configure();
            this.waitForConfig = true;
            this.whatToRun = paths;
        }
        this.executeImmediateIfReady(paths);
    }

    private void executeImmediateIfReady(String[] paths) {
        Parameters.MutableTestsParameters mtps;
        Parameters.TestsParameters tps;
        Object p;
        if (!this.interviewReady()) {
            this.startAction.setEnabled(!this.model.isConfiguring());
            return;
        }
        this.waitForConfig = false;
        this.startAction.setEnabled(false);
        Parameters params = this.config.getParameters();
        Object[] items = new Object[]{params.getEnv().getName(), TestTreePanel.createNodeListString(TestTreePanel.createNodeList(paths))};
        int option = 0;
        if (paths[0].equals("")) {
            option = this.uif.showYesNoDialog("rh.confirmQuickAll", new Object[]{params.getEnv().getName()});
        } else {
            p = this.uif.createPanel("rh.confirmPanel", false);
            JTextArea msg = this.uif.createMessageArea("rh.confirmQuick", new Object[]{params.getEnv().getName()});
            ((Container)p).setLayout(new BorderLayout());
            ((Container)p).add((Component)msg, "North");
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int i = paths.length; i > 0; --i) {
                model.add(model.getSize(), paths[model.getSize()]);
            }
            JList list = this.uif.createList("rh.confirmList", model);
            ((Container)p).add((Component)this.uif.createScrollPane(list, 20, 30), "Center");
            option = this.uif.showCustomYesNoDialog("rh.confirmQuick", (Component)p);
        }
        if (option != 0) {
            this.startAction.setEnabled(true);
            return;
        }
        if (this.localParams != null && this.localParams instanceof InterviewParameters) {
            ((InterviewParameters)this.localParams).dispose();
        }
        try {
            this.localParams = BasicSessionControl.clone(params);
        }
        catch (Session.Fault e) {
            throw new RuntimeException("TBD: i18n cannot clone parameters");
        }
        p = Preferences.access();
        boolean useTests2Run = ((Preferences)p).getPreference("exec.tests2runPop", "false").equals("true");
        if (!useTests2Run) {
            tps = this.localParams.getTestsParameters();
            mtps = (Parameters.MutableTestsParameters)tps;
            if (paths == null || paths.length == 0 || paths[0].equals("")) {
                mtps.setTestsMode(1);
            } else {
                mtps.setTestsMode(2);
                mtps.setTests(paths);
            }
        } else if (paths != null && paths.length != 0 && !paths[0].equals("")) {
            tps = this.localParams.getTestsParameters();
            mtps = (Parameters.MutableTestsParameters)tps;
            if (mtps.getTestsMode() == 1) {
                mtps.setTests(paths);
            } else {
                mtps.setTestsMode(2);
                String[] origTests = mtps.getSpecifiedTests();
                if (origTests == null || origTests.length == 0) {
                    mtps.setTests(paths);
                } else {
                    String[] combined = RunTestsHandler.reprocessTests2Run(paths, origTests);
                    if (combined == null || combined.length == 0) {
                        this.uif.showInformationDialog("rh.nointersection", paths);
                        return;
                    }
                    mtps.setTests(combined);
                }
            }
        }
        this.startHarness(this.localParams);
    }

    static String[] reprocessTests2Run(String[] requested, String[] iTests) {
        int pound;
        int slash;
        int j;
        String curr;
        int i;
        ArrayList<String> result = new ArrayList<String>();
        block0: for (i = 0; i < requested.length; ++i) {
            curr = requested[i];
            for (j = 0; j < iTests.length; ++j) {
                slash = curr.lastIndexOf(47);
                int n = pound = slash == -1 ? curr.lastIndexOf(35) : curr.lastIndexOf(slash, 35);
                if (!curr.startsWith(iTests[j]) || curr.length() != iTests[j].length() && curr.charAt(iTests[j].length()) != '#' && curr.charAt(iTests[j].length()) != '/') continue;
                result.add(curr);
                continue block0;
            }
        }
        for (i = 0; i < iTests.length; ++i) {
            curr = iTests[i];
            for (j = 0; j < requested.length; ++j) {
                slash = curr.lastIndexOf(47);
                int n = pound = slash == -1 ? curr.lastIndexOf(35) : curr.lastIndexOf(slash, 35);
                if (!curr.startsWith(requested[j]) || curr.length() != requested[j].length() && curr.charAt(requested[j].length()) != '#' && curr.charAt(requested[j].length()) != '/') continue;
                result.add(curr);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean interviewReady() {
        return this.workDir != null && this.config.isReady();
    }

    private void startHarness(Parameters ips) {
        this.notifyStarted(ips);
        try {
            if (!this.config.getParameters().getWorkDirectory().getTestResultTable().isReady()) {
                I18NResourceBundle i18n = this.uif.getI18NResourceBundle();
                this.messageStrip.showMessage(i18n, "rh.waitToStart.txt");
            }
            this.harness.start(ips);
            this.notifyFinished(ips);
        }
        catch (Harness.Fault e) {
            this.uif.showError("rh", e.toString());
        }
    }

    private void initHarness() {
        this.harness = new Harness();
        BackupPolicy backupPolicy = new BackupPolicy(){
            private int numBackupsToKeep = Integer.getInteger("javatest.backup.count", 5);
            private String[] ignoreExtns = StringArray.split(System.getProperty("javatest.backup.ignore", ".jtr"));

            @Override
            public int getNumBackupsToKeep(File file) {
                return this.numBackupsToKeep;
            }

            @Override
            public boolean isBackupRequired(File file) {
                if (this.ignoreExtns != null) {
                    for (int i = 0; i < this.ignoreExtns.length; ++i) {
                        if (!file.getPath().endsWith(this.ignoreExtns[i])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        this.harness.setBackupPolicy(backupPolicy);
        this.observer = new HarnessObserver();
        this.harness.addObserver(this.observer);
        this.mState = new MonitorState(this.harness);
    }

    private boolean isProgressMonitorVisible() {
        return this.progMonitor != null && this.progMonitor.isVisible();
    }

    private void setProgressMonitorVisible(boolean state) {
        if (this.progMonitor == null) {
            this.progMonitor = new ProgressMonitor((Component)this.parent, this.uif, this.mState);
            this.progMonitor.setTreePanelModel(this.tpm);
        }
        this.progMonitor.setVisible(state);
    }

    private void initActions() {
        this.showProgressAction = new ToolAction(this.uif, "rh.progress"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunTestsHandler.this.setProgressMonitorVisible(true);
            }
        };
        this.startAction = new ToolAction(this.uif, "rh.start", true){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunTestsHandler.this.start();
            }
        };
        this.stopAction = new ToolAction(this.uif, "rh.stop", true){
            {
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RunTestsHandler.this.harness.stop();
            }
        };
    }

    @Override
    public void addObserver(ET_RunTestControl.Observer obs) {
        if (obs != null && !this.observers.contains(obs)) {
            this.observers.add(obs);
        }
    }

    @Override
    public void removeObserver(ET_RunTestControl.Observer obs) {
        if (obs != null && this.observers.contains(obs)) {
            this.observers.remove(obs);
        }
    }

    public void notifyStarted(Parameters p) {
        for (ET_RunTestControl.Observer obs : this.observers) {
            obs.startTests(p);
        }
    }

    public void notifyFinished(Parameters p) {
        for (ET_RunTestControl.Observer obs : this.observers) {
            obs.finishTests(p);
        }
    }

    @Override
    public void updated(Session.Event ev) {
        if (ev instanceof BasicSession.E_NewConfig) {
            if (this.waitForConfig) {
                this.waitForConfig = false;
                if (this.whatToRun == null) {
                    this.startIfReady();
                } else {
                    this.executeImmediateIfReady(this.whatToRun);
                }
            }
        } else if (ev instanceof BasicSessionControl.E_EditorVisibility) {
            this.updateGUI();
        }
    }

    private class HarnessObserver
    implements Harness.Observer {
        private HarnessObserver() {
        }

        @Override
        public void startingTestRun(Parameters params) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunTestsHandler.this.startAction.setEnabled(false);
                    RunTestsHandler.this.stopAction.setEnabled(true);
                    I18NResourceBundle i18n = RunTestsHandler.this.uif.getI18NResourceBundle();
                    RunTestsHandler.this.messageStrip.showMessage(i18n, "rh.starting.txt");
                }
            });
        }

        @Override
        public void startingTest(TestResult tr) {
        }

        @Override
        public void finishedTest(TestResult tr) {
        }

        @Override
        public void stoppingTestRun() {
        }

        @Override
        public void finishedTesting() {
        }

        @Override
        public void finishedTestRun(boolean allOK) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunTestsHandler.this.startAction.setEnabled(true);
                    RunTestsHandler.this.stopAction.setEnabled(false);
                }
            });
            if (RunTestsHandler.this.localParams != null && RunTestsHandler.this.localParams instanceof InterviewParameters) {
                ((InterviewParameters)RunTestsHandler.this.localParams).dispose();
                RunTestsHandler.this.localParams = null;
            }
        }

        @Override
        public void error(final String msg) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunTestsHandler.this.uif.showError("rh.error", msg);
                }
            });
        }
    }
}

