/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.ContentType;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setParameterList()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 * 
 *		Set a new ParameterList. <p>
 * api2test: public void setParameterList(ParameterList)  <p>
 *
 * how2test: Call API with ParameterList argument, verify by calling getParameterList(),
 *	     If set/get argument are equal then testcase passes, otherwise it fails.
 */

public class setParameterList_Test extends MailTest {

    public static void main( String argv[] )
    {
        setParameterList_Test test = new setParameterList_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	 super.run(argv, log, out);
	// parse command-line options
	parseArgs(argv);

        out.println("\nTesting class ContentType: setParameterList(ParameterList)\n");

        try {
	   // Create ContentType object
              ContentType ct = new ContentType(pattern);

              if( ct == null )
		  return Status.failed("Failed to create ContentType object!");

           // BEGIN UNIT TEST 1:
           // Create a ParameterList object
              ParameterList paramlist = new ParameterList(";charset=uscii;charset=ISO-9000-1");

              if( paramlist == null )
                  return Status.failed("Failed to create ParameterList object!");

              out.println("UNIT TEST 1: setParameterList(ParameterList)");
	      ct.setParameterList(paramlist);	// API TEST
              ParameterList plist = ct.getParameterList();

              if( plist != null )
                  out.println("UNIT TEST 1: passed.\n");
              else {
                    out.println("UNIT TEST 1: FAILED.\n");
                    errors++;
              }
           // END UNIT TEST 1:

              checkStatus();
        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
