/*
 * Copyright (c) 2002-2016 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Transport;

/**
 * This class tests the <strong>connect()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.     <p>
 *
 *              Generic connect method that takes no parameters. <p>
 * api2test: public void connect()     <p>
 *              Connect to the specified address. <p>
 * api2test: public void connect(String, String, String)  <p>
 *
 * how2test: Call these APIs with or without address. If this operation is
 *           successfull then this testcase passes otherwise it fails. <p>
 */

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

public class connect_Test extends MailTest {

    public static String FROM;
    public static String TO;
    public static final String SUBJECT = "Transport protocol mail";
    public static final String TEXT = "This is a test of Transport class!";
    public static final String MAILER = "JavaMail";
    static String msgText = "This is a message body.\nHere's the second line.";

    public static void main( String argv[] )
    {
        connect_Test test = new connect_Test();
        Status s = test.run(argv, System.err, System.out);
        s.exit();
    }

    public Status run( String argv[], PrintWriter log, PrintWriter out )
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

	FROM = from;
	TO = to;

	out.println("\nTesting Transport class API => connect(String, String, String)\n");

	try {
	   // Get a Session object
	      Session session = createSession();

	   // Get a Transport object
	      Transport transport = session.getTransport(transport_protocol);

	   // Create a MimeMessage object
	      MimeMessage msg = new MimeMessage(session);

              if( msg == null ) {
                  return Status.failed("WARNING: Failed to create a message object");
              }
           // Construct an address array
              InternetAddress addr = new InternetAddress(to);

	      if ( addr == null ) {
		   return Status.failed("WARNING: Failed to create a InternetAddress object");
	      }
              InternetAddress addrs[] = new InternetAddress[1];
              addrs[0] = addr;

              msg.setFrom(addr);
              msg.setRecipients(Message.RecipientType.TO, addrs);
              msg.setSubject("JavaMail send() API Test");
              msg.setContent(msgText, "text/plain");

	    // BEGIN UNIT TEST 1:
	      out.println("UNIT TEST 1:  connect(host, user, password)");
	      out.println("		 connect()");

	     // Connect
              if( transport_host != null ) {
		  if( auth )
		      transport.connect(transport_host, user, password); // API TEST
		  else
		      transport.connect(transport_host, null, null); // API TEST
              } else
                  transport.connect();				// API TEST

	      out.println("UNIT TEST 1: passed\n");
	    // END UNIT TEST 1:

	    // send the mail message via specified 'protocol'
              transport.sendMessage(msg, addrs);

	      status = Status.passed("OKAY");
        } catch (Exception e) {
              handlException(e);
          }
	  return status;
    }
}
