/*
 * Copyright (c) 2002, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package javasoft.sqe.tests.javax.mail.Session;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getProviders()</strong> API.
 * It does this by passing various valid input values and then checking the type
 * of the object returned.  <p>
 *
 *		Returns an array of all the implementations. <p>
 * api2test: public Provider[] getProviders()  <p>
 *	     All the implementations installed via the javamail.[default.]provider
 *	     files that can be loaded using the ClassLoader available to this application. <p>
 *
 * how2test: Call this API, output elements of the returned array of implementations.
 *	     If this API returns a valid array object then the test passes.
 */

public class getProviders_Test extends MailTest {

    public static void main( String argv[] )
    {
        getProviders_Test test = new getProviders_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

	out.println("\nTesting class Session: getProviders()\n");

        try {
          // BEGIN UNIT TEST 1:
	     // Get Session object
             Session session = Session.getInstance(properties, null);
             out.println("UNIT TEST 1: getProviders()");

             Provider[] provs = session.getProviders(); // API TEST

             if( provs.length > 0 ) {
		 out.println(provs[0]);
                 out.println("UNIT TEST 1:  passed\n");
             } else {
                     out.println("UNIT TEST 1:  FAILED\n");
                     errors++;
             }
          // END UNIT TEST 1:
	     checkStatus();

        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
