/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.sort;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.sort.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.sort.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.provider.sort.TextPlainStringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.spec.provider.sort.TextWildCardStringBeanEntityProvider;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_sort_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/sort/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_sort_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, TextPlainStringBeanEntityProvider.class, TextWildCardStringBeanEntityProvider.class, StringBeanEntityProvider.class, StringBean.class, JaxrsUtil.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void contentTypeApplicationGotWildCardTest() throws JAXRSCommonClient.Fault {
        MediaType type = new MediaType("application", "plain");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, ""));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(type));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(type));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "test");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "test");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "text");
        this.invoke();
    }

    @Test
    public void contentTypeTextHmtlGotTextWildCardTest() throws JAXRSCommonClient.Fault {
        MediaType type = MediaType.TEXT_HTML_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, ""));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(type));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(type));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "test");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "test");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/*");
        this.invoke();
    }

    @Test
    public void contentTypeTextXmlGotTextWildCardTest() throws JAXRSCommonClient.Fault {
        MediaType type = MediaType.TEXT_XML_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, ""));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(type));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(type));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "test");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "test");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/*");
        this.invoke();
    }

    @Test
    public void contentTypeTextPlainGotTextPlainTest() throws JAXRSCommonClient.Fault {
        MediaType type = MediaType.TEXT_PLAIN_TYPE;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, ""));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(type));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(type));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "test");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "test");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.invoke();
    }
}

