/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.metro.parser;

import jakarta.xml.ws.WebServiceFeature;

public class ParsedElement {
    private final String portComponentName;
    private final String portComponentRefName;
    private final String operationWsdlName;
    private final boolean isInputMessage;
    private final boolean isOutputMessage;
    private final String faultWsdlName;
    private final WebServiceFeature webServiceFeature;

    private ParsedElement(String portComponentName, String portComponentRefName, String operationName, boolean isInputMessage, boolean isOutputMessage, String faultName, WebServiceFeature feature) {
        this.portComponentName = portComponentName;
        this.portComponentRefName = portComponentRefName;
        this.operationWsdlName = operationName;
        this.isInputMessage = isInputMessage;
        this.isOutputMessage = isOutputMessage;
        this.faultWsdlName = faultName;
        this.webServiceFeature = feature;
    }

    public static ParsedElement createPortComponentElement(String portComponentName, WebServiceFeature feature) {
        return new ParsedElement(portComponentName, null, null, false, false, null, feature);
    }

    public static ParsedElement createPortComponentRefElement(String portComponentRefName, WebServiceFeature feature) {
        return new ParsedElement(null, portComponentRefName, null, false, false, null, feature);
    }

    public static ParsedElement createPortComponentOperationElement(String portComponentName, String operationWsdlName, WebServiceFeature feature) {
        return new ParsedElement(portComponentName, null, operationWsdlName, false, false, null, feature);
    }

    public static ParsedElement createPortComponentRefOperationElement(String portComponentRefName, String operationWsdlName, WebServiceFeature feature) {
        return new ParsedElement(null, portComponentRefName, operationWsdlName, false, false, null, feature);
    }

    public static ParsedElement createPortComponentInputElement(String portComponentName, String operationWsdlName, WebServiceFeature feature) {
        return new ParsedElement(portComponentName, null, operationWsdlName, true, false, null, feature);
    }

    public static ParsedElement createPortComponentRefInputElement(String portComponentRefName, String operationWsdlName, WebServiceFeature feature) {
        return new ParsedElement(null, portComponentRefName, operationWsdlName, true, false, null, feature);
    }

    public static ParsedElement createPortComponentOutputElement(String portComponentName, String operationWsdlName, WebServiceFeature feature) {
        return new ParsedElement(portComponentName, null, operationWsdlName, false, true, null, feature);
    }

    public static ParsedElement createPortComponentRefOutputElement(String portComponentRefName, String operationWsdlName, WebServiceFeature feature) {
        return new ParsedElement(null, portComponentRefName, operationWsdlName, false, true, null, feature);
    }

    public static ParsedElement createPortComponentFaultElement(String portComponentName, String operationWsdlName, String faultWsdlName, WebServiceFeature feature) {
        return new ParsedElement(portComponentName, null, operationWsdlName, false, false, faultWsdlName, feature);
    }

    public static ParsedElement createPortComponentRefFaultElement(String portComponentRefName, String operationWsdlName, String faultWsdlName, WebServiceFeature feature) {
        return new ParsedElement(null, portComponentRefName, operationWsdlName, false, false, faultWsdlName, feature);
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public String getPortComponentRefName() {
        return this.portComponentRefName;
    }

    public String getOperationWsdlName() {
        return this.operationWsdlName;
    }

    public String getFaultWsdlName() {
        return this.faultWsdlName;
    }

    public WebServiceFeature getWebServiceFeature() {
        return this.webServiceFeature;
    }

    public boolean isInputMessage() {
        return this.isInputMessage;
    }

    public boolean isOutputMessage() {
        return this.isOutputMessage;
    }

    public boolean isPortComponent() {
        return this.portComponentName != null && this.operationWsdlName == null;
    }

    public boolean isPortComponentRef() {
        return this.portComponentRefName != null && this.operationWsdlName == null;
    }

    public boolean isPortComponentOperation() {
        return this.portComponentName != null && this.operationWsdlName != null && !this.isInputMessage && !this.isOutputMessage && this.faultWsdlName == null;
    }

    public boolean isPortComponentRefOperation() {
        return this.portComponentRefName != null && this.operationWsdlName != null && !this.isInputMessage && !this.isOutputMessage && this.faultWsdlName == null;
    }

    public boolean isPortComponentInput() {
        return this.portComponentName != null && this.operationWsdlName != null && this.isInputMessage;
    }

    public boolean isPortComponentOutput() {
        return this.portComponentName != null && this.operationWsdlName != null && this.isOutputMessage;
    }

    public boolean isPortComponentFault() {
        return this.portComponentName != null && this.operationWsdlName != null && this.faultWsdlName != null;
    }

    public boolean isPortComponentRefInput() {
        return this.portComponentRefName != null && this.operationWsdlName != null && this.isInputMessage;
    }

    public boolean isPortComponentRefOutput() {
        return this.portComponentRefName != null && this.operationWsdlName != null && this.isOutputMessage;
    }

    public boolean isPortComponentRefFault() {
        return this.portComponentRefName != null && this.operationWsdlName != null && this.faultWsdlName != null;
    }

    public String toString() {
        StringBuilder text = new StringBuilder("ParsedElement: ");
        if (this.isPortComponent()) {
            text.append("port component [");
            text.append(this.portComponentName);
            text.append(']');
        } else if (this.isPortComponentRef()) {
            text.append("port component ref [");
            text.append(this.portComponentRefName);
            text.append(']');
        } else if (this.isPortComponentOperation()) {
            text.append("port component operation [");
            text.append(this.portComponentName);
            text.append(", ");
            text.append(this.operationWsdlName);
            text.append(']');
        } else if (this.isPortComponentRefOperation()) {
            text.append("port component ref operation [");
            text.append(this.portComponentRefName);
            text.append(", ");
            text.append(this.operationWsdlName);
            text.append(']');
        } else if (this.isPortComponentInput()) {
            text.append("port component input [");
            text.append(this.portComponentName);
            text.append(", ");
            text.append(this.operationWsdlName);
            text.append(']');
        } else if (this.isPortComponentRefInput()) {
            text.append("port component ref input [");
            text.append(this.portComponentName);
            text.append(", ");
            text.append(this.operationWsdlName);
            text.append(']');
        } else if (this.isPortComponentOutput()) {
            text.append("port component output [");
            text.append(this.portComponentName);
            text.append(", ");
            text.append(this.operationWsdlName);
            text.append(']');
        } else if (this.isPortComponentRefOutput()) {
            text.append("port component ref output [");
            text.append(this.portComponentName);
            text.append(", ");
            text.append(this.operationWsdlName);
            text.append(']');
        } else if (this.isPortComponentFault()) {
            text.append("port component fault [");
            text.append(this.portComponentName);
            text.append(", ");
            text.append(this.operationWsdlName);
            text.append(", ");
            text.append(this.faultWsdlName);
            text.append(']');
        } else if (this.isPortComponentRefFault()) {
            text.append("port component ref fault [");
            text.append(this.portComponentRefName);
            text.append(", ");
            text.append(this.operationWsdlName);
            text.append(", ");
            text.append(this.faultWsdlName);
            text.append(']');
        } else {
            text.append("unknown element");
        }
        text.append(" -> [");
        text.append(this.webServiceFeature);
        text.append(']');
        return text.toString();
    }
}

