/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;

public final class UnionClause
extends AbstractExpression {
    private String actualIdentifier;
    private String allIdentifier;
    private boolean hasSpaceAfterAll;
    private boolean hasSpaceAfterIdentifier;
    private AbstractExpression query;

    public UnionClause(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getQuery().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getQuery());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpaceAfterIdentifier) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.allIdentifier != null) {
            children.add(this.buildStringExpression("ALL"));
            if (this.hasSpaceAfterAll) {
                children.add(this.buildStringExpression(' '));
            }
        }
        if (this.query != null) {
            children.add(this.query);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.query != null && this.query.isAncestor(expression)) {
            return this.getQueryBNF("subquery");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualAll() {
        return this.allIdentifier;
    }

    public String getActualIdentifier() {
        return this.actualIdentifier;
    }

    public String getIdentifier() {
        return this.getText();
    }

    public Expression getQuery() {
        if (this.query == null) {
            this.query = this.buildNullExpression();
        }
        return this.query;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("union_clause");
    }

    public boolean hasAll() {
        return this.allIdentifier != null;
    }

    public boolean hasQuery() {
        return this.query != null && !this.query.isNull();
    }

    public boolean hasSpaceAfterAll() {
        return this.hasSpaceAfterAll;
    }

    public boolean hasSpaceAfterIdentifier() {
        return this.hasSpaceAfterIdentifier;
    }

    public boolean isExcept() {
        return this.getText() == "EXCEPT";
    }

    public boolean isIntersect() {
        return this.getText() == "INTERSECT";
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("UNION") || word.equalsIgnoreCase("INTERSECT") || word.equalsIgnoreCase("EXCEPT") || super.isParsingComplete(wordParser, word, expression);
    }

    public boolean isUnion() {
        return this.getText() == "UNION";
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        String identifier = this.parseIdentifier();
        this.actualIdentifier = wordParser.moveForward(identifier);
        this.setText(identifier);
        boolean bl = this.hasSpaceAfterIdentifier = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("ALL")) {
            this.allIdentifier = wordParser.moveForward("ALL");
            boolean bl2 = this.hasSpaceAfterAll = wordParser.skipLeadingWhitespace() > 0;
        }
        if (tolerant) {
            this.query = this.parse(wordParser, "subquery", tolerant);
        } else {
            this.query = new SimpleSelectStatement(this);
            this.query.parse(wordParser, tolerant);
        }
    }

    protected String parseIdentifier() {
        return switch (this.getText().charAt(0)) {
            case 'U', 'u' -> "UNION";
            case 'I', 'i' -> "INTERSECT";
            case 'E', 'e' -> "EXCEPT";
            default -> null;
        };
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.actualIdentifier : this.getText());
        if (this.hasSpaceAfterIdentifier) {
            writer.append(' ');
        }
        if (this.allIdentifier != null) {
            writer.append(actual ? this.allIdentifier : "ALL");
            if (this.hasSpaceAfterAll) {
                writer.append(' ');
            }
        }
        if (this.query != null) {
            this.query.toParsedText(writer, actual);
        }
    }
}

