/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.api;

import jakarta.annotation.PostConstruct;
import jakarta.ejb.Singleton;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.nio.channels.SelectableChannel;
import java.rmi.Remote;
import java.util.Properties;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBFactory;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ORBLocator;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.ServerRequestInfo;

@Service
@Singleton
public class GlassFishORBHelper
implements ORBLocator {
    private static final System.Logger LOG = System.getLogger(GlassFishORBHelper.class.getName());
    @Inject
    private Provider<Events> eventsProvider;
    @Inject
    private ServiceLocator services;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private Provider<ProtocolManager> protocolManagerProvider;
    @Inject
    private Provider<GlassfishNamingManager> glassfishNamingManagerProvider;
    private ProtocolManager protocolManager;
    private SelectableChannelDelegate selectableChannelDelegate;
    private GlassFishORBFactory orbFactory;
    private volatile ORB orb;
    private volatile boolean destroyed;

    @PostConstruct
    public void postConstruct() {
        EventListener glassfishEventListener = event -> {
            if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                this.onShutdown();
            }
        };
        ((Events)this.eventsProvider.get()).register(glassfishEventListener);
        this.orbFactory = (GlassFishORBFactory)this.services.getService(GlassFishORBFactory.class, new Annotation[0]);
        LOG.log(System.Logger.Level.INFO, "GlassFishORBLocator created.");
    }

    private void onShutdown() {
        this.destroyed = true;
        LOG.log(System.Logger.Level.INFO, "ORB shutdown started");
        if (this.orb != null) {
            ORB destroyedOrb = this.orb;
            this.orb = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            destroyedOrb.destroy();
        }
    }

    public synchronized void setORB(ORB orb) {
        this.orb = orb;
    }

    public ORB getORB() {
        ORB orbInstance = this.orb;
        if (orbInstance != null || this.destroyed) {
            return orbInstance;
        }
        GlassFishORBHelper glassFishORBHelper = this;
        synchronized (glassFishORBHelper) {
            if (this.orb != null) {
                return this.orb;
            }
            try {
                boolean isServer = this.processEnv.getProcessType().isServer();
                Properties props = new Properties();
                props.setProperty("com.sun.corba.ee.ORBEnvironmentIsGlassFishServer", Boolean.toString(isServer));
                this.orb = this.orbFactory.createORB(props);
                if (isServer && this.protocolManager == null) {
                    this.protocolManager = this.initProtocolManager(this.orb);
                }
                return this.orb;
            }
            catch (Exception e) {
                this.orb = null;
                this.protocolManager = null;
                throw new RuntimeException("Orb initialization erorr", e);
            }
        }
    }

    private ProtocolManager initProtocolManager(ORB orbInstance) throws Exception {
        ProtocolManager manager = (ProtocolManager)this.protocolManagerProvider.get();
        manager.initialize(orbInstance);
        manager.initializePOAs();
        GlassfishNamingManager namingManager = (GlassfishNamingManager)this.glassfishNamingManagerProvider.get();
        Remote remoteSerialProvider = namingManager.initializeRemoteNamingSupport(orbInstance);
        manager.initializeRemoteNaming(remoteSerialProvider);
        return manager;
    }

    public void setSelectableChannelDelegate(SelectableChannelDelegate d) {
        this.selectableChannelDelegate = d;
    }

    public SelectableChannelDelegate getSelectableChannelDelegate() {
        return this.selectableChannelDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolManager getProtocolManager() {
        if (!this.processEnv.getProcessType().isServer() || this.destroyed) {
            return null;
        }
        GlassFishORBHelper glassFishORBHelper = this;
        synchronized (glassFishORBHelper) {
            if (this.protocolManager == null) {
                this.getORB();
            }
            return this.protocolManager;
        }
    }

    public boolean isORBInitialized() {
        return this.orb != null;
    }

    public int getOTSPolicyType() {
        return this.orbFactory.getOTSPolicyType();
    }

    public int getCSIv2PolicyType() {
        return this.orbFactory.getCSIv2PolicyType();
    }

    public Properties getCSIv2Props() {
        return this.orbFactory.getCSIv2Props();
    }

    public void setCSIv2Prop(String name, String value) {
        this.orbFactory.setCSIv2Prop(name, value);
    }

    public int getORBInitialPort() {
        return this.orbFactory.getORBInitialPort();
    }

    public String getORBHost(ORB orb) {
        return this.orbFactory.getORBHost(orb);
    }

    public int getORBPort(ORB orb) {
        return this.orbFactory.getORBPort(orb);
    }

    public boolean isEjbCall(ServerRequestInfo sri) {
        return this.orbFactory.isEjbCall(sri);
    }

    public static interface SelectableChannelDelegate {
        public void handleRequest(SelectableChannel var1);
    }
}

