/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;

public abstract class JFiler {
    private String encoding = "utf-8";

    public static JFiler newInstance(final Filer filer) {
        return new JFiler(){

            @Override
            public OutputStream openStream(String packageName, String fileName) throws IOException {
                StringBuilder sb = new StringBuilder(packageName);
                if (sb.charAt(sb.length() - 1) != '.') {
                    sb.append('.');
                }
                sb.append(fileName);
                return filer.createSourceFile(sb, new Element[0]).openOutputStream();
            }
        };
    }

    public static JFiler newInstance(final File target) {
        return new JFiler(){

            @Override
            public OutputStream openStream(String packageName, String fileName) throws IOException {
                File dir = new File(target, packageName.replace('.', File.separatorChar));
                dir.mkdirs();
                return new FileOutputStream(new File(dir, fileName + ".java"));
            }
        };
    }

    protected JFiler() {
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public abstract OutputStream openStream(String var1, String var2) throws IOException;

    public Writer openWriter(String packageName, String fileName) throws IOException {
        return new OutputStreamWriter(this.openStream(packageName, fileName), this.encoding);
    }
}

