/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.ssl;

import com.sun.messaging.PropertyOwner;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.StreamHandler;
import com.sun.messaging.jmq.jmsclient.protocol.ssl.SSLConnectionHandler;
import jakarta.jms.JMSException;

public class SSLStreamHandler
implements StreamHandler,
PropertyOwner {
    @Override
    public String[] getPropertyNames() {
        String[] propnames = new String[]{"imqBrokerHostName", "imqBrokerHostPort", "imqBrokerServicePort", "imqBrokerServiceName", "imqSSLProviderClassname", "imqSSLIsHostTrusted"};
        return propnames;
    }

    @Override
    public String getPropertyType(String propname) {
        if ("imqBrokerHostName".equals(propname) || "imqBrokerServiceName".equals(propname) || "imqSSLProviderClassname".equals(propname)) {
            return "java.lang.String";
        }
        if ("imqBrokerHostPort".equals(propname)) {
            return "java.lang.Integer";
        }
        if ("imqSSLIsHostTrusted".equals(propname)) {
            return "java.lang.Boolean";
        }
        return null;
    }

    @Override
    public String getPropertyLabel(String propname) {
        if ("imqBrokerHostName".equals(propname)) {
            return "L0502";
        }
        if ("imqBrokerHostPort".equals(propname)) {
            return "L0503";
        }
        if ("imqSSLProviderClassname".equals(propname)) {
            return "L0504";
        }
        if ("imqSSLIsHostTrusted".equals(propname)) {
            return "L0505";
        }
        if ("imqBrokerServicePort".equals(propname)) {
            return "L0529";
        }
        if ("imqBrokerServiceName".equals(propname)) {
            return "L0528";
        }
        return null;
    }

    @Override
    public String getPropertyDefault(String propname) {
        if ("imqBrokerHostName".equals(propname)) {
            return "localhost";
        }
        if ("imqBrokerHostPort".equals(propname)) {
            return "7676";
        }
        if ("imqSSLProviderClassname".equals(propname)) {
            return "com.sun.net.ssl.internal.ssl.Provider";
        }
        if ("imqSSLIsHostTrusted".equals(propname)) {
            return "false";
        }
        if ("imqBrokerServicePort".equals(propname)) {
            return "0";
        }
        if ("imqBrokerServiceName".equals(propname)) {
            return "";
        }
        return null;
    }

    @Override
    public ConnectionHandler openConnection(Object connection) throws JMSException {
        return new SSLConnectionHandler(connection);
    }

    @Override
    public ConnectionHandler openConnection(MQAddress addr, ConnectionImpl connection) throws JMSException {
        return new SSLConnectionHandler(addr, connection);
    }
}

