/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.sql.Timestamp;
import java.time.Instant;
import org.eclipse.persistence.descriptors.AbstractTsLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class InstantLockingPolicy
extends AbstractTsLockingPolicy<Instant> {
    public InstantLockingPolicy() {
    }

    public InstantLockingPolicy(String fieldName) {
        super(fieldName);
    }

    InstantLockingPolicy(DatabaseField field) {
        super(field);
    }

    @Override
    int compareTsLockValues(Instant value1, Instant value2) {
        return value1.compareTo(value2);
    }

    @Override
    Class<Instant> getDefaultTsLockFieldType() {
        return ClassConstants.TIME_INSTANT;
    }

    @Override
    Instant getBaseTsValue() {
        return Instant.MIN;
    }

    @Override
    Instant getInitialTsWriteValue(AbstractSession session) {
        if (this.usesLocalTime()) {
            return Instant.now();
        }
        if (this.usesServerTime()) {
            AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
            while (readSession.isUnitOfWork()) {
                readSession = readSession.getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            Timestamp ts = readSession.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(session, readSession.getName());
            return ts.toInstant();
        }
        return null;
    }

    @Override
    Instant getNewTsLockValue(ModifyQuery query) {
        return this.getInitialTsWriteValue(query.getSession());
    }

    @Override
    Instant getTsValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.TIME_INSTANT);
        }
        return null;
    }

    @Override
    Instant getWriteTsLockValue(Object domainObject, Object primaryKey, AbstractSession session) {
        Instant writeLockFieldValue = null;
        if (this.isStoredInCache()) {
            writeLockFieldValue = (Instant)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor());
        } else {
            Object lockValue = this.lockValueFromObject(domainObject);
            if (lockValue != null) {
                if (lockValue instanceof Instant) {
                    writeLockFieldValue = (Instant)this.lockValueFromObject(domainObject);
                } else {
                    throw OptimisticLockException.needToMapJavaSqlTimestampWhenStoredInObject();
                }
            }
        }
        return writeLockFieldValue;
    }

    @Override
    boolean isNewerTsVersion(Instant current, Object domainObject, Object primaryKey, AbstractSession session) {
        Instant writeLockFieldValue = this.isStoredInCache() ? (Instant)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (Instant)this.lockValueFromObject(domainObject);
        return this.isNewerTsVersion(current, writeLockFieldValue);
    }

    @Override
    boolean isNewerTsVersion(AbstractRecord row, Object domainObject, Object primaryKey, AbstractSession session) {
        Instant newWriteLockFieldValue = session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.TIME_INSTANT);
        Instant writeLockFieldValue = this.isStoredInCache() ? (Instant)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (Instant)this.lockValueFromObject(domainObject);
        return this.isNewerTsVersion(newWriteLockFieldValue, writeLockFieldValue);
    }

    @Override
    boolean isNewerTsVersion(Instant first, Instant second) {
        if (first == null) {
            return false;
        }
        if (second == null) {
            return true;
        }
        return first.isAfter(second);
    }

    @Override
    public int getVersionDifference(Object currentValue, Object domainObject, Object primaryKeys, AbstractSession session) {
        Instant newWriteLockFieldValue = (Instant)currentValue;
        if (newWriteLockFieldValue == null) {
            return 0;
        }
        Instant writeLockFieldValue = this.isStoredInCache() ? (Instant)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKeys, domainObject.getClass(), this.getDescriptor()) : (Instant)this.lockValueFromObject(domainObject);
        if (newWriteLockFieldValue.equals(writeLockFieldValue)) {
            return 0;
        }
        if (writeLockFieldValue != null && !newWriteLockFieldValue.isAfter(writeLockFieldValue)) {
            return -1;
        }
        return 1;
    }
}

