/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.Addressing;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.AddressingFeature;
import jakarta.xml.ws.soap.MTOMFeature;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.ejb.api.EJBInvocation;
import org.glassfish.ejb.api.EjbEndpointFacade;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.webservices.AdapterInvocationInfo;
import org.glassfish.webservices.Ejb3MessageDispatcher;
import org.glassfish.webservices.EjbInvokerImpl;
import org.glassfish.webservices.EjbMessageDispatcher;
import org.glassfish.webservices.InstanceResolverImpl;
import org.glassfish.webservices.JAXWSContainer;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.WsUtil;

public class EjbRuntimeEndpointInfo {
    private static final Logger logger = LogUtils.getLogger();
    protected final WebServiceEndpoint endpoint;
    protected final EjbEndpointFacade container;
    protected final Object webServiceEndpointServant;
    private volatile ServletAdapter adapter = null;
    private ServletAdapterList adapterList = null;
    private WebServiceContextImpl wsCtxt = null;
    private boolean handlersConfigured = false;
    protected EjbMessageDispatcher messageDispatcher = null;

    public EjbRuntimeEndpointInfo(WebServiceEndpoint webServiceEndpoint, EjbEndpointFacade ejbContainer, Object servant) {
        this.endpoint = webServiceEndpoint;
        this.container = ejbContainer;
        this.webServiceEndpointServant = servant;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getEndpointAddressUri() {
        return this.endpoint.getEndpointAddressUri();
    }

    public synchronized WebServiceContext getWebServiceContext() {
        return this.wsCtxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object prepareInvocation(boolean doPreInvoke) throws Exception {
        EjbRuntimeEndpointInfo ejbRuntimeEndpointInfo;
        ComponentInvocation inv = null;
        AdapterInvocationInfo adapterInvInfo = new AdapterInvocationInfo();
        if (this.adapter == null) {
            ejbRuntimeEndpointInfo = this;
            synchronized (ejbRuntimeEndpointInfo) {
                if (this.adapter == null) {
                    try {
                        EjbDescriptor ejbDesc = this.endpoint.getEjbComponentImpl();
                        for (ResourceReferenceDescriptor r : ejbDesc.getResourceReferenceDescriptors()) {
                            if (!r.isWebServiceContext()) continue;
                            boolean matchingClassFound = false;
                            for (InjectionTarget target : r.getInjectionTargets()) {
                                if (!ejbDesc.getEjbClassName().equals(target.getClassName())) continue;
                                matchingClassFound = true;
                                break;
                            }
                            if (!matchingClassFound) continue;
                            try {
                                InitialContext ic = new InitialContext();
                                this.wsCtxt = (WebServiceContextImpl)ic.lookup("java:comp/env/" + r.getName());
                            }
                            catch (Throwable t) {
                                if (!logger.isLoggable(Level.FINE)) continue;
                                logger.log(Level.FINE, "AS-WSJSR109IMPL-00073", t.getCause());
                            }
                        }
                        if (this.wsCtxt == null) {
                            this.wsCtxt = new WebServiceContextImpl();
                        }
                    }
                    catch (Throwable t) {
                        LogHelper.log((Logger)logger, (Level)Level.SEVERE, (String)"AS-WSJSR109IMPL-00072", (Throwable)t, (Object[])new Object[]{this.endpoint.getName()});
                        return null;
                    }
                }
            }
        }
        if (doPreInvoke) {
            inv = this.container.startInvocation();
            adapterInvInfo.setInv(inv);
        }
        ejbRuntimeEndpointInfo = this;
        synchronized (ejbRuntimeEndpointInfo) {
            if (!this.handlersConfigured && doPreInvoke) {
                try {
                    HttpAdapter obj;
                    Object urlPattern;
                    WsUtil wsu = new WsUtil();
                    String implClassName = this.endpoint.getEjbComponentImpl().getEjbClassName();
                    Class<?> clazz = this.container.getEndpointClassLoader().loadClass(implClassName);
                    String givenBinding = this.endpoint.getProtocolBinding();
                    SDDocumentSource primaryWsdl = null;
                    Collection<SDDocumentSource> docs = null;
                    if (this.endpoint.getWebService().hasWsdlFile()) {
                        URL pkgedWsdl;
                        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                        ApplicationRegistry appRegistry = wscImpl.getApplicationRegistry();
                        ApplicationInfo appInfo = appRegistry.get(this.endpoint.getBundleDescriptor().getApplication().getRegistrationName());
                        URI deployedDir = appInfo.getSource().getURI();
                        if (deployedDir != null) {
                            if (this.endpoint.getBundleDescriptor().getApplication().isVirtual()) {
                                pkgedWsdl = deployedDir.resolve(this.endpoint.getWebService().getWsdlFileUri()).toURL();
                            } else {
                                String moduleUri1 = this.endpoint.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
                                String moduleUri = FileUtils.makeFriendlyFilenameExtension((String)moduleUri1);
                                pkgedWsdl = deployedDir.resolve(moduleUri + "/" + this.endpoint.getWebService().getWsdlFileUri()).toURL();
                            }
                        } else {
                            pkgedWsdl = this.endpoint.getWebService().getWsdlFileUrl();
                        }
                        if (pkgedWsdl != null) {
                            primaryWsdl = SDDocumentSource.create((URL)pkgedWsdl);
                            docs = wsu.getWsdlsAndSchemas(pkgedWsdl);
                        }
                    }
                    JAXWSContainer container = new JAXWSContainer(null, this.endpoint);
                    URL catalogURL = clazz.getResource("/" + this.endpoint.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
                    boolean mtomEnabled = wsu.getMtom(this.endpoint);
                    WSBinding binding = null;
                    ArrayList<Object> wsFeatures = new ArrayList<Object>();
                    if (mtomEnabled) {
                        int mtomThreshold = this.endpoint.getMtomThreshold() != null ? Integer.parseInt(this.endpoint.getMtomThreshold()) : 0;
                        MTOMFeature mtom = new MTOMFeature(true, mtomThreshold);
                        wsFeatures.add(mtom);
                    }
                    Addressing addressing = this.endpoint.getAddressing();
                    if (this.endpoint.getAddressing() != null) {
                        AddressingFeature addressingFeature = new AddressingFeature(addressing.isEnabled(), addressing.isRequired(), this.getResponse(addressing.getResponses()));
                        wsFeatures.add(addressingFeature);
                    }
                    binding = wsFeatures.size() > 0 ? BindingID.parse((String)givenBinding).createBinding(wsFeatures.toArray(new WebServiceFeature[wsFeatures.size()])) : BindingID.parse((String)givenBinding).createBinding();
                    wsu.configureJAXWSServiceHandlers(this.endpoint, this.endpoint.getProtocolBinding(), binding);
                    InstanceResolverImpl ir = InstanceResolver.createFromInstanceResolverAnnotation(clazz);
                    if (ir == null) {
                        ir = new InstanceResolverImpl(clazz);
                    }
                    Invoker invoker = ir.createInvoker();
                    WSEndpoint wsep = WSEndpoint.create(clazz, (boolean)false, (Invoker)new EjbInvokerImpl(clazz, invoker, this.webServiceEndpointServant, this.wsCtxt), (QName)this.endpoint.getServiceName(), (QName)this.endpoint.getWsdlPort(), (Container)container, (WSBinding)binding, (SDDocumentSource)primaryWsdl, docs, (URL)catalogURL);
                    String uri = this.endpoint.getEndpointAddressUri();
                    Object object = urlPattern = uri.startsWith("/") ? uri : "/" + uri;
                    if (this.adapterList == null) {
                        this.adapterList = new ServletAdapterList();
                    }
                    if ((obj = this.adapterList.createAdapter(this.endpoint.getName(), (String)urlPattern, wsep)) instanceof ServletAdapter) {
                        this.adapter = (ServletAdapter)ServletAdapter.class.cast(obj);
                    }
                    this.handlersConfigured = true;
                }
                catch (Throwable t) {
                    LogHelper.log((Logger)logger, (Level)Level.SEVERE, (String)"AS-WSJSR109IMPL-00072", (Throwable)t, (Object[])new Object[]{this.endpoint.getName()});
                    this.adapter = null;
                }
            }
        }
        ejbRuntimeEndpointInfo = this;
        synchronized (ejbRuntimeEndpointInfo) {
            this.addWSContextInfo(this.wsCtxt);
            if (inv != null && inv instanceof EJBInvocation) {
                EJBInvocation ejbInv = (EJBInvocation)inv;
                ejbInv.setWebServiceContext((Object)this.wsCtxt);
            }
        }
        adapterInvInfo.setAdapter(this.adapter);
        return adapterInvInfo;
    }

    private void addWSContextInfo(WebServiceContextImpl wsCtxt) {
        WebServiceContextImpl wsc = null;
        EjbDescriptor bundle = this.endpoint.getEjbComponentImpl();
        for (ResourceReferenceDescriptor r : bundle.getResourceReferenceDescriptors()) {
            block3: {
                if (!r.isWebServiceContext()) continue;
                try {
                    InitialContext ic = new InitialContext();
                    wsc = (WebServiceContextImpl)ic.lookup("java:comp/env/" + r.getName());
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block3;
                    logger.log(Level.FINE, "AS-WSJSR109IMPL-00050", t);
                }
            }
            if (wsc == null) continue;
            wsc.setContextDelegate(wsCtxt.getContextDelegate());
        }
    }

    public synchronized void initRuntimeInfo(ServletAdapterList list) throws Exception {
        AdapterInvocationInfo aInfo = null;
        try {
            this.adapterList = list;
            aInfo = (AdapterInvocationInfo)this.prepareInvocation(true);
        }
        finally {
            if (aInfo != null) {
                this.releaseImplementor(aInfo.getInv());
            }
        }
    }

    public InvocationManager getInvocationManager() {
        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
        return wscImpl.getInvocationManager();
    }

    public void releaseImplementor(ComponentInvocation inv) {
        this.container.endInvocation(inv);
    }

    public EjbMessageDispatcher getMessageDispatcher() {
        if (this.messageDispatcher == null) {
            this.messageDispatcher = new Ejb3MessageDispatcher();
        }
        return this.messageDispatcher;
    }

    public EjbEndpointFacade getContainer() {
        return this.container;
    }

    private AddressingFeature.Responses getResponse(String s) {
        if (s != null) {
            return Enum.valueOf(AddressingFeature.Responses.class, s);
        }
        return AddressingFeature.Responses.ALL;
    }
}

