/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.glassfish.appclient.client.acc.config.LogService;
import org.glassfish.main.jul.GlassFishLogger;

public class ACCLogger
extends GlassFishLogger {
    private static final String ACC_LOGGER_NAME = "GlassFish.ACC";
    private static final Level DEFAULT_ACC_LOG_LEVEL = Level.INFO;

    public ACCLogger(LogService logService) throws IOException {
        super(ACC_LOGGER_NAME);
        this.init(logService);
    }

    private void init(LogService logService) throws IOException {
        Level level = ACCLogger.chooseLevel(logService);
        Handler configuredFileHandler = ACCLogger.createHandler(logService, level);
        ResourceBundle rb = ResourceBundle.getBundle(ACCLogger.class.getPackage().getName() + ".LogStrings");
        Enumeration<String> names = LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            String loggerName = names.nextElement();
            Logger logger = LogManager.getLogManager().getLogger(loggerName);
            if (logger == null) {
                String msg = MessageFormat.format(rb.getString("appclient.nullLogger"), loggerName);
                if (level.intValue() > Level.CONFIG.intValue()) continue;
                System.err.println(msg);
                continue;
            }
            ACCLogger.reviseLogger(logger, level, configuredFileHandler);
        }
    }

    private static Level chooseLevel(LogService logService) {
        String configLevelText;
        Level level = DEFAULT_ACC_LOG_LEVEL;
        if (logService != null && (configLevelText = logService.getLevel()) != null && !configLevelText.isEmpty()) {
            try {
                level = Level.parse(configLevelText);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(ACCLogger.class.getName()).warning("Logger.Level = " + configLevelText + "??");
            }
        }
        return level;
    }

    private static Handler createHandler(LogService logService, Level level) throws IOException {
        String filePath;
        FileHandler handler = null;
        String string = filePath = logService == null ? null : logService.getFile();
        if (filePath == null || filePath.equals("")) {
            return null;
        }
        handler = new FileHandler(filePath, true);
        handler.setFormatter(new SimpleFormatter());
        handler.setLevel(level);
        File lockFile = new File(filePath + ".lck");
        lockFile.deleteOnExit();
        return handler;
    }

    private static void reviseLogger(Logger logger, Level level, Handler handler) {
        if (!logger.isLoggable(level)) {
            logger.setLevel(level);
        }
        if (handler != null) {
            logger.addHandler(handler);
        }
    }
}

