/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.model;

import com.sun.jdo.api.persistence.model.RuntimeModel;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;

public class DeploymentDescriptorModel
extends RuntimeModel {
    private final ClassLoader classLoader;
    private final NameMapper nameMapper;
    public static final String SIGNATURE = "$RCSfile: DeploymentDescriptorModel.java,v $ $Revision: 1.2 $";

    public DeploymentDescriptorModel(NameMapper nameMapper, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.nameMapper = nameMapper;
    }

    protected BufferedInputStream getInputStreamForResource(String className, ClassLoader classLoader, String resourceName) {
        return super.getInputStreamForResource(className, this.classLoader, resourceName);
    }

    protected String findPenultimateSuperclass(String className) {
        return this.isPCClassName(className) ? className : super.findPenultimateSuperclass(className);
    }

    protected String getSuperclass(String className) {
        return this.isPCClassName(className) ? "java.lang.Object" : super.getSuperclass(className);
    }

    protected BufferedOutputStream createFile(String className, String baseFileName, String extension) throws IOException {
        BufferedOutputStream outputStream = super.createFile(className, baseFileName, extension);
        if (outputStream != null) {
            return outputStream;
        }
        throw new UnsupportedOperationException();
    }

    protected void deleteFile(String className, String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object getClass(String className, ClassLoader classLoader) {
        String testClass = className;
        if (className != null) {
            String ejbName;
            String string = ejbName = this.isPCClassName(className) ? this.getEjbName(className) : className;
            if (this.nameMapper.isEjbName(ejbName)) {
                testClass = this.nameMapper.getAbstractBeanClassForEjbName(ejbName);
            } else {
                String keyClass = this.nameMapper.getKeyClassForPersistenceKeyClass(className);
                if (keyClass != null) {
                    if (2 == this.getPersistenceKeyClassType(className)) {
                        if (this.isPrimitive(keyClass)) {
                            return JavaTypeHelper.getPrimitiveClass((String)keyClass);
                        }
                        if (this.isByteArray(keyClass) || keyClass.endsWith("[]")) {
                            return byte[].class;
                        }
                    }
                    testClass = keyClass;
                }
            }
        }
        return super.getClass(testClass, this.classLoader);
    }

    public Object getConstructor(String className, String[] argTypeNames) {
        if (2 == this.getPersistenceKeyClassType(className) && Arrays.equals(argTypeNames, NO_ARGS)) {
            return new MemberWrapper(className, null, 1, (Class)this.getClass(className));
        }
        Object returnObject = super.getConstructor(className, argTypeNames);
        if (returnObject instanceof Constructor) {
            return new MemberWrapper((Constructor)returnObject);
        }
        return returnObject;
    }

    public Object getMethod(String className, String methodName, String[] argTypeNames) {
        int keyClassType = this.getPersistenceKeyClassType(className);
        Object returnObject = null;
        if (this.isPCClassName(className) && (methodName.equals("readObject") && Arrays.equals(argTypeNames, DeploymentDescriptorModel.getReadObjectArgs()) || methodName.equals("writeObject") && Arrays.equals(argTypeNames, DeploymentDescriptorModel.getWriteObjectArgs()))) {
            returnObject = new MemberWrapper(methodName, Void.TYPE, 2, (Class)this.getClass(className));
        }
        if (3 == keyClassType || 2 == keyClassType) {
            if (methodName.equals("equals") && Arrays.equals(argTypeNames, DeploymentDescriptorModel.getEqualsArgs())) {
                returnObject = new MemberWrapper(methodName, Boolean.TYPE, 1, (Class)this.getClass(className));
            } else if (methodName.equals("hashCode") && Arrays.equals(argTypeNames, NO_ARGS)) {
                returnObject = new MemberWrapper(methodName, Integer.TYPE, 1, (Class)this.getClass(className));
            }
        }
        if (returnObject == null && (returnObject = super.getMethod(className, methodName, argTypeNames)) instanceof Method) {
            returnObject = new MemberWrapper((Method)returnObject);
        }
        return returnObject;
    }

    public Object getInheritedMethod(String className, String methodName, String[] argTypeNames) {
        return 2 == this.getPersistenceKeyClassType(className) ? this.getMethod(className, methodName, argTypeNames) : super.getInheritedMethod(className, methodName, argTypeNames);
    }

    public List getFields(String className) {
        EjbCMPEntityDescriptor descriptor = this.getCMPDescriptor(className);
        String testClass = className;
        if (descriptor != null) {
            ArrayList<String> returnList = new ArrayList<String>();
            for (FieldDescriptor element : descriptor.getFieldDescriptors()) {
                returnList.add(element.getName());
            }
            return returnList;
        }
        String ejbName = this.nameMapper.getEjbNameForPersistenceKeyClass(className);
        switch (this.getPersistenceKeyClassType(className)) {
            case 1: {
                testClass = this.nameMapper.getKeyClassForEjbName(ejbName);
                break;
            }
            case 2: {
                return Arrays.asList(this.getCMPDescriptor(ejbName).getPrimaryKeyFieldDesc().getName());
            }
            case 3: {
                String pcClassName = this.nameMapper.getPersistenceClassForEjbName(ejbName);
                PersistenceFieldElement[] fields = this.getPersistenceClass(pcClassName).getFields();
                int count = fields != null ? fields.length : 0;
                for (int i = 0; i < count; ++i) {
                    PersistenceFieldElement pfe = fields[i];
                    if (!pfe.isKey()) continue;
                    return Arrays.asList(pfe.getName());
                }
                break;
            }
        }
        return super.getFields(testClass);
    }

    public List getAllFields(String className) {
        return 2 == this.getPersistenceKeyClassType(className) ? this.getFields(className) : super.getAllFields(className);
    }

    public Object getField(String className, String fieldName) {
        if (className == null) {
            return null;
        }
        String testClass = className;
        Object returnObject = null;
        boolean isPCClass = this.isPCClassName(className);
        boolean isPKClassName = false;
        String searchClassName = className;
        String searchFieldName = fieldName;
        if (isPCClass) {
            searchFieldName = this.nameMapper.getEjbFieldForPersistenceField(className, fieldName);
            searchClassName = this.getEjbName(className);
        } else {
            String ejbName = this.nameMapper.getEjbNameForPersistenceKeyClass(className);
            switch (this.getPersistenceKeyClassType(className)) {
                case 2: {
                    testClass = ejbName;
                    searchClassName = ejbName;
                    isPKClassName = true;
                    break;
                }
                case 3: {
                    testClass = this.nameMapper.getPersistenceClassForEjbName(ejbName);
                    isPCClass = true;
                    isPKClassName = true;
                }
            }
        }
        if (this.nameMapper.isEjbName(searchClassName)) {
            searchClassName = this.nameMapper.getAbstractBeanClassForEjbName(searchClassName);
        }
        if ((returnObject = super.getField(searchClassName, searchFieldName)) == null) {
            returnObject = this.getFieldWrapper(testClass, searchFieldName);
        } else if (returnObject instanceof Field) {
            returnObject = new MemberWrapper((Field)returnObject);
        }
        if (isPCClass) {
            returnObject = this.updateFieldWrapper((MemberWrapper)returnObject, testClass, fieldName);
        }
        if (isPKClassName && returnObject instanceof MemberWrapper) {
            ((MemberWrapper)returnObject).modifiers = 1;
        }
        return returnObject;
    }

    public String getFieldType(String className, String fieldName) {
        String returnType = super.getFieldType(className, fieldName);
        if (!this.isCollection(returnType) && this.isPCClassName(className)) {
            String ejbField;
            String ejbName = this.nameMapper.getEjbNameForPersistenceClass(className);
            if (this.nameMapper.isGeneratedEjbRelationship(ejbName, ejbField = this.nameMapper.getEjbFieldForPersistenceField(className, fieldName))) {
                String[] inverse = this.nameMapper.getEjbFieldForGeneratedField(ejbName, ejbField);
                returnType = this.nameMapper.getPersistenceClassForEjbName(inverse[0]);
            }
            if (this.nameMapper.isLocalInterface(returnType)) {
                returnType = this.nameMapper.getPersistenceClassForLocalInterface(className, fieldName, returnType);
            }
        }
        return returnType;
    }

    public String getDeclaringClass(Object memberElement) {
        if (memberElement != null && memberElement instanceof MemberWrapper) {
            Class<?> classElement = ((MemberWrapper)memberElement).getDeclaringClass();
            return classElement != null ? classElement.getName() : null;
        }
        return super.getDeclaringClass(memberElement);
    }

    public int getModifiers(Object memberElement) {
        if (memberElement != null && memberElement instanceof MemberWrapper) {
            return ((MemberWrapper)memberElement).getModifiers();
        }
        return super.getModifiers(memberElement);
    }

    public int getModifiersForClass(String className) {
        int modifiers = super.getModifiersForClass(className);
        if (this.isPCClassName(className)) {
            modifiers &= 0xFFFFFBFF;
        } else if (this.nameMapper.getKeyClassForPersistenceKeyClass(className) != null) {
            modifiers |= 8;
        }
        return modifiers;
    }

    public boolean isValidKeyType(String className, String fieldName) {
        return 2 == this.getPersistenceKeyClassType(className) && this.isPrimitive(className, fieldName) ? false : super.isValidKeyType(className, fieldName);
    }

    protected Class getTypeObject(Object element) {
        Class<?> type = super.getTypeObject(element);
        if (element != null && element instanceof MemberWrapper) {
            type = ((MemberWrapper)element).getType();
        }
        return type;
    }

    protected ClassLoader findClassLoader(String className, ClassLoader classLoader) {
        return this.classLoader;
    }

    private boolean isPCClassName(String className) {
        return this.getEjbName(className) != null;
    }

    private String getEjbName(String className) {
        return this.nameMapper.getEjbNameForPersistenceClass(className);
    }

    private EjbCMPEntityDescriptor getCMPDescriptor(String className) {
        String descriptorName = this.isPCClassName(className) ? this.getEjbName(className) : className;
        return this.nameMapper.getDescriptorForEjbName(descriptorName);
    }

    private int getPersistenceKeyClassType(String className) {
        String ejbName;
        int returnValue = -1;
        if (this.getCMPDescriptor(className) == null && (ejbName = this.nameMapper.getEjbNameForPersistenceKeyClass(className)) != null) {
            returnValue = this.nameMapper.getKeyClassTypeForEjbName(ejbName);
        }
        return returnValue;
    }

    private MemberWrapper getFieldWrapper(String className, String fieldName) {
        EjbCMPEntityDescriptor descriptor = this.getCMPDescriptor(className);
        if (descriptor == null) {
            return null;
        }
        PersistenceDescriptor persistenceDescriptor = descriptor.getPersistenceDescriptor();
        if (persistenceDescriptor == null) {
            return null;
        }
        Class fieldType = null;
        try {
            fieldType = persistenceDescriptor.getTypeFor(fieldName);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return fieldType == null ? null : new MemberWrapper(fieldName, fieldType, 2, (Class)this.getClass(className));
    }

    private MemberWrapper updateFieldWrapper(MemberWrapper returnObject, String className, String fieldName) {
        if (returnObject == null) {
            PersistenceFieldElement field = this.getPersistenceFieldInternal(className, fieldName);
            if (field == null) {
                return null;
            }
            String ejbName = this.getEjbName(className);
            String ejbFieldName = this.nameMapper.getEjbFieldForPersistenceField(className, fieldName);
            if (field.isKey() && ejbName != null && this.nameMapper.getKeyClassTypeForEjbName(ejbName) == 3) {
                returnObject = new MemberWrapper(ejbFieldName, Long.class, 2, (Class)this.getClass(className));
            } else if (field instanceof RelationshipElement && this.nameMapper.isGeneratedEjbRelationship(ejbName, ejbFieldName)) {
                RelationshipElement rel = (RelationshipElement)field;
                Class classType = null;
                if (rel.getUpperBound() > 1) {
                    classType = HashSet.class;
                } else {
                    String[] inverse = this.nameMapper.getEjbFieldForGeneratedField(ejbName, ejbFieldName);
                    classType = (Class)this.getClass(inverse[0]);
                }
                if (classType != null) {
                    returnObject = new MemberWrapper(ejbFieldName, classType, 2, (Class)this.getClass(className));
                }
            } else if (ejbFieldName.startsWith("thisVersionFieldWasGeneratedByTheNameMapper") && this.nameMapper.isGeneratedField(ejbName, ejbFieldName)) {
                returnObject = new MemberWrapper(ejbFieldName, Long.TYPE, 2, (Class)this.getClass(className));
            } else {
                return null;
            }
        }
        if (!this.isPersistentTypeAllowed(this.getType(returnObject), this.classLoader) && this.isSerializable(returnObject)) {
            returnObject.setType(byte[].class);
        }
        return returnObject;
    }

    private class MemberWrapper {
        private final String name;
        private Class<?> type;
        private int modifiers;
        private final Class<?> declaringClass;

        private MemberWrapper(Member member) {
            this(member.getName(), member instanceof Field ? ((Field)member).getType() : (member instanceof Method ? ((Method)member).getReturnType() : null), member.getModifiers(), member.getDeclaringClass());
        }

        private MemberWrapper(String name, Class<?> type, int modifiers, Class<?> declaringClass) {
            this.name = name;
            this.type = type;
            this.modifiers = modifiers;
            this.declaringClass = declaringClass;
        }

        private Class<?> getType() {
            return this.type;
        }

        private void setType(Class<?> type) {
            this.type = type;
        }

        private String getName() {
            return this.name;
        }

        private int getModifiers() {
            return this.modifiers;
        }

        private Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public String toString() {
            return this.getName();
        }
    }
}

