/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.remote.reader.ProprietaryReaderFactory;
import com.sun.enterprise.admin.remote.writer.ProprietaryWriterFactory;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;
import java.io.PrintStream;
import java.net.ConnectException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.AsadminInput;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.glassfish.main.jdke.props.SystemProperties;
import org.glassfish.main.jul.GlassFishLogManager;
import org.glassfish.main.jul.GlassFishLogManagerInitializer;
import org.glassfish.main.jul.cfg.GlassFishLogManagerConfiguration;
import org.glassfish.main.jul.cfg.LoggingProperties;
import org.glassfish.main.jul.formatter.GlassFishLogFormatter;
import org.glassfish.main.jul.handler.BlockingExternallyManagedLogHandler;

public class AdminMain {
    private static final Environment env = new Environment();
    private static final int SUCCESS = 0;
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int WARNING = 4;
    private static final String ADMIN_CLI_LOGGER = "com.sun.enterprise.admin.cli";
    private static final String[] SYS_PROPERTIES_TO_SET_FROM_ASENV = new String[]{GlassFishVariable.INSTALL_ROOT.getSystemPropertyName(), GlassFishVariable.CONFIG_ROOT.getSystemPropertyName(), GlassFishVariable.PRODUCT_ROOT.getSystemPropertyName()};
    private static final LocalStringsImpl strings = new LocalStringsImpl(AdminMain.class);
    private final Path installRoot = GFLauncherUtils.getInstallDir().toPath();
    private String modulePath;
    private String classPath;
    private String className;
    private String command;
    private ProgramOptions po;
    private CLIContainer cliContainer;
    private Logger logger;

    protected Path getInstallRoot() {
        return this.installRoot;
    }

    private ClassLoader getExtensionClassLoader(Set<File> extensions) {
        ClassLoader ecl = this.getClass().getClassLoader();
        if (extensions == null || extensions.isEmpty()) {
            return ecl;
        }
        PrivilegedAction<ClassLoader> action = () -> {
            try {
                return new DirectoryClassLoader(extensions, ecl);
            }
            catch (RuntimeException ex) {
                throw new Error(strings.get("ExtDirFailed", new Object[]{extensions}), ex);
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected Set<File> getExtensions() {
        HashSet<File> locations = new HashSet<File>();
        File ext = this.installRoot.resolve(Path.of("lib", "asadmin")).toFile();
        if (!ext.isDirectory()) {
            throw new Error(strings.get("ExtDirMissing", new Object[]{ext}));
        }
        locations.add(ext);
        String envClasspath = System.getenv("ASADMIN_CLASSPATH");
        if (envClasspath == null) {
            System.err.println("The ASADMIN_CLASSPATH environment variable is not set. Adding whole modules directory as a default.");
            File modules = this.getInstallRoot().resolve("modules").toFile();
            if (modules.isDirectory()) {
                locations.add(modules);
            }
        } else {
            for (String path : envClasspath.split(File.pathSeparator)) {
                File file = new File(path);
                if (!file.exists()) continue;
                locations.add(file);
            }
        }
        return locations;
    }

    protected String getCommandName() {
        return "nadmin";
    }

    public static void main(String[] args) {
        AdminMain adminMain = new AdminMain();
        int code = adminMain.doMain(args);
        System.exit(code);
    }

    protected final int doMain(String[] args) {
        Runtime.Version version = Runtime.version();
        if (version.feature() < 17) {
            System.err.println(strings.get("OldJdk", new Object[]{17, version}));
            return 1;
        }
        SystemProperties.setProperty((String)"WALL_CLOCK_START", (String)Instant.now().toString(), (boolean)true);
        LoggingProperties logging = new LoggingProperties();
        logging.setProperty("handlers", BlockingExternallyManagedLogHandler.class.getName());
        if (this.isClassAndMethodDetectionRequired()) {
            logging.setProperty("org.glassfish.main.jul.classAndMethodDetection.enabled", "true");
        }
        GlassFishLogManager.getLogManager().reconfigure(new GlassFishLogManagerConfiguration(logging), this::configureLogging, null);
        Set<File> extensions = this.getExtensions();
        ClassLoader ecl = this.getExtensionClassLoader(extensions);
        Thread.currentThread().setContextClassLoader(ecl);
        Thread thread = new Thread(() -> {
            ProprietaryReaderFactory.getReader(Class.class, (String)"not/defined");
            ProprietaryWriterFactory.getWriter(Class.class);
        });
        thread.setDaemon(true);
        thread.start();
        this.cliContainer = new CLIContainer(ecl, extensions, this.logger);
        this.classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        this.modulePath = SmartFile.sanitize((String)System.getProperty("jdk.module.path"));
        this.className = AdminMain.class.getName();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, String.valueOf(this.getClass()) + "\nModulePath: {0}\nClasspath: {1}\nExtensions: {2}\nArguments: {3}", new Object[]{this.modulePath, this.classPath, ecl, Arrays.toString(args)});
        }
        if (args.length == 0) {
            args = new String[]{"multimode"};
        } else if (args[0].equals("-V")) {
            args = new String[]{"version"};
        }
        this.command = args[0];
        int exitCode = this.executeCommand(args);
        switch (exitCode) {
            case 0: {
                if (this.po.isTerse() || !this.logger.isLoggable(Level.FINE)) break;
                String key = this.po.isDetachedCommand() ? "CommandSuccessfulStarted" : "CommandSuccessful";
                this.logger.fine(strings.get(key, new Object[]{this.command}));
                break;
            }
            case 4: {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(strings.get("CommandSuccessfulWithWarnings", new Object[]{this.command}));
                }
                exitCode = 0;
                break;
            }
            default: {
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine(strings.get("CommandUnSuccessful", new Object[]{this.command}));
            }
        }
        CLIUtil.writeCommandToDebugLog(this.getCommandName(), env, args, exitCode);
        return exitCode;
    }

    private boolean isClassAndMethodDetectionRequired() {
        Formatter formatter = env.getLogFormatter();
        if (formatter instanceof GlassFishLogFormatter) {
            GlassFishLogFormatter gfFormatter = (GlassFishLogFormatter)formatter;
            return gfFormatter.isPrintSource();
        }
        return false;
    }

    public int executeCommand(String[] argv) {
        CLICommand cmd = null;
        try {
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                ParameterMap params = rcp.getOptions();
                this.po = new ProgramOptions(params, env);
                AdminMain.readAndMergeOptionsFromAuxInput(this.po);
                List<String> operands = rcp.getOperands();
                argv = (String[])operands.toArray(String[]::new);
            } else {
                this.po = new ProgramOptions(env);
            }
            this.po.toEnvironment(env);
            this.po.setModulePath(this.modulePath);
            this.po.setClassPath(this.classPath);
            this.po.setClassName(this.className);
            this.po.setCommandName(this.getCommandName());
            if (argv.length == 0) {
                argv = this.po.isHelp() ? new String[]{"help"} : new String[]{"multimode"};
            }
            this.command = argv[0];
            this.cliContainer.setEnvironment(env);
            this.cliContainer.setProgramOptions(this.po);
            cmd = CLICommand.getCommand(this.cliContainer, this.command);
            return cmd.execute(argv);
        }
        catch (CommandValidationException cve) {
            this.logError((Exception)((Object)cve));
            if (cmd == null) {
                this.printUsage();
            } else {
                this.logger.severe(cmd.getUsage());
            }
            return 1;
        }
        catch (InvalidCommandException ice) {
            this.logError((Exception)((Object)ice));
            try {
                this.po.setEcho(false);
                CLIUtil.displayClosestMatch(this.command, CLIUtil.getAllCommands(this.cliContainer, this.po, env), strings.get("ClosestMatchedLocalAndRemoteCommands"), this.logger);
            }
            catch (InvalidCommandException params) {
                // empty catch block
            }
            return 1;
        }
        catch (CommandException ce) {
            this.logError((Exception)((Object)ce));
            if (ce.getCause() instanceof ConnectException) {
                try {
                    CLIUtil.displayClosestMatch(this.command, CLIUtil.getLocalCommands(this.cliContainer), strings.get("ClosestMatchedLocalCommands"), this.logger);
                }
                catch (InvalidCommandException e) {
                    this.logger.info(strings.get("InvalidRemoteCommand", new Object[]{this.command}));
                }
            }
            return 1;
        }
    }

    private void configureLogging() {
        boolean trace = env.trace();
        boolean debug = env.debug();
        Logger cliLogger = Logger.getLogger(ADMIN_CLI_LOGGER);
        if (trace) {
            cliLogger.setLevel(Level.FINEST);
        } else if (debug) {
            cliLogger.setLevel(Level.FINER);
        } else {
            cliLogger.setLevel(Level.FINE);
        }
        cliLogger.setUseParentHandlers(false);
        Formatter formatter = env.getLogFormatter();
        CLILoggerHandler cliHandler = new CLILoggerHandler(formatter == null ? new CLILoggerFormatter() : formatter);
        cliHandler.setLevel(cliLogger.getLevel());
        cliLogger.addHandler(cliHandler);
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setUseParentHandlers(false);
        if (trace) {
            rootLogger.setLevel(cliLogger.getLevel());
        }
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
            handler.close();
        }
        rootLogger.addHandler(cliHandler);
        this.logger = cliLogger;
    }

    private void logError(Exception e) {
        if (env.trace() || env.debug()) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        } else {
            this.logger.log(Level.SEVERE, e.getMessage());
        }
    }

    private void printUsage() {
        this.logger.severe(strings.get("Usage.full", new Object[]{this.getCommandName()}));
    }

    private static void readAndMergeOptionsFromAuxInput(ProgramOptions progOpts) {
        String auxInput = progOpts.getAuxInput();
        if (auxInput == null || auxInput.isEmpty()) {
            return;
        }
        progOpts.setAuxInput(null);
        ParameterMap newParamMap = new ParameterMap();
        try {
            AsadminInput.InputReader reader = AsadminInput.reader((String)auxInput);
            Properties newOptions = (Properties)reader.settings().get("option");
            for (String propName : newOptions.stringPropertyNames()) {
                newParamMap.add((Object)propName, (Object)newOptions.getProperty(propName));
            }
            progOpts.updateOptions(newParamMap);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    static {
        GlassFishLogManagerInitializer.tryToSetAsDefault();
        Map systemProps = new ASenvPropertyReader().getProps();
        for (String prop : SYS_PROPERTIES_TO_SET_FROM_ASENV) {
            String val = (String)systemProps.get(prop);
            if (!AdminMain.isNotEmpty(val)) continue;
            SystemProperties.setProperty((String)prop, (String)val, (boolean)true);
        }
    }

    private static class CLILoggerHandler
    extends ConsoleHandler {
        private CLILoggerHandler(Formatter formatter) {
            this.setFormatter(formatter);
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            PrintStream ps = logRecord.getLevel() == Level.SEVERE ? System.err : System.out;
            ps.print(this.getFormatter().format(logRecord));
            ps.flush();
        }
    }

    private static class CLILoggerFormatter
    extends SimpleFormatter {
        private static final boolean TRACE = env.trace();

        private CLILoggerFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            Object[] parameters;
            if (record.getThrown() == null) {
                return this.formatMessage(record) + System.lineSeparator();
            }
            if (record.getParameters() == null) {
                parameters = new Object[]{record.getThrown()};
            } else {
                parameters = new Object[record.getParameters().length + 1];
                System.arraycopy(record.getParameters(), 0, parameters, 0, parameters.length - 1);
                parameters[parameters.length - 1] = record.getThrown();
            }
            record.setParameters(parameters);
            if (TRACE) {
                return super.format(record) + System.lineSeparator();
            }
            return this.formatMessage(record) + " " + record.getThrown().getLocalizedMessage() + System.lineSeparator();
        }
    }
}

