/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi.util;

import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.util.ECPApplicableTester;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

public final class ECPStaticApplicableTester
implements ECPApplicableTester {
    private final boolean singleValue;
    private final int priority;
    private final Class<?> supportedClassType;
    private final Class<? extends EObject> supportedEObject;
    private final String supportedFeature;

    public ECPStaticApplicableTester(boolean singleValue, int priority, Class<?> supportedClassType, Class<? extends EObject> supportedEObject, String supportedFeature) {
        this.singleValue = singleValue;
        this.priority = priority;
        this.supportedClassType = supportedClassType;
        this.supportedEObject = supportedEObject;
        this.supportedFeature = supportedFeature;
    }

    @Override
    @Deprecated
    public int isApplicable(IItemPropertyDescriptor itemPropertyDescriptor, EObject eObject) {
        return this.isApplicable(eObject, (EStructuralFeature)itemPropertyDescriptor.getFeature((Object)eObject));
    }

    @Override
    public int isApplicable(VDomainModelReference domainModelReference) {
        Iterator iterator = domainModelReference.getIterator();
        int count = 0;
        EStructuralFeature.Setting setting = null;
        while (iterator.hasNext()) {
            ++count;
            setting = (EStructuralFeature.Setting)iterator.next();
        }
        if (count != 1) {
            return -1;
        }
        return this.isApplicable(setting.getEObject(), setting.getEStructuralFeature());
    }

    @Override
    public int isApplicable(EObject eObject, EStructuralFeature feature) {
        if (this.isSingleValue() == feature.isMany()) {
            return -1;
        }
        if (EAttribute.class.isInstance(feature)) {
            if (this.checkAttributeInvalid((EAttribute)feature)) {
                return -1;
            }
        } else if (EReference.class.isInstance(feature)) {
            Class<EObject> instanceClass = feature.getEType().getInstanceClass();
            if (instanceClass == null) {
                instanceClass = EObject.class;
            }
            if (!this.getSupportedClassType().isAssignableFrom(instanceClass)) {
                return -1;
            }
        }
        if (this.getSupportedEObject().isInstance(eObject) && (this.getSupportedFeature() == null || feature.equals(eObject.eClass().getEStructuralFeature(this.getSupportedFeature())))) {
            return this.getPriority();
        }
        return -1;
    }

    private boolean checkAttributeInvalid(EAttribute attribute) {
        block10: {
            Class instanceClass = attribute.getEAttributeType().getInstanceClass();
            if (instanceClass == null) {
                return true;
            }
            if (Object.class.equals(this.getSupportedClassType())) {
                return false;
            }
            if (instanceClass.isPrimitive()) {
                try {
                    Class primitive = (Class)this.getSupportedClassType().getField("TYPE").get(null);
                    if (!primitive.equals(instanceClass)) {
                        return true;
                    }
                    break block10;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return true;
                }
                catch (SecurityException securityException) {
                    return true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return true;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return true;
                }
            }
            if (!this.getSupportedClassType().isAssignableFrom(instanceClass)) {
                return true;
            }
        }
        return false;
    }

    public boolean isSingleValue() {
        return this.singleValue;
    }

    public int getPriority() {
        return this.priority;
    }

    public Class<? extends EObject> getSupportedEObject() {
        return this.supportedEObject;
    }

    public String getSupportedFeature() {
        return this.supportedFeature;
    }

    public Class<?> getSupportedClassType() {
        return this.supportedClassType;
    }
}

