/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.exceptions.ECPProjectWithNameExistsException;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPProjectAware;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPObserverBus;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectContentChangedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectContentTouchedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectOpenClosedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectsChangedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPRepositoriesChangedObserver;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.ECPProjectImpl;
import org.eclipse.emf.ecp.internal.core.util.InternalUtil;
import org.eclipse.emf.ecp.internal.core.util.PropertiesStore;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.net4j.util.AdapterUtil;

public final class ECPProjectManagerImpl
extends PropertiesStore<InternalProject, ECPObserver>
implements ECPProjectManager,
ECPRepositoriesChangedObserver {
    private static final String PROJECT_FOLDERNAME = "projects";
    private boolean initializedProjects;
    private ECPObserverBus ecpObserverBus;

    public ECPProjectManagerImpl() {
        this.initializeFolder(null);
    }

    public ECPProjectManagerImpl(String sessionId) {
        this.initializeFolder(sessionId);
    }

    private void initializeFolder(String sessionId) {
        File stateLocation = Activator.getInstance().getStateLocation().toFile();
        this.setFolder(new File(stateLocation, PROJECT_FOLDERNAME));
        String finalFolderName = PROJECT_FOLDERNAME;
        if (sessionId != null) {
            finalFolderName = String.valueOf(finalFolderName) + "-" + sessionId;
        }
        this.setFolder(new File(stateLocation, finalFolderName));
    }

    public void setECPObserverBus(ECPObserverBus ecpObserverBus) {
        this.ecpObserverBus = ecpObserverBus;
    }

    @Override
    public ECPProject createProject(ECPProvider provider, String name) throws ECPProjectWithNameExistsException {
        return this.createProject(provider, name, ECPUtil.createProperties());
    }

    @Override
    public ECPProject createProject(ECPProvider provider, String name, ECPProperties properties) throws ECPProjectWithNameExistsException {
        if (this.projectExists(name)) {
            throw new ECPProjectWithNameExistsException("A project with name " + name + " already exists");
        }
        if (!provider.hasCreateProjectWithoutRepositorySupport()) {
            throw new UnsupportedOperationException("The provider " + provider.getLabel() + " doesn't support the creation of projects without an ECPRepository (aka offline project).");
        }
        ECPProjectImpl project = new ECPProjectImpl((InternalProvider)provider, name, properties);
        return this.createProject(project);
    }

    @Override
    public ECPProject createProject(ECPRepository repository, String name, ECPProperties properties) throws ECPProjectWithNameExistsException {
        if (this.projectExists(name)) {
            throw new ECPProjectWithNameExistsException("A project with name " + name + " already exists");
        }
        ECPProjectImpl project = new ECPProjectImpl(repository, name, properties);
        return this.createProject(project);
    }

    @Override
    public ECPProject createProject(ECPProject project, String name) {
        InternalProject internalProject = (InternalProject)project;
        InternalProject newProject = internalProject.clone(name);
        return this.createProject(newProject);
    }

    private boolean projectExists(String name) {
        return this.getProject(name) != null;
    }

    private ECPProject createProject(InternalProject project) {
        project.getProvider().handleLifecycle(project, InternalProvider.LifecycleEvent.CREATE);
        this.changeElements(null, Collections.singleton(project));
        return project;
    }

    @Override
    public InternalProject getProject(Object adaptable) {
        if (adaptable instanceof ECPProjectAware) {
            ECPProjectAware projectAware = (ECPProjectAware)adaptable;
            return (InternalProject)projectAware.getProject();
        }
        InternalProject result = this.getInternalProject(adaptable);
        if (result != null) {
            return result;
        }
        return (InternalProject)AdapterUtil.adapt((Object)adaptable, InternalProject.class);
    }

    private InternalProject getInternalProject(Object object) {
        for (ECPProvider provider : ECPUtil.getECPProviderRegistry().getProviders()) {
            InternalProvider internalProvider = (InternalProvider)ECPUtil.getResolvedElement(provider);
            ECPContainer modelContext = internalProvider.getModelContext(object);
            if (modelContext == null || !InternalProject.class.isInstance(modelContext)) continue;
            return (InternalProject)modelContext;
        }
        return null;
    }

    @Override
    public InternalProject getProject(String name) {
        return (InternalProject)this.getElement(name);
    }

    @Override
    public Collection<ECPProject> getProjects() {
        this.initializeProjects();
        return this.getElements();
    }

    private void initializeProjects() {
        if (!this.initializedProjects) {
            for (InternalProject project : this.getElements()) {
                if (!project.getProvider().modelExists(project)) {
                    project.close();
                    Activator.log(4, "Project Data was deleted since last start. Project is now closed.");
                    continue;
                }
                project.notifyProvider(InternalProvider.LifecycleEvent.INIT);
            }
            this.initializedProjects = true;
        }
    }

    public void changeProject(ECPProject project, boolean opened, boolean store) {
        if (store) {
            this.storeElement((InternalProject)project);
        }
        try {
            this.ecpObserverBus.notify(ECPProjectOpenClosedObserver.class).projectChanged(project, opened);
        }
        catch (RuntimeException ex) {
            Activator.log(ex);
        }
    }

    public void notifyObjectsChanged(ECPProject project, Collection<Object> objects, boolean structural) {
        Collection<Object> affected = this.ecpObserverBus.notify(ECPProjectContentChangedObserver.class).objectsChanged(project, objects);
        HashSet<Object> toUpdate = new HashSet<Object>(objects);
        if (affected != null) {
            toUpdate.addAll(affected);
        }
        this.ecpObserverBus.notify(ECPProjectContentTouchedObserver.class).contentTouched(project, toUpdate, structural);
    }

    @Override
    public void repositoriesChanged(Collection<ECPRepository> oldRepositories, Collection<ECPRepository> newRepositories) {
        Set<ECPRepository> addedRepositories = InternalUtil.getAddedElements(oldRepositories, newRepositories);
        Collection projects = this.getElements();
        for (ECPRepository repository : addedRepositories) {
            for (InternalProject project : projects) {
                if (project.isOpen() || project.getRepository() == null || !repository.getName().equals(project.getRepository().getName())) continue;
                project.undispose((InternalRepository)repository);
            }
        }
    }

    @Override
    protected void elementsChanged(Collection<InternalProject> oldElements, Collection<InternalProject> newElements) {
        super.elementsChanged(oldElements, newElements);
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.ecpObserverBus.register(this);
    }

    protected void doDeactivate() throws Exception {
        this.ecpObserverBus.unregister(this);
        super.doDeactivate();
    }

    @Override
    protected InternalProject loadElement(ObjectInput in) throws IOException {
        return new ECPProjectImpl(in);
    }

    @Override
    protected void notifyObservers(Collection<InternalProject> oldElements, Collection<InternalProject> newElements) throws Exception {
        this.ecpObserverBus.notify(ECPProjectsChangedObserver.class).projectsChanged(oldElements, newElements);
    }

    @Override
    protected boolean isRemoveDisposedElements() {
        return false;
    }
}

