/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.declaration;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.Constraint;
import org.eclipse.emf.edapt.declaration.DeclarationFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.declaration.Parameter;

public class OperationExtractor {
    public Operation extractOperation(Class c) {
        EdaptOperation operationAnnotation = c.getAnnotation(EdaptOperation.class);
        if (operationAnnotation != null) {
            Operation operation = DeclarationFactory.eINSTANCE.createOperation();
            operation.setImplementation(c);
            if (operationAnnotation.identifier().isEmpty()) {
                operation.setName(c.getName());
            } else {
                operation.setName(operationAnnotation.identifier());
            }
            operation.setLabel(operationAnnotation.label());
            operation.setDescription(operationAnnotation.description());
            if (c.getAnnotation(Deprecated.class) != null) {
                operation.setDeprecated(true);
            }
            AccessibleObject[] accessibleObjectArray = c.getFields();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = accessibleObjectArray[n2];
                this.addParameter(operation, field);
                ++n2;
            }
            accessibleObjectArray = c.getMethods();
            n = accessibleObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                AccessibleObject method = accessibleObjectArray[n2];
                this.addConstraint(operation, (Method)method);
                ++n2;
            }
            return operation;
        }
        return null;
    }

    private void addParameter(Operation operation, Field field) {
        EdaptParameter parameterAnnotation = field.getAnnotation(EdaptParameter.class);
        if (parameterAnnotation != null) {
            Parameter parameter = DeclarationFactory.eINSTANCE.createParameter();
            operation.getParameters().add((Object)parameter);
            if (parameterAnnotation.main()) {
                parameter.setMain(true);
                operation.getParameters().move(0, (Object)parameter);
            }
            parameter.setName(field.getName());
            parameter.setDescription(parameterAnnotation.description());
            Class type = this.setManyAndReturnType(parameter, field);
            parameter.setClassifier(this.getEcoreType(type));
        }
    }

    private Class setManyAndReturnType(Parameter parameter, Field field) {
        Class type = field.getType();
        if (type == List.class) {
            ParameterizedType pt;
            Type a;
            parameter.setMany(true);
            Type t = field.getGenericType();
            if (t instanceof ParameterizedType && (a = (pt = (ParameterizedType)t).getActualTypeArguments()[0]) instanceof Class) {
                type = (Class)a;
            }
        }
        return type;
    }

    private EClassifier getEcoreType(Class type) {
        if (type.getPackage() == EClass.class.getPackage()) {
            return EcorePackage.eINSTANCE.getEClassifier(type.getSimpleName());
        }
        for (EClassifier classifier : EcorePackage.eINSTANCE.getEClassifiers()) {
            if (classifier.getInstanceClass() != type) continue;
            return classifier;
        }
        return null;
    }

    private void addConstraint(Operation operation, Method method) {
        EdaptConstraint constraintAnnotation = method.getAnnotation(EdaptConstraint.class);
        if (constraintAnnotation != null) {
            Constraint constraint = DeclarationFactory.eINSTANCE.createConstraint();
            constraint.setName(method.getName());
            constraint.setDescription(constraintAnnotation.description());
            operation.getConstraints().add((Object)constraint);
            String restricts = constraintAnnotation.restricts();
            if (!restricts.isEmpty()) {
                constraint.setRestricts(operation.getParameter(restricts));
            }
        }
    }
}

