/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.table;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.view.spi.provider.ECPStringModifier;

public class DateCellStringTooltipModifier
implements ECPStringModifier {
    private final DateFormat dateInstance;

    public DateCellStringTooltipModifier() {
        Locale locale = Activator.getDefault().getLocaleProvider().getLocale();
        this.dateInstance = DateFormat.getDateInstance(2, locale);
    }

    public String modifyString(String text, EStructuralFeature.Setting setting) {
        if (setting != null) {
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            EClassifier eType = eStructuralFeature.getEType();
            if (XMLGregorianCalendar.class.isAssignableFrom(eType.getInstanceClass())) {
                XMLGregorianCalendar calendar = (XMLGregorianCalendar)setting.get(true);
                return this.dateInstance.format(calendar.toGregorianCalendar().getTime());
            }
            if (Date.class.isAssignableFrom(eType.getInstanceClass())) {
                Date date = (Date)setting.get(true);
                String string = this.dateInstance.format(date);
                return string;
            }
        }
        return text;
    }

    public double getPriority() {
        return 10.0;
    }
}

