/**
 * Copyright (c) 2011-2015 EclipseSource Muenchen GmbH and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Stefan Dirix - initial API and implementation
 */
package org.eclipse.emf.ecp.emf2web.json.controller.xtend;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.emf2web.controller.xtend.GenerationController;
import org.eclipse.emf.ecp.emf2web.controller.xtend.GenerationInfo;
import org.eclipse.emf.ecp.emf2web.json.generator.xtend.EcoreJsonGenerator;
import org.eclipse.emf.ecp.emf2web.json.generator.xtend.FormsJsonGenerator;
import org.eclipse.emf.ecp.emf2web.json.util.ReferenceHelperImpl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;

/**
 * @author Stefan Dirix <sdirix@eclipsesource.com>
 */
@SuppressWarnings("all")
public class JsonGenerationController implements GenerationController {
  public List<GenerationInfo> generate(final Collection<? extends VView> views) {
    LinkedList<GenerationInfo> _xblockexpression = null;
    {
      final LinkedList<GenerationInfo> result = new LinkedList<GenerationInfo>();
      final EcoreJsonGenerator modelGenerator = new EcoreJsonGenerator();
      final ReferenceHelperImpl helper = new ReferenceHelperImpl();
      final FormsJsonGenerator formsGenerator = new FormsJsonGenerator(helper);
      for (final VView view : views) {
        {
          String _ecorePath = view.getEcorePath();
          helper.setEcorePath(_ecorePath);
          final EClass eClass = view.getRootEClass();
          final String schemaIdentifier = eClass.getName();
          final String schemaFile = modelGenerator.generate(eClass);
          final GenerationInfo schemaInfo = new GenerationInfo(GenerationInfo.MODEL_TYPE, eClass, null, 
            (schemaIdentifier + "Model.json"), null);
          schemaInfo.setGeneratedString(schemaFile);
          result.add(schemaInfo);
          final TreeIterator<EObject> allContents = view.eAllContents();
          while (allContents.hasNext()) {
            {
              final EObject next = allContents.next();
              boolean _isInstance = VElement.class.isInstance(next);
              if (_isInstance) {
                VElement _cast = VElement.class.cast(next);
                VElement _cast_1 = VElement.class.cast(next);
                String _name = _cast_1.getName();
                _cast.setLabel(_name);
              }
            }
          }
          final String controllerFile = formsGenerator.generate(view);
          final GenerationInfo controllerInfo = new GenerationInfo(GenerationInfo.VIEW_TYPE, null, view, 
            (schemaIdentifier + "View.json"), null);
          controllerInfo.setGeneratedString(controllerFile);
          result.add(controllerInfo);
        }
      }
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
}
