/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.service;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.spi.view.template.service.ViewTemplateSupplier;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.template.model.VTControlValidationTemplate;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTTemplateFactory;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.validation.model.VTValidationFactory;
import org.eclipse.emf.ecp.view.template.style.validation.model.VTValidationStyleProperty;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="viewTemplate", service={VTViewTemplateProvider.class})
public class ViewTemplateProviderImpl
implements VTViewTemplateProvider {
    private final List<ViewTemplateSupplier> templateSuppliers = new LinkedList<ViewTemplateSupplier>();
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    void addViewTemplateSupplier(ViewTemplateSupplier viewTemplateSupplier) {
        this.templateSuppliers.add(viewTemplateSupplier);
    }

    void removeViewTemplateSupplier(ViewTemplateSupplier viewTemplateSupplier) {
        this.templateSuppliers.remove(viewTemplateSupplier);
    }

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Deprecated
    public VTViewTemplate getViewTemplate() {
        VTViewTemplate resultTemplate = VTTemplateFactory.eINSTANCE.createViewTemplate();
        HashSet referencedEcores = new HashSet();
        for (ViewTemplateSupplier supplier : this.templateSuppliers) {
            for (VTViewTemplate viewTemplate : supplier.getViewTemplates()) {
                referencedEcores.addAll(viewTemplate.getReferencedEcores());
                if (viewTemplate.getControlValidationConfiguration() != null) {
                    resultTemplate.setControlValidationConfiguration(viewTemplate.getControlValidationConfiguration());
                }
                resultTemplate.getStyles().addAll((Collection)viewTemplate.getStyles());
            }
        }
        resultTemplate.getReferencedEcores().addAll(referencedEcores);
        return resultTemplate;
    }

    public Set<VTStyleProperty> getStyleProperties(VElement vElement, ViewModelContext viewModelContext) {
        final LinkedHashMap<VTStyleProperty, Double> properties = new LinkedHashMap<VTStyleProperty, Double>();
        for (ViewTemplateSupplier supplier : this.templateSuppliers) {
            Map<VTStyleProperty, Double> supplierProperties = supplier.getStyleProperties(vElement, viewModelContext);
            for (VTStyleProperty generated : this.generateValidationStyleProperties(supplier.getViewTemplates())) {
                supplierProperties.put(generated, 1.0);
            }
            for (VTStyleProperty styleProperty : supplierProperties.keySet()) {
                double specificity = supplierProperties.get(styleProperty);
                VTStyleProperty savedStyleProperty = this.getSavedStyleProperty(styleProperty, properties.keySet());
                if (savedStyleProperty == null) {
                    this.reportConflictingProperties(styleProperty, specificity, properties);
                    properties.put(styleProperty, specificity);
                    continue;
                }
                if (!((Double)properties.get(savedStyleProperty) < specificity)) continue;
                properties.remove(savedStyleProperty);
                properties.put(styleProperty, specificity);
            }
        }
        TreeSet<VTStyleProperty> treeSet = new TreeSet<VTStyleProperty>(new Comparator<VTStyleProperty>(){

            @Override
            public int compare(VTStyleProperty o1, VTStyleProperty o2) {
                Double specificity1 = (Double)properties.get(o1);
                Double specificity2 = (Double)properties.get(o2);
                int result = specificity2.compareTo(specificity1);
                if (result != 0) {
                    return result;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        treeSet.addAll(properties.keySet());
        return treeSet;
    }

    private Set<VTStyleProperty> generateValidationStyleProperties(Collection<VTViewTemplate> viewTemplates) {
        LinkedHashSet<VTStyleProperty> result = new LinkedHashSet<VTStyleProperty>();
        for (VTViewTemplate template : viewTemplates) {
            if (template.getControlValidationConfiguration() == null) continue;
            VTValidationStyleProperty validationProperty = VTValidationFactory.eINSTANCE.createValidationStyleProperty();
            VTControlValidationTemplate validationConfig = template.getControlValidationConfiguration();
            for (EStructuralFeature configFeature : validationConfig.eClass().getEAttributes()) {
                EStructuralFeature propertyFeature = validationProperty.eClass().getEStructuralFeature(configFeature.getName());
                validationProperty.eSet(propertyFeature, validationConfig.eGet(configFeature));
            }
            result.add((VTStyleProperty)validationProperty);
        }
        return result;
    }

    private void reportConflictingProperties(VTStyleProperty property, double currentSpecificity, Map<VTStyleProperty, Double> properties) {
        if (property == null) {
            return;
        }
        if (properties == null) {
            return;
        }
        if (properties.isEmpty()) {
            return;
        }
        for (VTStyleProperty other : properties.keySet()) {
            if (!property.eClass().equals(other.eClass()) || property.equalStyles(other) || currentSpecificity != properties.get(other)) continue;
            this.reportService.report(new AbstractReport(MessageFormat.format("The VTStyleProperty '{0}' with specificity {1} is conflicting with property '{2}'. Therefore, it is not determind which of the two properties will be applied.", property, currentSpecificity, other), 2));
        }
    }

    private VTStyleProperty getSavedStyleProperty(VTStyleProperty style, Set<VTStyleProperty> properties) {
        if (style == null) {
            return null;
        }
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return null;
        }
        for (VTStyleProperty styleProperty : properties) {
            if (!styleProperty.getClass().equals(style.getClass()) || !styleProperty.equalStyles(style)) continue;
            return styleProperty;
        }
        return null;
    }

    @Deprecated
    public boolean hasControlValidationTemplate() {
        for (ViewTemplateSupplier supplier : this.templateSuppliers) {
            for (VTViewTemplate viewTemplate : supplier.getViewTemplates()) {
                if (viewTemplate.getControlValidationConfiguration() == null) continue;
                return true;
            }
        }
        return false;
    }
}

