/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event.mapper;

import java.util.HashMap;
import org.eclipse.equinox.internal.event.mapper.EventAdapter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class ServiceEventAdapter
extends EventAdapter {
    public static final String HEADER = "org/osgi/framework/ServiceEvent";
    public static final String UNREGISTERING = "UNREGISTERING";
    public static final String MODIFIED = "MODIFIED";
    public static final String REGISTERED = "REGISTERED";
    private ServiceEvent event;

    public ServiceEventAdapter(ServiceEvent event, EventAdmin eventAdmin) {
        super(eventAdmin);
        this.event = event;
    }

    public Event convert() {
        String typename = null;
        switch (this.event.getType()) {
            case 1: {
                typename = REGISTERED;
                break;
            }
            case 2: {
                typename = MODIFIED;
                break;
            }
            case 4: {
                typename = UNREGISTERING;
                break;
            }
            default: {
                return null;
            }
        }
        String topic = "org/osgi/framework/ServiceEvent/" + typename;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ServiceReference ref = this.event.getServiceReference();
        if (ref != null) {
            this.putServiceReferenceProperties(properties, ref);
        }
        properties.put("event", this.event);
        Event converted = new Event(topic, properties);
        return converted;
    }
}

