/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.equinox.internal.util.io.Externalizable;
import org.eclipse.equinox.internal.util.io.HashtableEntry;
import org.eclipse.equinox.internal.util.io.HashtableEnumerator;
import org.eclipse.equinox.internal.util.io.PDataStream;
import org.eclipse.equinox.internal.util.io.XObjectInputStream;

public class ExternalizableDictionary
extends Dictionary
implements Externalizable,
Cloneable {
    private static Class[] CLASSES;
    private HashtableEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private static int MIN_CAPACITY;
    ClassLoader loader;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.util.io.ExternalizableDictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        CLASSES = classArray;
        MIN_CAPACITY = 5;
    }

    public ExternalizableDictionary(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        if (initialCapacity > 0) {
            this.initTable(initialCapacity);
        }
    }

    private void initTable(int initialCapacity) {
        this.table = new HashtableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * this.loadFactor);
    }

    public ExternalizableDictionary(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ExternalizableDictionary() {
        this(101, 0.75f);
    }

    public ClassLoader setClassLaoder(ClassLoader loader) {
        ClassLoader tmp = this.loader;
        this.loader = loader;
        return tmp;
    }

    public ClassLoader setClassLoader(ClassLoader loader) {
        ClassLoader tmp = this.loader;
        this.loader = loader;
        return tmp;
    }

    public Class[] remoteInterfaces() {
        return CLASSES;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new HashtableEnumerator(this.table, true);
    }

    public synchronized Enumeration elements() {
        return new HashtableEnumerator(this.table, false);
    }

    private int hashCode(String key) {
        return key.toLowerCase().hashCode();
    }

    public synchronized Object get(Object key) {
        if (this.table != null) {
            HashtableEntry[] tab = this.table;
            int hash = this.hashCode((String)key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            HashtableEntry e = tab[index];
            while (e != null) {
                if (e.hash == hash && e.key.equalsIgnoreCase((String)key)) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        HashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        HashtableEntry[] newTable = new HashtableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            HashtableEntry old = oldTable[i];
            while (old != null) {
                HashtableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized Object put(Object key, Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.table == null) {
            this.initTable(MIN_CAPACITY);
        }
        try {
            HashtableEntry e;
            int index;
            int hash = this.hashCode((String)key);
            HashtableEntry[] tab = null;
            while (true) {
                tab = this.table;
                index = (hash & Integer.MAX_VALUE) % tab.length;
                e = tab[index];
                while (e != null) {
                    if (e.hash == hash && e.key.equalsIgnoreCase((String)key)) {
                        Object old = e.value;
                        e.value = value;
                        return old;
                    }
                    e = e.next;
                }
                if (this.count < this.threshold) break;
                this.rehash();
            }
            e = new HashtableEntry();
            e.hash = hash;
            e.key = (String)key;
            e.value = value;
            e.next = tab[index];
            tab[index] = e;
            ++this.count;
            return null;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Non string keys are not accepted!");
        }
    }

    public synchronized Object remove(Object key) throws IllegalArgumentException {
        if (this.table == null) {
            return null;
        }
        try {
            HashtableEntry[] tab = this.table;
            int hash = this.hashCode((String)key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            HashtableEntry e = tab[index];
            HashtableEntry prev = null;
            while (e != null) {
                if (e.hash == hash && e.key.equalsIgnoreCase((String)key)) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                    return e.value;
                }
                prev = e;
                e = e.next;
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Non string keys are not accepted!");
        }
    }

    public synchronized void clear() {
        if (this.table == null) {
            return;
        }
        int index = this.table.length;
        while (--index >= 0) {
            this.table[index] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            ExternalizableDictionary cmDict = (ExternalizableDictionary)super.clone();
            if (this.table != null) {
                cmDict.table = new HashtableEntry[this.table.length];
                int i = this.table.length;
                while (i-- > 0) {
                    HashtableEntry hashtableEntry = cmDict.table[i] = this.table[i] != null ? (HashtableEntry)this.table[i].clone() : null;
                }
            }
            return cmDict;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dictionary)) {
            return false;
        }
        Dictionary dict = (Dictionary)o;
        int max = this.size();
        if (dict.size() != max) {
            return false;
        }
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        int i = 0;
        while (i < max) {
            Object key = k.nextElement();
            Object value = e.nextElement();
            if (!value.equals(dict.get(key))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append('{');
        int i = 0;
        while (i <= max) {
            String s1 = (String)k.nextElement();
            String s2 = e.nextElement().toString();
            buf.append(s1);
            buf.append('=');
            buf.append(s2);
            if (i < max) {
                buf.append(',');
                buf.append(' ');
            }
            ++i;
        }
        buf.append('}');
        return ((Object)buf).toString();
    }

    public synchronized void writeObject(OutputStream os) throws Exception {
        Enumeration keys = this.keys();
        Enumeration values = this.elements();
        PDataStream.writeInt(this.size(), os);
        while (keys.hasMoreElements()) {
            PDataStream.writeUTF((String)keys.nextElement(), os);
            ExternalizableDictionary.writeValue(values.nextElement(), os);
        }
    }

    private static void writeValue(Object value, OutputStream os) throws IOException {
        if (value == null) {
            os.write(-1);
        } else {
            Class<?> valueClass = value.getClass();
            if (valueClass.isArray()) {
                os.write(1);
                int length = Array.getLength(value);
                PDataStream.writeInt(length, os);
                Class<?> componentType = valueClass.getComponentType();
                if (componentType.isPrimitive()) {
                    PDataStream.writeBoolean(true, os);
                    ExternalizableDictionary.writePrimitiveArray(componentType, value, length, os);
                } else {
                    PDataStream.writeBoolean(false, os);
                    PDataStream.writeUTF(componentType.getName(), os);
                    Object[] oArr = (Object[])value;
                    int i = 0;
                    while (i < length) {
                        ExternalizableDictionary.writeValue(oArr[i], os);
                        ++i;
                    }
                }
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.util.Vector");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (valueClass.equals(clazz)) {
                    os.write(2);
                    int size = ((Vector)value).size();
                    PDataStream.writeInt(size, os);
                    int i = 0;
                    while (i < size) {
                        ExternalizableDictionary.writeValue(((Vector)value).elementAt(i), os);
                        ++i;
                    }
                } else {
                    os.write(0);
                    ExternalizableDictionary.writeRealObject(value, valueClass, os);
                }
            }
        }
    }

    private static Object readValue(InputStream is, ClassLoader loader) throws Exception {
        byte type = (byte)is.read();
        if (type == -1) {
            return null;
        }
        Class<?> vClass = null;
        if (type == 2) {
            int length = PDataStream.readInt(is);
            Vector<Object> v = new Vector<Object>(length);
            int i = 0;
            while (i < length) {
                v.insertElementAt(ExternalizableDictionary.readValue(is, loader), i);
                ++i;
            }
            return v;
        }
        if (type == 0) {
            return ExternalizableDictionary.readRealObject((byte)is.read(), is, loader);
        }
        int length = PDataStream.readInt(is);
        boolean primitive = PDataStream.readBoolean(is);
        if (primitive) {
            return ExternalizableDictionary.readPrimitiveArray(length, is);
        }
        vClass = loader == null ? Class.forName(PDataStream.readUTF(is)) : loader.loadClass(PDataStream.readUTF(is));
        Object array = Array.newInstance(vClass, length);
        int i = 0;
        while (i < length) {
            Array.set(array, i, ExternalizableDictionary.readValue(is, loader));
            ++i;
        }
        return array;
    }

    public synchronized void readObject(InputStream is) throws Exception {
        int size = PDataStream.readInt(is);
        if (this.table == null) {
            if (size > 0) {
                this.initTable(size);
            } else {
                this.initTable(MIN_CAPACITY);
            }
        }
        int i = 0;
        while (i < size) {
            this.put(PDataStream.readUTF(is), ExternalizableDictionary.readValue(is, this.loader));
            ++i;
        }
    }

    private static void writePrimitiveArray(Class componentType, Object array, int length, OutputStream os) throws IOException {
        if (componentType.equals(Integer.TYPE)) {
            int[] ints = (int[])array;
            os.write(1);
            int i = 0;
            while (i < length) {
                PDataStream.writeInt(ints[i], os);
                ++i;
            }
        } else if (componentType.equals(Long.TYPE)) {
            os.write(2);
            long[] longs = (long[])array;
            int i = 0;
            while (i < length) {
                PDataStream.writeLong(longs[i], os);
                ++i;
            }
        } else if (componentType.equals(Byte.TYPE)) {
            os.write(3);
            os.write((byte[])array);
        } else if (componentType.equals(Boolean.TYPE)) {
            os.write(4);
            boolean[] booleans = (boolean[])array;
            int i = 0;
            while (i < length) {
                PDataStream.writeBoolean(booleans[i], os);
                ++i;
            }
        } else if (componentType.equals(Character.TYPE)) {
            os.write(5);
            char[] chars = (char[])array;
            int i = 0;
            while (i < length) {
                PDataStream.writeChar(chars[i], os);
                ++i;
            }
        } else if (componentType.equals(Short.TYPE)) {
            os.write(6);
            short[] shorts = (short[])array;
            int i = 0;
            while (i < length) {
                PDataStream.writeShort(shorts[i], os);
                ++i;
            }
        } else if (componentType.equals(Float.TYPE)) {
            os.write(7);
            float[] floats = (float[])array;
            int i = 0;
            while (i < length) {
                PDataStream.writeFloat(floats[i], os);
                ++i;
            }
        } else if (componentType.equals(Double.TYPE)) {
            os.write(8);
            double[] doubles = (double[])array;
            int i = 0;
            while (i < length) {
                PDataStream.writeDouble(doubles[i], os);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Unsupported Primitive Type: " + componentType);
        }
    }

    private static Object readPrimitiveArray(int length, InputStream is) throws IOException {
        byte type = (byte)is.read();
        if (type == 1) {
            int[] ints = new int[length];
            int i = 0;
            while (i < length) {
                ints[i] = PDataStream.readInt(is);
                ++i;
            }
            return ints;
        }
        if (type == 2) {
            long[] longs = new long[length];
            int i = 0;
            while (i < length) {
                longs[i] = PDataStream.readLong(is);
                ++i;
            }
            return longs;
        }
        if (type == 3) {
            byte[] bytes = new byte[length];
            is.read(bytes);
            return bytes;
        }
        if (type == 4) {
            boolean[] booleans = new boolean[length];
            int i = 0;
            while (i < length) {
                booleans[i] = PDataStream.readBoolean(is);
                ++i;
            }
            return booleans;
        }
        if (type == 5) {
            char[] chars = new char[length];
            int i = 0;
            while (i < length) {
                chars[i] = PDataStream.readChar(is);
                ++i;
            }
            return chars;
        }
        if (type == 6) {
            short[] shorts = new short[length];
            int i = 0;
            while (i < length) {
                shorts[i] = PDataStream.readShort(is);
                ++i;
            }
            return shorts;
        }
        if (type == 7) {
            float[] floats = new float[length];
            int i = 0;
            while (i < length) {
                floats[i] = PDataStream.readFloat(is);
                ++i;
            }
            return floats;
        }
        if (type == 8) {
            double[] doubles = new double[length];
            int i = 0;
            while (i < length) {
                doubles[i] = PDataStream.readDouble(is);
                ++i;
            }
            return doubles;
        }
        throw new IllegalArgumentException("Trying to read unsupported primitive type: " + type);
    }

    private static void writeRealObject(Object value, Class vClass, OutputStream os) throws IOException {
        block44: {
            try {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz)) {
                    os.write(0);
                    PDataStream.writeUTF((String)value, os);
                    break block44;
                }
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz2)) {
                    os.write(1);
                    PDataStream.writeInt((Integer)value, os);
                    break block44;
                }
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$4 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz3)) {
                    os.write(2);
                    PDataStream.writeLong((Long)value, os);
                    break block44;
                }
                Class<?> clazz4 = class$5;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$5 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz4)) {
                    os.write(3);
                    os.write(((Byte)value).byteValue());
                    break block44;
                }
                Class<?> clazz5 = class$6;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$6 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz5)) {
                    os.write(4);
                    PDataStream.writeBoolean((Boolean)value, os);
                    break block44;
                }
                Class<?> clazz6 = class$7;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$7 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz6)) {
                    os.write(5);
                    PDataStream.writeChar(((Character)value).charValue(), os);
                    break block44;
                }
                Class<?> clazz7 = class$8;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$8 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz7)) {
                    os.write(6);
                    PDataStream.writeShort((Short)value, os);
                    break block44;
                }
                Class<?> clazz8 = class$9;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$9 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz8)) {
                    os.write(7);
                    PDataStream.writeFloat(((Float)value).floatValue(), os);
                    break block44;
                }
                Class<?> clazz9 = class$10;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$10 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (vClass.equals(clazz9)) {
                    os.write(8);
                    PDataStream.writeDouble((Double)value, os);
                    break block44;
                }
                Class<?> clazz10 = class$11;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$11 = Class.forName("org.eclipse.equinox.internal.util.io.Externalizable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz10.isAssignableFrom(vClass)) {
                    os.write(11);
                    String name = vClass.getName();
                    PDataStream.writeUTF(name, os);
                    Externalizable tmp = (Externalizable)value;
                    tmp.writeObject(os);
                } else {
                    os.write(12);
                    ObjectOutputStream out = new ObjectOutputStream(os);
                    out.writeObject(value);
                }
            }
            catch (Exception exc) {
                throw new IOException(((Object)exc).toString());
            }
        }
    }

    private static Object readRealObject(byte type, InputStream is, ClassLoader loader) throws IOException {
        try {
            if (type == 0) {
                return PDataStream.readUTF(is);
            }
            if (type == 1) {
                return new Integer(PDataStream.readInt(is));
            }
            if (type == 2) {
                return new Long(PDataStream.readLong(is));
            }
            if (type == 3) {
                return new Byte((byte)is.read());
            }
            if (type == 4) {
                return PDataStream.readBoolean(is) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (type == 5) {
                return new Character(PDataStream.readChar(is));
            }
            if (type == 6) {
                return new Short(PDataStream.readShort(is));
            }
            if (type == 7) {
                return new Float(PDataStream.readFloat(is));
            }
            if (type == 8) {
                return new Double(PDataStream.readDouble(is));
            }
            if (type == 11) {
                String name = PDataStream.readUTF(is);
                Class<?> c = loader == null ? Class.forName(name) : loader.loadClass(name);
                Class<?> clazz = class$11;
                if (clazz == null) {
                    try {
                        clazz = class$11 = Class.forName("org.eclipse.equinox.internal.util.io.Externalizable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(c)) {
                    Externalizable obj = (Externalizable)c.newInstance();
                    obj.readObject(is);
                    return obj;
                }
                throw new IOException("Could not read object " + name);
            }
            if (type == 12) {
                ObjectInputStream in = loader == null ? new ObjectInputStream(is) : new XObjectInputStream(loader, is);
                return in.readObject();
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not find class " + ((Object)cnfe).toString());
        }
        catch (Exception exc) {
            throw exc instanceof IOException ? (IOException)exc : new IOException("Could not read object " + ((Object)exc).toString());
        }
        throw new IllegalArgumentException("Unsupported Typed Object: " + type);
    }

    public synchronized void copyFrom(Dictionary props) throws IllegalArgumentException {
        Enumeration keys = props.keys();
        Enumeration values = props.elements();
        while (keys.hasMoreElements()) {
            this.put(keys.nextElement(), values.nextElement());
        }
    }
}

